/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.tboxreasoner;

import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;

public class ReasonerStatementPattern {
    public static final ReasonerStatementPattern ANY_OBJECT_PROPERTY = new ReasonerStatementPattern(null, null, null);
    private final Resource subject;
    private final Property predicate;
    private final Resource object;
    private final String toString;

    public static ReasonerStatementPattern objectPattern(Property predicate) {
        return new ReasonerStatementPattern(null, predicate, null);
    }

    public static ReasonerStatementPattern objectPattern(Statement stmt) {
        if (!stmt.getObject().isResource()) {
            throw new IllegalArgumentException("Object of stmt must be a resource.");
        }
        return new ReasonerStatementPattern(stmt.getSubject(), stmt.getPredicate(), stmt.getObject().asResource());
    }

    private ReasonerStatementPattern(Resource subject, Property predicate, Resource object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.toString = this.buildToString();
    }

    public Property getPredicate() {
        return this.predicate;
    }

    public boolean matches(ReasonerStatementPattern that) {
        boolean sMatch = this.subject == null || that.subject == null || this.subject.equals((Object)that.subject);
        boolean pMatch = this.predicate == null || that.predicate == null || this.predicate.equals(that.predicate);
        boolean oMatch = this.object == null || that.object == null || this.object.equals((Object)that.object);
        return sMatch && pMatch && oMatch;
    }

    public List<Statement> matchStatementsFromModel(Model m) {
        m.enterCriticalSection(true);
        try {
            List list = m.listStatements(this.subject, this.predicate, (RDFNode)this.object).toList();
            return list;
        }
        finally {
            m.leaveCriticalSection();
        }
    }

    public String buildToString() {
        return "ReasonerStatementPattern[subject=" + (this.subject == null ? "*" : this.subject.toString()) + ", predicate=" + (this.predicate == null ? "*" : this.predicate.toString()) + ", object=" + (this.object == null ? "*" : this.object.toString()) + "]";
    }

    public String toString() {
        return this.toString;
    }
}

