/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.tboxreasoner;

import edu.cornell.mannlib.vitro.webapp.dao.jena.event.EditEvent;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.ReasonerConfiguration;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.ReasonerStatementPattern;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.TBoxChanges;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.TBoxReasonerDriver;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;

public class ConfiguredReasonerListener
implements ModelChangedListener {
    private static final Log log = LogFactory.getLog(ConfiguredReasonerListener.class);
    private final ReasonerConfiguration reasonerConfiguration;
    private final TBoxReasonerDriver reasonerDriver;
    private final DrivingPatternMap drivingPatternMap;
    private final AtomicReference<TBoxChanges> changeSet;
    private final AtomicBoolean suspended;

    public ConfiguredReasonerListener(ReasonerConfiguration reasonerConfiguration, TBoxReasonerDriver reasonerDriver) {
        this.reasonerConfiguration = reasonerConfiguration;
        this.reasonerDriver = reasonerDriver;
        this.drivingPatternMap = new DrivingPatternMap(reasonerConfiguration.getInferenceDrivingPatternAllowSet());
        this.changeSet = new AtomicReference<TBoxChanges>(new TBoxChanges());
        this.suspended = new AtomicBoolean();
    }

    public Suspension suspend() {
        if (!this.suspended.compareAndSet(false, true)) {
            throw new IllegalStateException("Listener is already suspended.");
        }
        return new Suspension();
    }

    public void addedStatement(Statement s) {
        this.tryAdd(s);
    }

    public void addedStatements(Statement[] statements) {
        for (Statement stmt : statements) {
            this.tryAdd(stmt);
        }
    }

    public void addedStatements(List<Statement> statements) {
        for (Statement stmt : statements) {
            this.tryAdd(stmt);
        }
    }

    public void addedStatements(StmtIterator statements) {
        for (Statement stmt : statements.toList()) {
            this.tryAdd(stmt);
        }
    }

    public void addedStatements(Model m) {
        for (Statement stmt : m.listStatements().toList()) {
            this.tryAdd(stmt);
        }
    }

    public void removedStatement(Statement s) {
        this.tryRemove(s);
    }

    public void removedStatements(Statement[] statements) {
        for (Statement stmt : statements) {
            this.tryRemove(stmt);
        }
    }

    public void removedStatements(List<Statement> statements) {
        for (Statement stmt : statements) {
            this.tryRemove(stmt);
        }
    }

    public void removedStatements(StmtIterator statements) {
        for (Statement stmt : statements.toList()) {
            this.tryRemove(stmt);
        }
    }

    public void removedStatements(Model m) {
        for (Statement stmt : m.listStatements().toList()) {
            this.tryRemove(stmt);
        }
    }

    public void notifyEvent(Model m, Object event) {
        EditEvent ee;
        log.debug((Object)"Notified of event.");
        if (event instanceof EditEvent && !(ee = (EditEvent)event).getBegin().booleanValue()) {
            log.debug((Object)"Notified of ending EditEvent.");
            TBoxChanges changes = this.changeSet.getAndSet(new TBoxChanges());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Change set: " + changes));
            }
            this.reasonerDriver.runSynchronizer(changes);
        }
    }

    public void tryAdd(Statement stmt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("try to add statement: " + stmt));
        }
        if (this.suspended.get()) {
            return;
        }
        if (this.isDataProperty(stmt)) {
            if (this.reasonOnAllDataProperties() || this.hasCardinalityPredicate(stmt)) {
                this.addIt(stmt);
                return;
            }
            return;
        }
        if (this.predicateIsInVitroNamespace(stmt) || this.statementMatchesDenyPattern(stmt)) {
            return;
        }
        if (this.thereAreNoDrivingPatterns() || this.statementMatchesDrivingPattern(stmt)) {
            this.addIt(stmt);
        }
    }

    public void tryRemove(Statement stmt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("try to remove statement: " + stmt));
        }
        if (this.suspended.get()) {
            return;
        }
        if (this.isDataProperty(stmt)) {
            if (this.reasonOnAllDataProperties() || this.hasCardinalityPredicate(stmt)) {
                this.removeIt(stmt);
                return;
            }
            return;
        }
        if (this.actOnObjectPropertyDeclarations() && this.declaresObjectProperty(stmt)) {
            this.deleteObjectProperty(stmt);
            return;
        }
        if (this.actOnDataPropertyDeclarations() && this.declaresDataProperty(stmt)) {
            this.deleteDataProperty(stmt);
            return;
        }
        if (this.statementMatchesDenyPattern(stmt)) {
            return;
        }
        if (this.thereAreNoDrivingPatterns() || this.statementMatchesDrivingPattern(stmt)) {
            this.removeIt(stmt);
        }
    }

    private boolean isDataProperty(Statement stmt) {
        return stmt.getObject().isLiteral();
    }

    private boolean reasonOnAllDataProperties() {
        return this.reasonerConfiguration.getReasonOnAllDatatypePropertyStatements();
    }

    private boolean predicateIsInVitroNamespace(Statement stmt) {
        return stmt.getPredicate().getURI().indexOf("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#") == 0;
    }

    private boolean statementMatchesDenyPattern(Statement stmt) {
        Set<ReasonerStatementPattern> denyPatterns = this.reasonerConfiguration.inferenceDrivingPatternDenySet;
        if (denyPatterns == null) {
            return false;
        }
        ReasonerStatementPattern stPat = ReasonerStatementPattern.objectPattern(stmt);
        for (ReasonerStatementPattern pat : denyPatterns) {
            if (!pat.matches(stPat)) continue;
            return true;
        }
        return false;
    }

    private boolean thereAreNoDrivingPatterns() {
        return this.reasonerConfiguration.inferenceDrivingPatternAllowSet == null;
    }

    private boolean statementMatchesDrivingPattern(Statement stmt) {
        List drivePatterns = (List)this.drivingPatternMap.get(stmt.getPredicate());
        if (drivePatterns == null) {
            return false;
        }
        ReasonerStatementPattern stPat = ReasonerStatementPattern.objectPattern(stmt);
        for (ReasonerStatementPattern pat : drivePatterns) {
            if (!pat.matches(stPat)) continue;
            return true;
        }
        return false;
    }

    private boolean actOnObjectPropertyDeclarations() {
        return this.reasonerConfiguration.getQueryForAllObjectProperties();
    }

    private boolean declaresObjectProperty(Statement stmt) {
        return stmt.getPredicate().equals(RDF.type) && stmt.getObject().equals(OWL.ObjectProperty);
    }

    private boolean actOnDataPropertyDeclarations() {
        return this.reasonerConfiguration.getQueryForAllDatatypeProperties();
    }

    private boolean declaresDataProperty(Statement stmt) {
        return stmt.getPredicate().equals(RDF.type) && stmt.getObject().equals(OWL.DatatypeProperty);
    }

    private void addIt(Statement stmt) {
        this.changeSet.get().addStatement(stmt);
    }

    private void removeIt(Statement stmt) {
        this.changeSet.get().removeStatement(stmt);
    }

    private void deleteObjectProperty(Statement stmt) {
        this.changeSet.get().deleteObjectProperty(stmt);
    }

    private void deleteDataProperty(Statement stmt) {
        this.changeSet.get().deleteDataProperty(stmt);
    }

    private boolean hasCardinalityPredicate(Statement stmt) {
        return stmt.getPredicate().equals(OWL.cardinality) || stmt.getPredicate().equals(OWL.minCardinality) || stmt.getPredicate().equals(OWL.maxCardinality);
    }

    public class DrivingPatternMap
    extends HashMap<Property, List<ReasonerStatementPattern>> {
        public DrivingPatternMap(Set<ReasonerStatementPattern> patternSet) {
            if (patternSet != null) {
                for (ReasonerStatementPattern pat : patternSet) {
                    Property p = pat.getPredicate();
                    if (!this.containsKey(p)) {
                        this.put(p, new LinkedList());
                    }
                    ((List)this.get(p)).add(pat);
                }
            }
        }
    }

    public class Suspension
    implements AutoCloseable {
        @Override
        public void close() {
            boolean wasSuspended = ConfiguredReasonerListener.this.suspended.compareAndSet(true, false);
            if (!wasSuspended) {
                log.warn((Object)"Listener was already not suspended.");
            }
        }
    }
}

