/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.startup;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StartupStatus {
    private static final Log log = LogFactory.getLog(StartupStatus.class);
    protected static final String ATTRIBUTE_NAME = "STARTUP_STATUS";
    private SynchronizedStatusItemList itemList = new SynchronizedStatusItemList();

    public static StartupStatus getBean(ServletContext ctx) {
        StartupStatus ss;
        Object o = ctx.getAttribute(ATTRIBUTE_NAME);
        if (o instanceof StartupStatus) {
            ss = (StartupStatus)o;
        } else {
            ss = new StartupStatus();
            ctx.setAttribute(ATTRIBUTE_NAME, (Object)ss);
        }
        return ss;
    }

    public void info(ServletContextListener listener, String message) {
        this.addItem(StatusItem.Level.INFO, listener, message, null);
    }

    public void info(ServletContextListener listener, String message, Throwable cause) {
        this.addItem(StatusItem.Level.INFO, listener, message, cause);
    }

    public void warning(ServletContextListener listener, String message) {
        this.addItem(StatusItem.Level.WARNING, listener, message, null);
    }

    public void warning(ServletContextListener listener, String message, Throwable cause) {
        this.addItem(StatusItem.Level.WARNING, listener, message, cause);
    }

    public void fatal(ServletContextListener listener, String message) {
        this.addItem(StatusItem.Level.FATAL, listener, message, null);
    }

    public void fatal(ServletContextListener listener, String message, Throwable cause) {
        this.addItem(StatusItem.Level.FATAL, listener, message, cause);
    }

    public void listenerNotExecuted(ServletContextListener listener) {
        this.addItem(StatusItem.Level.NOT_EXECUTED, listener, "Not executed - startup was aborted by a previous fatal error.", null);
    }

    public void listenerExecuted(ServletContextListener listener) {
        List<StatusItem> itemsForThisListener = this.getItemsForListener(listener);
        if (itemsForThisListener.isEmpty()) {
            this.addItem(StatusItem.Level.INFO, listener, "Ran successfully.", null);
        }
    }

    private void addItem(StatusItem.Level level, ServletContextListener source, String message, Throwable cause) {
        StatusItem item = new StatusItem(level, source, message, cause);
        this.itemList.add(item);
        String logMessage = "From " + item.getShortSourceName() + ": " + item.getMessage();
        if (item.getLevel() == StatusItem.Level.FATAL) {
            if (cause == null) {
                log.fatal((Object)logMessage);
            } else {
                log.fatal((Object)logMessage, cause);
            }
        } else if (item.getLevel() == StatusItem.Level.WARNING) {
            if (cause == null) {
                log.warn((Object)logMessage);
            } else {
                log.warn((Object)logMessage, cause);
            }
        } else if (cause == null) {
            log.info((Object)logMessage);
        } else {
            log.info((Object)logMessage, cause);
        }
    }

    public boolean allClear() {
        return this.getErrorItems().isEmpty() && this.getWarningItems().isEmpty();
    }

    public boolean isStartupAborted() {
        return !this.getErrorItems().isEmpty();
    }

    public List<StatusItem> getStatusItems() {
        return this.itemList.filterItems(StatusItemFilter.ALL_ITEMS_FILTER);
    }

    public List<StatusItem> getErrorItems() {
        return this.itemList.filterItems(StatusItemFilter.ERROR_ITEMS_FILTER);
    }

    public List<StatusItem> getWarningItems() {
        return this.itemList.filterItems(StatusItemFilter.WARNING_ITEMS_FILTER);
    }

    public List<StatusItem> getItemsForListener(ServletContextListener listener) {
        return this.itemList.filterItems(StatusItemFilter.listenerFilter(listener));
    }

    private class SynchronizedStatusItemList {
        private final List<StatusItem> list = new ArrayList<StatusItem>();

        private SynchronizedStatusItemList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(StatusItem item) {
            List<StatusItem> list = this.list;
            synchronized (list) {
                this.list.add(item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<StatusItem> filterItems(StatusItemFilter filter) {
            ArrayList<StatusItem> filteredList = new ArrayList<StatusItem>();
            List<StatusItem> list = this.list;
            synchronized (list) {
                for (StatusItem item : this.list) {
                    if (!filter.accept(item)) continue;
                    filteredList.add(item);
                }
            }
            return filteredList;
        }
    }

    private static abstract class StatusItemFilter {
        public static final StatusItemFilter ALL_ITEMS_FILTER = new StatusItemFilter(){

            @Override
            public boolean accept(StatusItem item) {
                return true;
            }
        };
        public static final StatusItemFilter ERROR_ITEMS_FILTER = new StatusItemFilter(){

            @Override
            public boolean accept(StatusItem item) {
                return item.level == StatusItem.Level.FATAL;
            }
        };
        public static final StatusItemFilter WARNING_ITEMS_FILTER = new StatusItemFilter(){

            @Override
            public boolean accept(StatusItem item) {
                return item.level == StatusItem.Level.WARNING;
            }
        };

        private StatusItemFilter() {
        }

        public abstract boolean accept(StatusItem var1);

        public static StatusItemFilter listenerFilter(ServletContextListener listener) {
            final String listenerName = listener.getClass().getName();
            return new StatusItemFilter(){

                @Override
                public boolean accept(StatusItem item) {
                    return item.getSourceName().equals(listenerName);
                }
            };
        }
    }

    public static class StatusItem {
        private final Level level;
        private final String sourceName;
        private final String shortSourceName;
        private final String message;
        private final String cause;
        private boolean unexpectedArguments;

        public StatusItem(Level level, ServletContextListener source, String message, Throwable cause) {
            this.level = this.figureLevel(level);
            this.sourceName = this.figureSourceName(source);
            this.shortSourceName = this.figureShortSourceName(source);
            this.message = message;
            this.cause = this.figureCauseString(cause);
            if (this.unexpectedArguments) {
                log.error((Object)("Unexpected arguments to " + StatusItem.class.getName() + ": level=" + (Object)((Object)level) + ", source=" + source + ", message=" + message + ", cause=" + cause));
            }
        }

        private Level figureLevel(Level newLevel) {
            if (newLevel == null) {
                this.unexpectedArguments = true;
                return Level.FATAL;
            }
            return newLevel;
        }

        private String figureSourceName(ServletContextListener source) {
            if (source == null) {
                this.unexpectedArguments = true;
                return "UNKNOWN SOURCE";
            }
            return source.getClass().getName();
        }

        private String figureShortSourceName(ServletContextListener source) {
            if (source == null) {
                this.unexpectedArguments = true;
                return "UNKNOWN_SOURCE";
            }
            String sourceClassName = source.getClass().getName();
            int lastPeriodHere = sourceClassName.lastIndexOf(46);
            return sourceClassName.substring(lastPeriodHere + 1);
        }

        private String figureCauseString(Throwable newCause) {
            if (newCause == null) {
                return "";
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            newCause.printStackTrace(pw);
            return sw.toString();
        }

        public Level getLevel() {
            return this.level;
        }

        public String getSourceName() {
            return this.sourceName;
        }

        public String getShortSourceName() {
            return this.shortSourceName;
        }

        public String getMessage() {
            return this.message;
        }

        public String getCause() {
            return this.cause;
        }

        public static enum Level {
            INFO,
            WARNING,
            FATAL,
            NOT_EXECUTED;

        }
    }
}

