/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.servlet.setup;

import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import edu.cornell.mannlib.vitro.webapp.utils.http.HttpClientFactory;
import edu.cornell.mannlib.vitro.webapp.utils.threads.VitroBackgroundThread;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class SolrSmokeTest {
    private static final Log log = LogFactory.getLog(SolrSmokeTest.class);
    private final ServletContextListener listener;
    private static final int SOCKET_TIMEOUT_STATUS = -500;

    public SolrSmokeTest(ServletContextListener listener) {
        this.listener = listener;
    }

    public void doTest(ServletContextEvent sce) {
        StartupStatus ss = StartupStatus.getBean(sce.getServletContext());
        String solrUrlString = ConfigurationProperties.getBean(sce).getProperty("vitro.local.solr.url", "");
        if (solrUrlString.isEmpty()) {
            ss.fatal(this.listener, "Can't connect to Solr search engine. runtime.properties must contain a value for vitro.local.solr.url");
            return;
        }
        URL solrUrl = null;
        try {
            solrUrl = new URL(solrUrlString);
        }
        catch (MalformedURLException e) {
            ss.fatal(this.listener, "Can't connect to Solr search engine. The value for vitro.local.solr.url in runtime.properties is not a valid URL: '" + solrUrlString + "'", e);
        }
        ss.info(this.listener, "Starting thread for Solr test.");
        new SolrSmokeTestThread(this.listener, solrUrl, ss).start();
    }

    private static class SolrProblemException
    extends Exception {
        private final int statusCode;

        SolrProblemException(int statusCode) {
            super("HTTP status code = " + statusCode);
            this.statusCode = statusCode;
        }

        SolrProblemException(Throwable cause) {
            super(cause);
            this.statusCode = 0;
        }

        int getStatusCode() {
            return this.statusCode;
        }
    }

    private static class SolrPinger {
        private final URL solrUrl;
        private final HttpClient httpClient = HttpClientFactory.getHttpClient();

        public SolrPinger(URL solrUrl) {
            this.solrUrl = solrUrl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ping() throws SolrProblemException {
            try {
                HttpGet method = new HttpGet(this.solrUrl.toExternalForm() + "/admin/ping");
                log.debug((Object)"Trying to ping Solr");
                HttpResponse response = this.httpClient.execute((HttpUriRequest)method);
                try {
                    log.debug((Object)"Finished pinging Solr");
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode != 200) {
                        throw new SolrProblemException(statusCode);
                    }
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
            catch (IOException e) {
                throw new SolrProblemException(e);
            }
        }
    }

    private static class SolrHomePager {
        private static final long SLEEP_INTERVAL = 20000L;
        private static final long SLEEP_MAX = 300000L;
        private static long SLEEP_DURATION = 0L;
        private final URL solrUrl;
        private final HttpClient httpClient = HttpClientFactory.getHttpClient();
        private int statusCode;

        public SolrHomePager(URL solrUrl) {
            this.solrUrl = solrUrl;
        }

        public void connect() throws SolrProblemException {
            this.tryToConnect();
            while (!this.isDone() && SLEEP_DURATION < 300000L) {
                this.sleep();
                this.tryToConnect();
            }
            if (this.statusCode != 200) {
                throw new SolrProblemException(this.statusCode);
            }
        }

        private void tryToConnect() throws SolrProblemException {
            log.debug((Object)("Trying to connect to Solr, wait up to 5 minutes - " + (int)((double)SLEEP_DURATION * 100.0 / 300000.0) + "%"));
            try {
                HttpGet method = new HttpGet(this.solrUrl.toExternalForm() + "/select");
                HttpResponse response = this.httpClient.execute((HttpUriRequest)method);
                try {
                    this.statusCode = response.getStatusLine().getStatusCode();
                    log.debug((Object)("HTTP status was " + this.statusCode));
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
            catch (IOException e) {
                this.statusCode = -500;
            }
            catch (Exception e) {
                throw new SolrProblemException(e);
            }
        }

        private boolean isDone() {
            return this.statusCode == 200 || this.statusCode == 403;
        }

        private void sleep() {
            try {
                SLEEP_DURATION += 20000L;
                Thread.sleep(20000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static class SolrSmokeTestThread
    extends VitroBackgroundThread {
        private final ServletContextListener listener;
        private final URL solrUrl;
        private final StartupStatus ss;

        public SolrSmokeTestThread(ServletContextListener listener, URL solrUrl, StartupStatus ss) {
            super("SolrSmokeTest");
            this.listener = listener;
            this.solrUrl = solrUrl;
            this.ss = ss;
        }

        @Override
        public void run() {
            try {
                new SolrHomePager(this.solrUrl).connect();
                this.reportSuccess();
            }
            catch (SolrProblemException e) {
                this.reportProblem(e);
                return;
            }
            try {
                new SolrPinger(this.solrUrl).ping();
                this.reportGoodPing();
            }
            catch (SolrProblemException e) {
                this.reportPingProblem(e);
            }
        }

        private void reportSuccess() {
            this.ss.info(this.listener, "Successfully connected to the Solr search server.");
        }

        private void reportGoodPing() {
            this.ss.info(this.listener, "The Solr search server responded to a 'ping'.");
        }

        private void reportProblem(SolrProblemException e) {
            int status = e.getStatusCode();
            Throwable cause = e.getCause();
            if (status == -500) {
                this.warnSocketTimeout();
            } else if (status != 0) {
                this.warnBadHttpStatus(status);
            } else if (cause instanceof HttpException) {
                this.warnProtocolViolation((HttpException)cause);
            } else if (cause instanceof UnknownHostException) {
                this.warnUnknownHost((UnknownHostException)cause);
            } else if (cause instanceof ConnectException) {
                this.warnConnectionRefused((ConnectException)cause);
            } else if (cause instanceof IOException) {
                this.warnTransportError((IOException)cause);
            } else {
                this.warnUnknownProblem(e);
            }
        }

        private void reportPingProblem(SolrProblemException e) {
            this.ss.warning(this.listener, "The Solr search engine did not respond to a 'ping' request", e);
        }

        private void warnSocketTimeout() {
            this.ss.warning(this.listener, "Can't connect to the Solr search engine. The socket connection has repeatedly timed out. Check the value of vitro.local.solr.url in runtime.properties. Is Solr responding at that URL?");
        }

        private void warnBadHttpStatus(int status) {
            this.ss.warning(this.listener, "Can't connect to the Solr search engine. The Solr server returned a status code of " + status + ". Check the value of vitro.local.solr.url in runtime.properties.");
        }

        private void warnProtocolViolation(HttpException e) {
            this.ss.warning(this.listener, "Can't connect to the Solr search engine. Detected a protocol violation: " + e.getMessage(), (Throwable)e);
        }

        private void warnUnknownHost(UnknownHostException e) {
            this.ss.warning(this.listener, "Can't connect to the Solr search engine. '" + e.getMessage() + "' is an unknown host.Check the value of vitro.local.solr.url in runtime.properties.", e);
        }

        private void warnConnectionRefused(ConnectException e) {
            this.ss.warning(this.listener, "Can't connect to the Solr search engine. The host refused the connection. Is it possible that the port number is incorrect? Check the value of vitro.local.solr.url in runtime.properties.", e);
        }

        private void warnTransportError(IOException e) {
            this.ss.warning(this.listener, "Can't connect to the Solr search engine. Detected a transport error: " + e.getMessage(), e);
        }

        private void warnUnknownProblem(SolrProblemException e) {
            this.ss.warning(this.listener, "Can't connect to the Solr search engine. Unrecognized error: " + e.getMessage(), e);
        }
    }
}

