/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.servlet.setup;

import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import edu.cornell.mannlib.vitro.webapp.utils.http.HttpClientFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class ElasticSmokeTest {
    private static final Log log = LogFactory.getLog(ElasticSmokeTest.class);
    private final ServletContextListener listener;

    public ElasticSmokeTest(ServletContextListener listener) {
        this.listener = listener;
    }

    public void doTest(ServletContextEvent sce) {
        StartupStatus ss = StartupStatus.getBean(sce.getServletContext());
        String elasticUrlString = ConfigurationProperties.getBean(sce).getProperty("vitro.local.elastic.url", "");
        if (elasticUrlString.isEmpty()) {
            ss.fatal(this.listener, "Can't connect to ElasticSearch engine. runtime.properties must contain a value for vitro.local.elastic.url");
            return;
        }
        URL elasticUrl = null;
        try {
            elasticUrl = new URL(elasticUrlString);
        }
        catch (MalformedURLException e) {
            ss.fatal(this.listener, "Can't connect to ElasticSearch engine. The value for vitro.local.elastic.url in runtime.properties is not a valid URL: '" + elasticUrlString + "'", e);
        }
        ss.info(this.listener, "Starting ElasticSearch test.");
        this.checkConnection(elasticUrl, ss);
    }

    private void checkConnection(URL elasticUrl, StartupStatus ss) {
        try {
            new ElasticPinger(elasticUrl).ping();
            this.reportGoodPing(ss);
        }
        catch (ElasticProblemException e) {
            this.reportPingProblem(ss, e);
        }
    }

    private void reportGoodPing(StartupStatus ss) {
        ss.info(this.listener, "The ElasticSearch server responded to a 'ping'.");
    }

    private void reportPingProblem(StartupStatus ss, ElasticProblemException e) {
        ss.warning(this.listener, "The ElasticSearch engine did not respond to a 'ping' request", e);
    }

    private static class ElasticProblemException
    extends Exception {
        private final int statusCode;

        ElasticProblemException(int statusCode) {
            super("HTTP status code = " + statusCode);
            this.statusCode = statusCode;
        }

        ElasticProblemException(Throwable cause) {
            super(cause);
            this.statusCode = 0;
        }

        int getStatusCode() {
            return this.statusCode;
        }
    }

    private static class ElasticPinger {
        private final URL elasticUrl;
        private final HttpClient httpClient = HttpClientFactory.getHttpClient();

        public ElasticPinger(URL elasticUrl) {
            this.elasticUrl = elasticUrl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ping() throws ElasticProblemException {
            try {
                HttpGet method = new HttpGet(this.elasticUrl.toExternalForm());
                log.debug((Object)"Trying to ping ElasticSearch");
                HttpResponse response = this.httpClient.execute((HttpUriRequest)method);
                try {
                    log.debug((Object)"Finished pinging ElasticSearch");
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode != 200) {
                        throw new ElasticProblemException(statusCode);
                    }
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
            catch (IOException e) {
                throw new ElasticProblemException(e);
            }
        }
    }
}

