/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.indexing;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.searchindex.indexing.IndexingUriFinder;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ContextModelsUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jena.rdf.model.Statement;

public class URIsForClassGroupChange
implements IndexingUriFinder,
ContextModelsUser {
    IndividualDao indDao;

    @Override
    public void setContextModels(ContextModelAccess models) {
        this.indDao = models.getWebappDaoFactory().getIndividualDao();
    }

    @Override
    public List<String> findAdditionalURIsToIndex(Statement stmt) {
        if (stmt == null || stmt.getPredicate() == null) {
            return Collections.emptyList();
        }
        if ("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inClassGroup".equals(stmt.getPredicate().getURI()) && stmt.getSubject() != null && stmt.getSubject().isURIResource()) {
            List<Individual> indsInClass = this.indDao.getIndividualsByVClassURI(stmt.getSubject().getURI());
            if (indsInClass == null) {
                return Collections.emptyList();
            }
            ArrayList<String> uris = new ArrayList<String>();
            for (Individual ind : indsInClass) {
                uris.add(ind.getURI());
            }
            return uris;
        }
        return Collections.emptyList();
    }

    @Override
    public void startIndexing() {
    }

    @Override
    public void endIndexing() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

