/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.exclusions;

import edu.cornell.mannlib.vitro.webapp.dao.DisplayVocabulary;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.searchindex.exclusions.ExcludeBasedOnType;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ContextModelsUser;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Validation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public class SyncingExcludeBasedOnType
extends ExcludeBasedOnType
implements ModelChangedListener,
ContextModelsUser {
    static final Log log = LogFactory.getLog(SyncingExcludeBasedOnType.class);
    private static final String queryForProhibitedClasses = "SELECT ?prohibited WHERE{?searchConfig <" + DisplayVocabulary.EXCLUDE_CLASS + "> ?prohibited . }";
    private ContextModelAccess models;

    @Override
    public void setContextModels(ContextModelAccess models) {
        this.models = models;
    }

    @Validation
    public void buildClassList() {
        OntModel model = this.models.getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata");
        this.setExcludedTypes(this.buildProhibitedClassesList("http://vitro.mannlib.cornell.edu/ontologies/display/1.1#SearchIndex", (Model)model));
        log.debug((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> buildProhibitedClassesList(String URI2, Model model) {
        ArrayList<String> newProhibitedClasses;
        block10: {
            newProhibitedClasses = new ArrayList<String>();
            QuerySolutionMap initialBinding = new QuerySolutionMap();
            Resource searchConfig = ResourceFactory.createResource((String)URI2);
            initialBinding.add("searchConfig", (RDFNode)searchConfig);
            Query query = QueryFactory.create((String)queryForProhibitedClasses);
            model.enterCriticalSection(true);
            try {
                QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Model)model, (QuerySolution)initialBinding);
                try {
                    ResultSet results = qExec.execSelect();
                    while (results.hasNext()) {
                        QuerySolution soln = results.nextSolution();
                        RDFNode n = soln.get("prohibited");
                        if (n.isResource() && !n.isAnon()) {
                            newProhibitedClasses.add(((Resource)n).getURI());
                            continue;
                        }
                        log.warn((Object)("unexpected node in object position for prohibited classes: " + n.toString()));
                    }
                }
                catch (Throwable t) {
                    try {
                        log.error((Object)t, t);
                        break block10;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        qExec.close();
                    }
                }
                qExec.close();
            }
            finally {
                model.leaveCriticalSection();
            }
        }
        return newProhibitedClasses;
    }

    public void addedStatement(Statement s) {
        try {
            if (this.isExcludeClassPredicate(s) && this.isAboutSearchIndex(s) && s.getObject() != null && s.getObject().isURIResource()) {
                String classURI = s.getObject().asResource().getURI();
                this.addTypeToExclude(classURI);
                log.debug((Object)("prohibited classes: " + this));
            }
        }
        catch (Exception ex) {
            log.error((Object)"could not add statement", (Throwable)ex);
        }
    }

    public void removedStatement(Statement s) {
        try {
            if (this.isExcludeClassPredicate(s) && this.isAboutSearchIndex(s) && s.getObject() != null && s.getObject().isURIResource()) {
                String classURI = s.getObject().asResource().getURI();
                this.removeTypeToExclude(classURI);
                log.debug((Object)("prohibited classes: " + this));
            }
        }
        catch (Exception ex) {
            log.error((Object)"could not remove statement", (Throwable)ex);
        }
    }

    private boolean isExcludeClassPredicate(Statement s) {
        return s != null && s.getPredicate() != null && DisplayVocabulary.EXCLUDE_CLASS.getURI().equals(s.getPredicate().getURI());
    }

    private boolean isAboutSearchIndex(Statement s) {
        if (s.getSubject() != null) {
            String subURI = s.getSubject().getURI();
            return "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#SearchIndex".equals(subURI);
        }
        return false;
    }

    public void addedStatements(Statement[] stmts) {
        if (stmts != null) {
            for (Statement stmt : stmts) {
                this.addedStatement(stmt);
            }
        }
    }

    public void addedStatements(List<Statement> stmts) {
        if (stmts != null) {
            for (Statement stmt : stmts) {
                this.addedStatement(stmt);
            }
        }
    }

    public void addedStatements(StmtIterator it) {
        while (it.hasNext()) {
            Statement stmt = it.nextStatement();
            this.addedStatement(stmt);
        }
    }

    public void addedStatements(Model model) {
        if (model != null) {
            this.addedStatements(model.listStatements(model.createResource("http://vitro.mannlib.cornell.edu/ontologies/display/1.1#SearchIndex"), (Property)DisplayVocabulary.EXCLUDE_CLASS, (RDFNode)null));
        }
    }

    public void notifyEvent(Model arg0, Object arg1) {
    }

    public void removedStatements(Statement[] stmts) {
        if (stmts != null) {
            for (Statement stmt : stmts) {
                this.removedStatement(stmt);
            }
        }
    }

    public void removedStatements(List<Statement> stmts) {
        if (stmts != null) {
            for (Statement stmt : stmts) {
                this.removedStatement(stmt);
            }
        }
    }

    public void removedStatements(StmtIterator it) {
        while (it.hasNext()) {
            Statement stmt = it.nextStatement();
            this.removedStatement(stmt);
        }
    }

    public void removedStatements(Model model) {
        if (model != null) {
            this.removedStatements(model.listStatements(model.createResource("http://vitro.mannlib.cornell.edu/ontologies/display/1.1#SearchIndex"), (Property)DisplayVocabulary.EXCLUDE_CLASS, (RDFNode)null));
        }
    }
}

