/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex;

import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.WebappDaoFactoryFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFilterUtils;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFilters;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.modules.Application;
import edu.cornell.mannlib.vitro.webapp.modules.ComponentStartupStatus;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexer;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexerStatus;
import edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding.DocumentModifier;
import edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding.DocumentModifierList;
import edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding.DocumentModifierListBasic;
import edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding.DocumentModifierListDeveloper;
import edu.cornell.mannlib.vitro.webapp.searchindex.exclusions.SearchIndexExcluder;
import edu.cornell.mannlib.vitro.webapp.searchindex.exclusions.SearchIndexExcluderList;
import edu.cornell.mannlib.vitro.webapp.searchindex.exclusions.SearchIndexExcluderListBasic;
import edu.cornell.mannlib.vitro.webapp.searchindex.exclusions.SearchIndexExcluderListDeveloper;
import edu.cornell.mannlib.vitro.webapp.searchindex.indexing.IndexingUriFinder;
import edu.cornell.mannlib.vitro.webapp.searchindex.indexing.IndexingUriFinderList;
import edu.cornell.mannlib.vitro.webapp.searchindex.indexing.IndexingUriFinderListBasic;
import edu.cornell.mannlib.vitro.webapp.searchindex.indexing.IndexingUriFinderListDeveloper;
import edu.cornell.mannlib.vitro.webapp.searchindex.tasks.RebuildIndexTask;
import edu.cornell.mannlib.vitro.webapp.searchindex.tasks.UpdateDocumentWorkUnit;
import edu.cornell.mannlib.vitro.webapp.searchindex.tasks.UpdateStatementsTask;
import edu.cornell.mannlib.vitro.webapp.searchindex.tasks.UpdateUrisTask;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoader;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoaderException;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Validation;
import edu.cornell.mannlib.vitro.webapp.utils.developer.DeveloperSettings;
import edu.cornell.mannlib.vitro.webapp.utils.developer.Key;
import edu.cornell.mannlib.vitro.webapp.utils.threads.VitroBackgroundThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Statement;

public class SearchIndexerImpl
implements SearchIndexer {
    private static final Log log = LogFactory.getLog(SearchIndexerImpl.class);
    private final ListenerList listeners = new ListenerList();
    private final TaskQueue taskQueue = new TaskQueue();
    private final Scheduler scheduler = new Scheduler(this.taskQueue);
    private Integer threadPoolSize;
    private WorkerThreadPool pool;
    private ServletContext ctx;
    private List<SearchIndexExcluder> excluders;
    private List<DocumentModifier> modifiers;
    private Set<IndexingUriFinder> uriFinders;
    private WebappDaoFactory wadf;
    private boolean rebuildOnUnpause = false;
    private volatile int paused = 0;
    private List<Statement> pendingStatements = new ArrayList<Statement>();
    private Collection<String> pendingUris = new ArrayList<String>();

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#threadPoolSize", minOccurs=1, maxOccurs=1)
    public void setThreadPoolSize(String size) {
        this.threadPoolSize = Integer.parseInt(size);
    }

    @Validation
    public void validate() throws Exception {
        this.pool = new WorkerThreadPool(this.threadPoolSize);
    }

    @Override
    public void startup(Application application, ComponentStartupStatus ss) {
        if (this.isStarted()) {
            throw new IllegalStateException("startup() called more than once.");
        }
        if (this.isShutdown()) {
            throw new IllegalStateException("startup() called after shutdown().");
        }
        try {
            this.ctx = application.getServletContext();
            this.wadf = this.getFilteredWebappDaoFactory();
            this.loadConfiguration();
            this.fireEvent(SearchIndexer.Event.Type.STARTUP);
            this.scheduler.start();
            ss.info("Configured SearchIndexer: excluders=" + this.excluders + ", modifiers=" + this.modifiers + ", uriFinders=" + this.uriFinders);
        }
        catch (Exception e) {
            ss.fatal("Failed to configure the SearchIndexer", e);
        }
    }

    private WebappDaoFactory getFilteredWebappDaoFactory() {
        WebappDaoFactory rawWadf = ModelAccess.on(this.ctx).getWebappDaoFactory();
        VitroFilters vf = VitroFilterUtils.getPublicFilter(this.ctx);
        return new WebappDaoFactoryFiltering(rawWadf, vf);
    }

    private void loadConfiguration() throws ConfigurationBeanLoaderException {
        ConfigurationBeanLoader beanLoader = new ConfigurationBeanLoader((Model)ModelAccess.on(this.ctx).getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata"), this.ctx);
        this.uriFinders = beanLoader.loadAll(IndexingUriFinder.class);
        this.excluders = new ArrayList<SearchIndexExcluder>();
        this.excluders.add(new UpdateUrisTask.ExcludeIfNoVClasses());
        this.excluders.addAll(beanLoader.loadAll(SearchIndexExcluder.class));
        this.modifiers = new ArrayList<DocumentModifier>();
        this.modifiers.addAll(new UpdateDocumentWorkUnit.MinimalDocumentModifiers().getList());
        this.modifiers.addAll(beanLoader.loadAll(DocumentModifier.class));
    }

    @Override
    public synchronized void shutdown(Application application) {
        if (this.isShutdown()) {
            return;
        }
        this.fireEvent(SearchIndexer.Event.Type.SHUTDOWN_REQUESTED);
        this.taskQueue.shutdown();
        this.pool.shutdown();
        for (DocumentModifier dm : this.modifiers) {
            try {
                dm.shutdown();
            }
            catch (Exception e) {
                log.warn((Object)("Failed to shut down document modifier " + dm), (Throwable)e);
            }
        }
        this.fireEvent(SearchIndexer.Event.Type.SHUTDOWN_COMPLETE);
    }

    @Override
    public synchronized void pause() {
        if (!this.isShutdown()) {
            ++this.paused;
            if (this.paused == 1) {
                this.fireEvent(SearchIndexer.Event.Type.PAUSE);
            }
        }
    }

    @Override
    public synchronized void unpause() {
        if (this.paused > 0 && !this.isShutdown()) {
            --this.paused;
            if (this.paused == 0) {
                this.fireEvent(SearchIndexer.Event.Type.UNPAUSE);
                if (this.rebuildOnUnpause) {
                    this.rebuildOnUnpause = false;
                    this.pendingStatements.clear();
                    this.pendingUris.clear();
                    this.rebuildIndex();
                } else {
                    this.schedulePendingStatements();
                    this.schedulePendingUris();
                }
            }
        }
    }

    private synchronized void schedulePendingStatements() {
        if (this.paused == 0 && this.pendingStatements.size() > 0) {
            this.scheduleUpdatesForStatements(this.pendingStatements);
            this.pendingStatements = new ArrayList<Statement>();
        }
    }

    private synchronized void schedulePendingUris() {
        if (this.paused == 0 && this.pendingUris.size() > 0) {
            this.scheduleUpdatesForUris(this.pendingUris);
            this.pendingUris = new ArrayList<String>();
        }
    }

    private boolean isStarted() {
        return this.scheduler.isStarted();
    }

    private boolean isShutdown() {
        return this.taskQueue.isShutdown();
    }

    @Override
    public SearchIndexerStatus getStatus() {
        return this.taskQueue.getStatus();
    }

    private void fireEvent(SearchIndexer.Event.Type type) {
        this.listeners.fireEvent(new SearchIndexer.Event(type, this.getStatus()));
    }

    @Override
    public void scheduleUpdatesForStatements(List<Statement> changes) {
        if (this.isShutdown()) {
            log.warn((Object)"Call to scheduleUpdatesForStatements after shutdown.");
            return;
        }
        if (changes == null || changes.isEmpty()) {
            return;
        }
        if (this.paused > 0 && this.addToPendingStatements(changes)) {
            return;
        }
        this.scheduler.scheduleTask(new UpdateStatementsTask(new IndexerConfigImpl(this), changes));
        log.debug((Object)("Scheduled updates for " + changes.size() + " statements."));
    }

    private synchronized boolean addToPendingStatements(List<Statement> changes) {
        if (this.paused > 0) {
            this.pendingStatements.addAll(changes);
            return true;
        }
        return false;
    }

    @Override
    public void scheduleUpdatesForUris(Collection<String> uris) {
        if (this.isShutdown()) {
            log.warn((Object)"Call to scheduleUpdatesForUris after shutdown.");
            return;
        }
        if (uris == null || uris.isEmpty()) {
            return;
        }
        if (this.paused > 0 && this.pendingUris.addAll(uris)) {
            return;
        }
        this.scheduler.scheduleTask(new UpdateUrisTask(new IndexerConfigImpl(this), uris));
        log.debug((Object)("Scheduled updates for " + uris.size() + " uris."));
    }

    private synchronized boolean addToPendingUris(Collection<String> uris) {
        if (this.paused > 0) {
            this.pendingUris.addAll(uris);
            return true;
        }
        return false;
    }

    @Override
    public void rebuildIndex() {
        if (this.isShutdown()) {
            log.warn((Object)"Call to rebuildIndex after shutdown.");
            return;
        }
        this.fireEvent(SearchIndexer.Event.Type.REBUILD_REQUESTED);
        if (this.paused > 0) {
            this.rebuildOnUnpause = true;
            return;
        }
        this.scheduler.scheduleTask(new RebuildIndexTask(new IndexerConfigImpl(this)));
        log.debug((Object)"Scheduled a full rebuild.");
    }

    private SearchIndexExcluderList createExcludersList() {
        if (this.isDeveloperOptionSet()) {
            return new SearchIndexExcluderListDeveloper(this.excluders);
        }
        return new SearchIndexExcluderListBasic(this.excluders);
    }

    private DocumentModifierList createModifiersList() {
        if (this.isDeveloperOptionSet()) {
            return new DocumentModifierListDeveloper(this.modifiers);
        }
        return new DocumentModifierListBasic(this.modifiers);
    }

    private IndexingUriFinderList createFindersList() {
        if (this.isDeveloperOptionSet()) {
            return new IndexingUriFinderListDeveloper(this.uriFinders);
        }
        return new IndexingUriFinderListBasic(this.uriFinders);
    }

    private boolean isDeveloperOptionSet() {
        return DeveloperSettings.getInstance().getBoolean(Key.SEARCH_INDEX_LOG_INDEXING_BREAKDOWN_TIMINGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(SearchIndexer.Listener listener) {
        if (this.isShutdown()) {
            return;
        }
        ListenerList listenerList = this.listeners;
        synchronized (listenerList) {
            this.listeners.add(listener);
            if (this.paused > 0) {
                listener.receiveSearchIndexerEvent(new SearchIndexer.Event(SearchIndexer.Event.Type.PAUSE, this.getStatus()));
            }
        }
    }

    @Override
    public void removeListener(SearchIndexer.Listener listener) {
        this.listeners.remove(listener);
    }

    public static class WorkerThreadPool {
        private final ThreadPoolExecutor pool;

        public WorkerThreadPool(int threadPoolSize) {
            this.pool = new ThreadPoolExecutor(threadPoolSize, threadPoolSize, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(50), new VitroBackgroundThread.Factory("SearchIndexer_ThreadPool"), new ThreadPoolExecutor.CallerRunsPolicy());
        }

        public void submit(Runnable workUnit, Task task) {
            try {
                this.pool.execute(new WorkUnitWrapper(workUnit, task));
            }
            catch (RejectedExecutionException e) {
                if (this.pool.isShutdown()) {
                    log.warn((Object)("Work unit was rejected: " + workUnit + " for " + task));
                }
                log.error((Object)("Work unit was rejected: " + workUnit + " for " + task), (Throwable)e);
            }
        }

        public void waitUntilIdle() {
            for (int i = 0; i < 60; ++i) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (this.pool.getActiveCount() + this.pool.getQueue().size() != 0) continue;
                return;
            }
        }

        public void shutdown() {
            this.pool.shutdown();
            try {
                boolean terminated = this.pool.awaitTermination(1L, TimeUnit.MINUTES);
                if (!terminated) {
                    log.warn((Object)"SearchIndexer thread pool did not shut down within 1 minute.");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        private static class WorkUnitWrapper
        implements Runnable {
            private final Runnable workUnit;
            private final Task task;

            public WorkUnitWrapper(Runnable workUnit, Task task) {
                this.workUnit = workUnit;
                this.task = task;
            }

            @Override
            public void run() {
                try {
                    this.setWorkLevel(VitroBackgroundThread.WorkLevel.WORKING);
                    this.workUnit.run();
                    this.setWorkLevel(VitroBackgroundThread.WorkLevel.IDLE);
                }
                finally {
                    this.task.notifyWorkUnitCompletion(this.workUnit);
                }
            }

            private void setWorkLevel(VitroBackgroundThread.WorkLevel level) {
                if (Thread.currentThread() instanceof VitroBackgroundThread) {
                    ((VitroBackgroundThread)Thread.currentThread()).setWorkLevel(level, new String[0]);
                }
            }
        }
    }

    public static interface Task
    extends Runnable {
        public SearchIndexerStatus getStatus();

        public void notifyWorkUnitCompletion(Runnable var1);
    }

    private static class IndexerConfigImpl
    implements IndexerConfig {
        private final SearchIndexerImpl sii;

        public IndexerConfigImpl(SearchIndexerImpl sii) {
            this.sii = sii;
        }

        @Override
        public IndexingUriFinderList uriFinderList() {
            return this.sii.createFindersList();
        }

        @Override
        public SearchIndexExcluderList excluderList() {
            return this.sii.createExcludersList();
        }

        @Override
        public DocumentModifierList documentModifierList() {
            return this.sii.createModifiersList();
        }

        @Override
        public IndividualDao individualDao() {
            return this.sii.wadf.getIndividualDao();
        }

        @Override
        public ListenerList listenerList() {
            return this.sii.listeners;
        }

        @Override
        public WorkerThreadPool workerThreadPool() {
            return this.sii.pool;
        }
    }

    public static interface IndexerConfig {
        public IndexingUriFinderList uriFinderList();

        public SearchIndexExcluderList excluderList();

        public DocumentModifierList documentModifierList();

        public IndividualDao individualDao();

        public ListenerList listenerList();

        public WorkerThreadPool workerThreadPool();
    }

    private static class TaskQueue {
        private final ExecutorService queue = Executors.newSingleThreadExecutor(new VitroBackgroundThread.Factory("SearchIndexer_TaskQueue"));
        private AtomicReference<QueueStatus> current = new AtomicReference<QueueStatus>(new QueueStatus(SearchIndexerStatus.idle()));

        private TaskQueue() {
        }

        public void scheduleTask(Task task) {
            try {
                this.queue.execute(new TaskWrapper(task));
            }
            catch (RejectedExecutionException e) {
                log.warn((Object)("Search Indexer task was rejected: " + task));
            }
        }

        public SearchIndexerStatus getStatus() {
            return this.current.get().getStatus();
        }

        public void shutdown() {
            try {
                this.queue.shutdownNow();
                boolean terminated = this.queue.awaitTermination(1L, TimeUnit.MINUTES);
                if (!terminated) {
                    log.warn((Object)"SearchIndexer task queue did not shut down within 1 minute.");
                }
                this.current.set(new QueueStatus(SearchIndexerStatus.shutdown()));
            }
            catch (InterruptedException e) {
                log.warn((Object)"call to 'awaitTermination' was interrupted.");
            }
        }

        public boolean isShutdown() {
            return this.queue.isShutdown();
        }

        private class QueueStatus {
            private final Task task;
            private final SearchIndexerStatus status;

            public QueueStatus(Task task) {
                this.task = Objects.requireNonNull(task);
                this.status = null;
            }

            public QueueStatus(SearchIndexerStatus status) {
                this.task = null;
                this.status = Objects.requireNonNull(status);
            }

            public SearchIndexerStatus getStatus() {
                if (this.task != null) {
                    return this.task.getStatus();
                }
                return this.status;
            }
        }

        private class TaskWrapper
        implements Runnable {
            private final Task task;

            public TaskWrapper(Task task) {
                this.task = task;
            }

            @Override
            public void run() {
                TaskQueue.this.current.set(new QueueStatus(this.task));
                this.setWorkLevel(VitroBackgroundThread.WorkLevel.WORKING);
                log.debug((Object)("starting task: " + this.task));
                this.task.run();
                TaskQueue.this.current.set(new QueueStatus(SearchIndexerStatus.idle()));
                this.setWorkLevel(VitroBackgroundThread.WorkLevel.IDLE);
                log.debug((Object)("ended task: " + this.task));
            }

            private void setWorkLevel(VitroBackgroundThread.WorkLevel level) {
                if (Thread.currentThread() instanceof VitroBackgroundThread) {
                    ((VitroBackgroundThread)Thread.currentThread()).setWorkLevel(level, new String[0]);
                }
            }
        }
    }

    private static class Scheduler {
        private final TaskQueue taskQueue;
        private final List<Task> deferredQueue;
        private volatile boolean started;

        public Scheduler(TaskQueue taskQueue) {
            this.taskQueue = taskQueue;
            this.deferredQueue = new ArrayList<Task>();
        }

        public boolean isStarted() {
            return this.started;
        }

        public synchronized void scheduleTask(Task task) {
            if (!this.started) {
                this.deferredQueue.add(task);
                log.debug((Object)("added task to deferred queue: " + task));
            } else {
                this.taskQueue.scheduleTask(task);
                log.debug((Object)("added task to task queue: " + task));
            }
        }

        public synchronized void start() {
            this.started = true;
            this.processDeferredTasks();
        }

        private void processDeferredTasks() {
            for (Task task : this.deferredQueue) {
                this.taskQueue.scheduleTask(task);
                log.debug((Object)("moved task from deferred queue to task queue: " + task));
            }
            this.deferredQueue.clear();
        }
    }

    public static class ListenerList {
        private final List<SearchIndexer.Listener> list = new ArrayList<SearchIndexer.Listener>();

        public synchronized void add(SearchIndexer.Listener l) {
            this.list.add(l);
        }

        public synchronized void remove(SearchIndexer.Listener l) {
            this.list.remove(l);
        }

        public synchronized void fireEvent(SearchIndexer.Event event) {
            for (SearchIndexer.Listener l : this.list) {
                try {
                    l.receiveSearchIndexerEvent(event);
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to deliver event '" + event + "' to listener '" + l + "'"), (Throwable)e);
                }
            }
        }
    }
}

