/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine.base;

import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseSearchResultDocument
implements SearchResultDocument {
    private final String uniqueId;
    private final Map<String, Collection<Object>> fieldValuesMap;

    public BaseSearchResultDocument(String uniqueId, Map<String, Collection<Object>> fieldValuesMap) {
        this.uniqueId = uniqueId;
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        for (String name : fieldValuesMap.keySet()) {
            map.put(name, Collections.unmodifiableList(new ArrayList<Object>(fieldValuesMap.get(name))));
        }
        this.fieldValuesMap = Collections.unmodifiableMap(map);
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public Collection<String> getFieldNames() {
        return this.fieldValuesMap.keySet();
    }

    @Override
    public Object getFirstValue(String name) {
        Collection<Object> values = this.fieldValuesMap.get(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.iterator().next();
    }

    @Override
    public String getStringValue(String name) {
        Object o = this.getFirstValue(name);
        if (o == null) {
            return null;
        }
        return String.valueOf(o);
    }

    @Override
    public Collection<Object> getFieldValues(String name) {
        Collection<Object> values = this.fieldValuesMap.get(name);
        if (values == null) {
            return Collections.emptyList();
        }
        return values;
    }

    @Override
    public Map<String, Collection<Object>> getFieldValuesMap() {
        return this.fieldValuesMap;
    }

    public String toString() {
        return "BaseSearchResultDocument [uniqueId=" + this.uniqueId + ", fieldValuesMap=" + this.fieldValuesMap + "]";
    }
}

