/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.search.controller;

import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexer;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexerStatus;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexHistory
implements SearchIndexer.Listener {
    private static final Log log = LogFactory.getLog(IndexHistory.class);
    private static final int MAX_EVENTS = 20;
    private final Deque<SearchIndexer.Event> events = new LinkedList<SearchIndexer.Event>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveSearchIndexerEvent(SearchIndexer.Event event) {
        if (log.isInfoEnabled()) {
            log.info((Object)event);
        }
        Deque<SearchIndexer.Event> deque = this.events;
        synchronized (deque) {
            this.events.addFirst(event);
            while (this.events.size() > 20) {
                this.events.removeLast();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> toMaps() {
        Deque<SearchIndexer.Event> deque = this.events;
        synchronized (deque) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            for (SearchIndexer.Event event : this.events) {
                list.add(this.toMap(event));
            }
            return list;
        }
    }

    private Map<String, Object> toMap(SearchIndexer.Event event) {
        SearchIndexerStatus status = event.getStatus();
        SearchIndexerStatus.Counts counts = status.getCounts();
        SearchIndexerStatus.Counts.Type countsType = counts.getType();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("event", (Object)event.getType());
        map.put("statusType", (Object)status.getState());
        map.put("since", status.getSince());
        map.put("countsType", (Object)countsType);
        switch (countsType) {
            case URI_COUNTS: {
                this.addCounts(counts.asUriCounts(), map);
                break;
            }
            case STATEMENT_COUNTS: {
                this.addCounts(counts.asStatementCounts(), map);
                break;
            }
            case REBUILD_COUNTS: {
                this.addCounts(counts.asRebuildCounts(), map);
                break;
            }
        }
        return map;
    }

    private void addCounts(SearchIndexerStatus.UriCounts counts, Map<String, Object> map) {
        map.put("excluded", counts.getExcluded());
        map.put("updated", counts.getUpdated());
        map.put("deleted", counts.getDeleted());
        map.put("remaining", counts.getRemaining());
        map.put("total", counts.getTotal());
    }

    private void addCounts(SearchIndexerStatus.StatementCounts counts, Map<String, Object> map) {
        map.put("processed", counts.getProcessed());
        map.put("remaining", counts.getRemaining());
        map.put("total", counts.getTotal());
    }

    private void addCounts(SearchIndexerStatus.RebuildCounts counts, Map<String, Object> map) {
        map.put("documentsBefore", counts.getDocumentsBefore());
        map.put("documentsAfter", counts.getDocumentsAfter());
    }
}

