/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.reasoner;

import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class IndividualURIQueue<E>
implements Queue<E> {
    private ConcurrentLinkedQueue<E> q = new ConcurrentLinkedQueue();
    private ConcurrentHashMap<E, Boolean> m = new ConcurrentHashMap();

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E e : c) {
            if (this.m.containsKey(e)) continue;
            this.m.put(e, Boolean.TRUE);
            this.q.add(e);
            changed = true;
        }
        return changed;
    }

    @Override
    public synchronized void clear() {
        this.m.clear();
        this.q.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.m.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean contains = true;
        for (Object e : c) {
            contains |= this.m.containsKey(e);
        }
        return contains;
    }

    @Override
    public boolean isEmpty() {
        return this.q.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.q.iterator();
    }

    @Override
    public synchronized boolean remove(Object o) {
        this.m.remove(o);
        return this.q.remove(o);
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        for (Object e : c) {
            this.m.remove(e);
        }
        return this.q.removeAll(c);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        boolean changed = false;
        for (Object e : this.m.keySet()) {
            if (c.contains(e)) continue;
            this.m.remove(e);
            this.q.remove(e);
            changed = true;
        }
        return changed;
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public Object[] toArray() {
        return this.q.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.q.toArray(a);
    }

    @Override
    public synchronized boolean add(E e) {
        if (this.m.containsKey(e)) {
            return false;
        }
        this.m.put(e, Boolean.TRUE);
        this.q.add(e);
        return true;
    }

    @Override
    public E element() {
        return this.q.element();
    }

    @Override
    public boolean offer(E e) {
        return this.q.offer(e);
    }

    @Override
    public E peek() {
        return this.q.peek();
    }

    @Override
    public synchronized E poll() {
        E e = this.q.poll();
        this.m.remove(e);
        return e;
    }

    @Override
    public synchronized E remove() {
        Object e = this.q.remove();
        this.m.remove(e);
        return e;
    }
}

