/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.tdb;

import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapper;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.RDFServiceJena;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.tdb.TDBFactory;

public class RDFServiceTDB
extends RDFServiceJena {
    private static final Log log = LogFactory.getLog(RDFServiceTDB.class);
    private final Dataset dataset;
    private final String integerPattern = "\\^\\^<http://www.w3.org/2001/XMLSchema#int>|\\^\\^<http://www.w3.org/2001/XMLSchema#long>|\\^\\^<http://www.w3.org/2001/XMLSchema#short>|\\^\\^<http://www.w3.org/2001/XMLSchema#unsignedByte>|\\^\\^<http://www.w3.org/2001/XMLSchema#unsignedShort>|\\^\\^<http://www.w3.org/2001/XMLSchema#unsignedInt>|\\^\\^<http://www.w3.org/2001/XMLSchema#unsignedLong>|\\^\\^<http://www.w3.org/2001/XMLSchema#nonPositiveInteger>|\\^\\^<http://www.w3.org/2001/XMLSchema#nonNegativeInteger>|\\^\\^<http://www.w3.org/2001/XMLSchema#positiveInteger>|\\^\\^<http://www.w3.org/2001/XMLSchema#negativeInteger>";

    public RDFServiceTDB(String directoryPath) throws IOException {
        Path tdbDir = Paths.get(directoryPath, new String[0]);
        if (!Files.exists(tdbDir, new LinkOption[0])) {
            Path parentDir = tdbDir.getParent();
            if (!Files.exists(parentDir, new LinkOption[0])) {
                throw new IllegalArgumentException("Cannot create TDB directory '" + tdbDir + "': parent directory does not exist.");
            }
            Files.createDirectory(tdbDir, new FileAttribute[0]);
        }
        this.dataset = TDBFactory.createDataset((String)directoryPath);
    }

    @Override
    protected DatasetWrapper getDatasetWrapper() {
        return new DatasetWrapper(this.dataset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean changeSetUpdate(ChangeSet changeSet) throws RDFServiceException {
        if (changeSet.getPreconditionQuery() != null && !this.isPreconditionSatisfied(changeSet.getPreconditionQuery(), changeSet.getPreconditionQueryType())) {
            return false;
        }
        try {
            boolean committed;
            this.insureThatInputStreamsAreResettable(changeSet);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Change Set: " + changeSet));
            }
            this.notifyListenersOfPreChangeEvents(changeSet);
            this.dataset.begin(ReadWrite.WRITE);
            try {
                committed = false;
                try {
                    this.applyChangeSetToModel(changeSet, this.dataset);
                    this.dataset.commit();
                    committed = true;
                }
                finally {
                    if (!committed) {
                        this.dataset.abort();
                    }
                }
            }
            finally {
                this.dataset.end();
            }
            this.notifyListenersOfChanges(changeSet);
            this.notifyListenersOfPostChangeEvents(changeSet);
            committed = true;
            return committed;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RDFServiceException(e);
        }
        finally {
            this.rebuildGraphURICache = true;
        }
    }

    @Override
    public boolean preferPreciseOptionals() {
        return true;
    }

    @Override
    public void close() {
        if (this.dataset != null) {
            this.dataset.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream sparqlConstructQuery(String query, RDFService.ModelSerializationFormat resultFormat) throws RDFServiceException {
        this.dataset.begin(ReadWrite.READ);
        try {
            InputStream inputStream = super.sparqlConstructQuery(query, resultFormat);
            return inputStream;
        }
        finally {
            this.dataset.end();
        }
    }

    @Override
    public void sparqlConstructQuery(String query, Model model) throws RDFServiceException {
        this.dataset.begin(ReadWrite.READ);
        try {
            super.sparqlConstructQuery(query, model);
        }
        finally {
            this.dataset.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream sparqlDescribeQuery(String query, RDFService.ModelSerializationFormat resultFormat) throws RDFServiceException {
        this.dataset.begin(ReadWrite.READ);
        try {
            InputStream inputStream = super.sparqlDescribeQuery(query, resultFormat);
            return inputStream;
        }
        finally {
            this.dataset.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream sparqlSelectQuery(String query, RDFService.ResultFormat resultFormat) throws RDFServiceException {
        this.dataset.begin(ReadWrite.READ);
        try {
            InputStream inputStream = super.sparqlSelectQuery(query, resultFormat);
            return inputStream;
        }
        finally {
            this.dataset.end();
        }
    }

    @Override
    public void sparqlSelectQuery(String query, ResultSetConsumer consumer) throws RDFServiceException {
        this.dataset.begin(ReadWrite.READ);
        try {
            super.sparqlSelectQuery(query, consumer);
        }
        finally {
            this.dataset.end();
        }
    }

    @Override
    public boolean sparqlAskQuery(String query) throws RDFServiceException {
        this.dataset.begin(ReadWrite.READ);
        try {
            boolean bl = super.sparqlAskQuery(query);
            return bl;
        }
        finally {
            this.dataset.end();
        }
    }

    @Override
    public List<String> getGraphURIs() throws RDFServiceException {
        this.dataset.begin(ReadWrite.READ);
        try {
            List<String> list = super.getGraphURIs();
            return list;
        }
        finally {
            this.dataset.end();
        }
    }

    @Override
    public void serializeAll(OutputStream outputStream) throws RDFServiceException {
        this.dataset.begin(ReadWrite.READ);
        try {
            super.serializeAll(outputStream);
        }
        finally {
            this.dataset.end();
        }
    }

    @Override
    public void serializeGraph(String graphURI, OutputStream outputStream) throws RDFServiceException {
        this.dataset.begin(ReadWrite.READ);
        try {
            super.serializeGraph(graphURI, outputStream);
        }
        finally {
            this.dataset.end();
        }
    }

    @Override
    public boolean isEquivalentGraph(String graphURI, InputStream serializedGraph, RDFService.ModelSerializationFormat serializationFormat) throws RDFServiceException {
        return super.isEquivalentGraph(graphURI, this.adjustForIntegers(serializedGraph), serializationFormat);
    }

    @Override
    public boolean isEquivalentGraph(String graphURI, Model graph) throws RDFServiceException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        graph.write((OutputStream)buffer, "N-TRIPLE");
        ByteArrayInputStream inStream = new ByteArrayInputStream(buffer.toByteArray());
        return this.isEquivalentGraph(graphURI, inStream, RDFService.ModelSerializationFormat.NTRIPLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countTriples(RDFNode subject, RDFNode predicate, RDFNode object) throws RDFServiceException {
        this.dataset.begin(ReadWrite.READ);
        try {
            long l = super.countTriples(subject, predicate, object);
            return l;
        }
        finally {
            this.dataset.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model getTriples(RDFNode subject, RDFNode predicate, RDFNode object, long limit, long offset) throws RDFServiceException {
        this.dataset.begin(ReadWrite.READ);
        try {
            Model model = super.getTriples(subject, predicate, object, limit, offset);
            return model;
        }
        finally {
            this.dataset.end();
        }
    }

    private InputStream adjustForIntegers(InputStream serializedGraph) throws RDFServiceException {
        try {
            String raw;
            String modified = raw = IOUtils.toString((InputStream)serializedGraph, (String)"UTF-8");
            modified = modified.replaceAll("\\^\\^<http://www.w3.org/2001/XMLSchema#int>|\\^\\^<http://www.w3.org/2001/XMLSchema#long>|\\^\\^<http://www.w3.org/2001/XMLSchema#short>|\\^\\^<http://www.w3.org/2001/XMLSchema#unsignedByte>|\\^\\^<http://www.w3.org/2001/XMLSchema#unsignedShort>|\\^\\^<http://www.w3.org/2001/XMLSchema#unsignedInt>|\\^\\^<http://www.w3.org/2001/XMLSchema#unsignedLong>|\\^\\^<http://www.w3.org/2001/XMLSchema#nonPositiveInteger>|\\^\\^<http://www.w3.org/2001/XMLSchema#nonNegativeInteger>|\\^\\^<http://www.w3.org/2001/XMLSchema#positiveInteger>|\\^\\^<http://www.w3.org/2001/XMLSchema#negativeInteger>", "^^<http://www.w3.org/2001/XMLSchema#integer>");
            return new ByteArrayInputStream(modified.getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new RDFServiceException(e);
        }
    }
}

