/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.filter;

import edu.cornell.mannlib.vitro.webapp.rdfservice.filter.LangSort;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public class LanguageFilterModel {
    private static final Log log = LogFactory.getLog(LanguageFilterModel.class);

    public Model filterModel(Model m, List<String> langs) {
        log.debug((Object)"filterModel");
        ArrayList<Statement> retractions = new ArrayList<Statement>();
        StmtIterator stmtIt = m.listStatements();
        while (stmtIt.hasNext()) {
            List candidatesForRemoval;
            Statement stmt = stmtIt.nextStatement();
            if (!stmt.getObject().isLiteral() || (candidatesForRemoval = m.listStatements(stmt.getSubject(), stmt.getPredicate(), (RDFNode)null).toList()).size() == 1) continue;
            candidatesForRemoval.sort(new StatementSortByLang(langs));
            log.debug((Object)("sorted statements: " + this.showSortedStatements(candidatesForRemoval)));
            Iterator candIt = candidatesForRemoval.iterator();
            String langRegister = null;
            boolean chuckRemaining = false;
            while (candIt.hasNext()) {
                Statement s = (Statement)candIt.next();
                if (!s.getObject().isLiteral()) continue;
                if (chuckRemaining) {
                    retractions.add(s);
                }
                String lang = s.getObject().asLiteral().getLanguage();
                if (langRegister == null) {
                    langRegister = lang;
                    continue;
                }
                if (langRegister.equals(lang)) continue;
                chuckRemaining = true;
                retractions.add(s);
            }
        }
        m.remove(retractions);
        return m;
    }

    private String showSortedStatements(List<Statement> candidatesForRemoval) {
        ArrayList<String> langStrings = new ArrayList<String>();
        for (Statement stmt : candidatesForRemoval) {
            if (stmt == null) {
                langStrings.add("null stmt");
                continue;
            }
            RDFNode node = stmt.getObject();
            if (!node.isLiteral()) {
                langStrings.add("not literal");
                continue;
            }
            langStrings.add(node.asLiteral().getLanguage());
        }
        return ((Object)langStrings).toString();
    }

    private class StatementSortByLang
    extends LangSort
    implements Comparator<Statement> {
        public StatementSortByLang(List<String> langs) {
            super(langs);
        }

        @Override
        public int compare(Statement s1, Statement s2) {
            if (s1 == null || s2 == null) {
                return 0;
            }
            if (!s1.getObject().isLiteral() || !s2.getObject().isLiteral()) {
                return 0;
            }
            String s1lang = s1.getObject().asLiteral().getLanguage();
            String s2lang = s2.getObject().asLiteral().getLanguage();
            return this.compareLangs(s1lang, s2lang);
        }
    }
}

