/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.adapters;

import edu.cornell.mannlib.vitro.webapp.dao.jena.BlankNodeFilteringGraph;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceGraph;
import edu.cornell.mannlib.vitro.webapp.dao.jena.SparqlGraph;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.AbstractBulkUpdater;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.BulkUpdatingModel;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.BulkUpdatingOntModel;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.GraphUtils;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.RDFServiceBulkUpdater;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.SparqlBulkUpdater;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.VitroModelFactory;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;

public class RDFServiceBulkUnionUpdater
extends AbstractBulkUpdater {
    private AbstractBulkUpdater leftUpdater;
    private AbstractBulkUpdater rightUpdater;
    private Model baseModel;
    private Model plusModel;

    public RDFServiceBulkUnionUpdater(Model baseModel, Model plusModel) {
        this.baseModel = baseModel;
        this.plusModel = plusModel;
        if (baseModel != null) {
            this.leftUpdater = this.getUpdater(baseModel);
        }
        if (plusModel != null) {
            this.rightUpdater = this.getUpdater(plusModel);
        }
    }

    public RDFServiceBulkUnionUpdater(VitroModelFactory.BulkUpdatingUnion union) {
        this.baseModel = union.getBaseModel();
        if (this.baseModel != null) {
            this.leftUpdater = this.getUpdater(this.baseModel);
        }
        this.plusModel = union.getPlusModel();
        if (this.plusModel != null) {
            this.rightUpdater = this.getUpdater(this.plusModel);
        }
    }

    private AbstractBulkUpdater getUpdater(Model model) {
        AbstractBulkUpdater updater = null;
        if (model instanceof BulkUpdatingOntModel) {
            updater = ((BulkUpdatingOntModel)model).updater;
            return updater;
        }
        if (model instanceof BulkUpdatingModel) {
            updater = ((BulkUpdatingModel)model).updater;
            return updater;
        }
        Graph graph = GraphUtils.unwrapUnionGraphs(model.getGraph());
        if (graph instanceof VitroModelFactory.BulkUpdatingUnion) {
            updater = new RDFServiceBulkUnionUpdater((VitroModelFactory.BulkUpdatingUnion)graph);
        } else if (graph instanceof RDFServiceGraph) {
            updater = new RDFServiceBulkUpdater((RDFServiceGraph)graph);
        } else if (this.hasBlankNodeFilterginGraphInnerRdfServiceGraph(graph)) {
            BlankNodeFilteringGraph blankNodeGraph = (BlankNodeFilteringGraph)graph;
            RDFServiceGraph rdfServiceGraph = (RDFServiceGraph)blankNodeGraph.getInnerGraph();
            updater = new RDFServiceBulkUpdater(rdfServiceGraph);
        } else {
            updater = graph instanceof VitroModelFactory.BulkUpdatingUnion ? new RDFServiceBulkUnionUpdater((VitroModelFactory.BulkUpdatingUnion)graph) : (graph instanceof SparqlGraph ? new SparqlBulkUpdater((SparqlGraph)graph) : null);
        }
        return updater;
    }

    private boolean hasBlankNodeFilterginGraphInnerRdfServiceGraph(Graph graph) {
        if (!(graph instanceof BlankNodeFilteringGraph)) {
            return false;
        }
        BlankNodeFilteringGraph blankNodeGraph = (BlankNodeFilteringGraph)graph;
        Graph innerGraph = blankNodeGraph.getInnerGraph();
        return innerGraph instanceof RDFServiceGraph;
    }

    @Override
    protected void performAddModel(Model model) {
        if (this.leftUpdater != null) {
            this.leftUpdater.performAddModel(model);
        } else if (this.baseModel != null) {
            this.baseModel.add(model);
        }
    }

    @Override
    protected void performRemoveModel(Model model) {
        if (this.leftUpdater != null) {
            this.leftUpdater.performRemoveModel(model);
        } else if (this.baseModel != null) {
            this.baseModel.remove(model);
        }
        if (this.rightUpdater != null) {
            this.rightUpdater.performRemoveModel(model);
        } else if (this.plusModel != null) {
            this.plusModel.remove(model);
        }
    }

    @Override
    protected void performRemoveAll() {
        if (this.leftUpdater != null) {
            this.leftUpdater.performRemoveAll();
        } else if (this.baseModel != null) {
            this.baseModel.removeAll();
        }
        if (this.rightUpdater != null) {
            this.rightUpdater.performRemoveAll();
        } else if (this.plusModel != null) {
            this.plusModel.removeAll();
        }
    }
}

