/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.adapters;

import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Alt;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Bag;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.NsIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.RDFReader;
import org.apache.jena.rdf.model.RDFWriter;
import org.apache.jena.rdf.model.RSIterator;
import org.apache.jena.rdf.model.ReifiedStatement;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceF;
import org.apache.jena.rdf.model.Selector;
import org.apache.jena.rdf.model.Seq;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.Command;
import org.apache.jena.shared.Lock;
import org.apache.jena.shared.PrefixMapping;

public abstract class AbstractModelDecorator
implements Model {
    private final Model inner;

    protected AbstractModelDecorator(Model m) {
        if (m == null) {
            throw new IllegalArgumentException("m may not be null.");
        }
        this.inner = m;
    }

    public String toString() {
        return ToString.simpleName(this) + "[" + ToString.hashHex(this) + ", inner=" + ToString.modelToString(this.inner) + "]";
    }

    @Deprecated
    public Resource getResource(String uri, ResourceF f) {
        return this.inner.getResource(uri, f);
    }

    public Property getProperty(String uri) {
        return this.inner.getProperty(uri);
    }

    public Bag getBag(String uri) {
        return this.inner.getBag(uri);
    }

    public Bag getBag(Resource r) {
        return this.inner.getBag(r);
    }

    public Alt getAlt(String uri) {
        return this.inner.getAlt(uri);
    }

    public Alt getAlt(Resource r) {
        return this.inner.getAlt(r);
    }

    public Seq getSeq(String uri) {
        return this.inner.getSeq(uri);
    }

    public Seq getSeq(Resource r) {
        return this.inner.getSeq(r);
    }

    public Resource createResource(Resource type) {
        return this.inner.createResource(type);
    }

    public RDFNode getRDFNode(Node n) {
        return this.inner.getRDFNode(n);
    }

    public Resource createResource(String uri, Resource type) {
        return this.inner.createResource(uri, type);
    }

    @Deprecated
    public Resource createResource(ResourceF f) {
        return this.inner.createResource(f);
    }

    @Deprecated
    public Resource createResource(String uri, ResourceF f) {
        return this.inner.createResource(uri, f);
    }

    public Property createProperty(String uri) {
        return this.inner.createProperty(uri);
    }

    public Literal createLiteral(String v) {
        return this.inner.createLiteral(v);
    }

    public Literal createTypedLiteral(boolean v) {
        return this.inner.createTypedLiteral(v);
    }

    public Literal createTypedLiteral(int v) {
        return this.inner.createTypedLiteral(v);
    }

    public Literal createTypedLiteral(long v) {
        return this.inner.createTypedLiteral(v);
    }

    public Literal createTypedLiteral(Calendar d) {
        return this.inner.createTypedLiteral(d);
    }

    public Literal createTypedLiteral(char v) {
        return this.inner.createTypedLiteral(v);
    }

    public Literal createTypedLiteral(float v) {
        return this.inner.createTypedLiteral(v);
    }

    public Literal createTypedLiteral(double v) {
        return this.inner.createTypedLiteral(v);
    }

    public Literal createTypedLiteral(String v) {
        return this.inner.createTypedLiteral(v);
    }

    public Literal createTypedLiteral(String lex, String typeURI) {
        return this.inner.createTypedLiteral(lex, typeURI);
    }

    public Literal createTypedLiteral(Object value, String typeURI) {
        return this.inner.createTypedLiteral(value, typeURI);
    }

    public Statement createLiteralStatement(Resource s, Property p, boolean o) {
        return this.inner.createLiteralStatement(s, p, o);
    }

    public Statement createLiteralStatement(Resource s, Property p, float o) {
        return this.inner.createLiteralStatement(s, p, o);
    }

    public Statement createLiteralStatement(Resource s, Property p, double o) {
        return this.inner.createLiteralStatement(s, p, o);
    }

    public Statement createLiteralStatement(Resource s, Property p, long o) {
        return this.inner.createLiteralStatement(s, p, o);
    }

    public Statement createLiteralStatement(Resource s, Property p, int o) {
        return this.inner.createLiteralStatement(s, p, o);
    }

    public Statement createLiteralStatement(Resource s, Property p, char o) {
        return this.inner.createLiteralStatement(s, p, o);
    }

    public Statement createLiteralStatement(Resource s, Property p, Object o) {
        return this.inner.createLiteralStatement(s, p, o);
    }

    public Statement createStatement(Resource s, Property p, String o) {
        return this.inner.createStatement(s, p, o);
    }

    public Statement createStatement(Resource s, Property p, String o, String l) {
        return this.inner.createStatement(s, p, o, l);
    }

    public Statement createStatement(Resource s, Property p, String o, boolean wellFormed) {
        return this.inner.createStatement(s, p, o, wellFormed);
    }

    public Statement createStatement(Resource s, Property p, String o, String l, boolean wellFormed) {
        return this.inner.createStatement(s, p, o, l, wellFormed);
    }

    public Bag createBag() {
        return this.inner.createBag();
    }

    public Bag createBag(String uri) {
        return this.inner.createBag(uri);
    }

    public Alt createAlt() {
        return this.inner.createAlt();
    }

    public Model setNsPrefix(String prefix, String uri) {
        return this.inner.setNsPrefix(prefix, uri);
    }

    public Model removeNsPrefix(String prefix) {
        return this.inner.removeNsPrefix(prefix);
    }

    public Model setNsPrefixes(PrefixMapping other) {
        return this.inner.setNsPrefixes(other);
    }

    public Model setNsPrefixes(Map<String, String> map) {
        return this.inner.setNsPrefixes(map);
    }

    public Model withDefaultMappings(PrefixMapping map) {
        return this.inner.withDefaultMappings(map);
    }

    public String getNsPrefixURI(String prefix) {
        return this.inner.getNsPrefixURI(prefix);
    }

    public String getNsURIPrefix(String uri) {
        return this.inner.getNsURIPrefix(uri);
    }

    public Map<String, String> getNsPrefixMap() {
        return this.inner.getNsPrefixMap();
    }

    public String expandPrefix(String prefixed) {
        return this.inner.expandPrefix(prefixed);
    }

    public String shortForm(String uri) {
        return this.inner.shortForm(uri);
    }

    public String qnameFor(String uri) {
        return this.inner.qnameFor(uri);
    }

    public PrefixMapping lock() {
        return this.inner.lock();
    }

    public boolean hasNoMappings() {
        return this.inner.hasNoMappings();
    }

    public boolean samePrefixMappingAs(PrefixMapping other) {
        return this.inner.samePrefixMappingAs(other);
    }

    public Statement asStatement(Triple t) {
        return this.inner.asStatement(t);
    }

    public Graph getGraph() {
        return this.inner.getGraph();
    }

    public RDFNode asRDFNode(Node n) {
        return this.inner.asRDFNode(n);
    }

    public Resource wrapAsResource(Node n) {
        return this.inner.wrapAsResource(n);
    }

    public RDFReader getReader() {
        return this.inner.getReader();
    }

    public RDFReader getReader(String lang) {
        return this.inner.getReader(lang);
    }

    public String setReaderClassName(String lang, String className) {
        return this.inner.setReaderClassName(lang, className);
    }

    public void resetRDFReaderF() {
        this.inner.resetRDFReaderF();
    }

    public String removeReader(String s) throws IllegalArgumentException {
        return this.inner.removeReader(s);
    }

    public RDFWriter getWriter() {
        return this.inner.getWriter();
    }

    public RDFWriter getWriter(String lang) {
        return this.inner.getWriter(lang);
    }

    public String setWriterClassName(String lang, String className) {
        return this.inner.setWriterClassName(lang, className);
    }

    public void resetRDFWriterF() {
        this.inner.resetRDFWriterF();
    }

    public String removeWriter(String s) throws IllegalArgumentException {
        return this.inner.removeWriter(s);
    }

    public Alt createAlt(String uri) {
        return this.inner.createAlt(uri);
    }

    public Seq createSeq() {
        return this.inner.createSeq();
    }

    public Seq createSeq(String uri) {
        return this.inner.createSeq(uri);
    }

    public Model add(Resource s, Property p, RDFNode o) {
        return this.inner.add(s, p, o);
    }

    public Model addLiteral(Resource s, Property p, boolean o) {
        return this.inner.addLiteral(s, p, o);
    }

    public Model addLiteral(Resource s, Property p, long o) {
        return this.inner.addLiteral(s, p, o);
    }

    public Model addLiteral(Resource s, Property p, int o) {
        return this.inner.addLiteral(s, p, o);
    }

    public Model addLiteral(Resource s, Property p, char o) {
        return this.inner.addLiteral(s, p, o);
    }

    public Model addLiteral(Resource s, Property p, float o) {
        return this.inner.addLiteral(s, p, o);
    }

    public Model addLiteral(Resource s, Property p, double o) {
        return this.inner.addLiteral(s, p, o);
    }

    @Deprecated
    public Model addLiteral(Resource s, Property p, Object o) {
        return this.inner.addLiteral(s, p, o);
    }

    public Model addLiteral(Resource s, Property p, Literal o) {
        return this.inner.addLiteral(s, p, o);
    }

    public Model add(Resource s, Property p, String o) {
        return this.inner.add(s, p, o);
    }

    public Model add(Resource s, Property p, String lex, RDFDatatype datatype) {
        return this.inner.add(s, p, lex, datatype);
    }

    public Model add(Resource s, Property p, String o, boolean wellFormed) {
        return this.inner.add(s, p, o, wellFormed);
    }

    public Model add(Resource s, Property p, String o, String l) {
        return this.inner.add(s, p, o, l);
    }

    public Model remove(Resource s, Property p, RDFNode o) {
        return this.inner.remove(s, p, o);
    }

    public Model remove(StmtIterator iter) {
        return this.inner.remove(iter);
    }

    public Model remove(Model m) {
        return this.inner.remove(m);
    }

    public StmtIterator listLiteralStatements(Resource subject, Property predicate, boolean object) {
        return this.inner.listLiteralStatements(subject, predicate, object);
    }

    public StmtIterator listLiteralStatements(Resource subject, Property predicate, char object) {
        return this.inner.listLiteralStatements(subject, predicate, object);
    }

    public StmtIterator listLiteralStatements(Resource subject, Property predicate, int object) {
        return this.inner.listLiteralStatements(subject, predicate, object);
    }

    public StmtIterator listLiteralStatements(Resource subject, Property predicate, long object) {
        return this.inner.listLiteralStatements(subject, predicate, object);
    }

    public StmtIterator listLiteralStatements(Resource subject, Property predicate, float object) {
        return this.inner.listLiteralStatements(subject, predicate, object);
    }

    public StmtIterator listLiteralStatements(Resource subject, Property predicate, double object) {
        return this.inner.listLiteralStatements(subject, predicate, object);
    }

    public StmtIterator listStatements(Resource subject, Property predicate, String object) {
        return this.inner.listStatements(subject, predicate, object);
    }

    public StmtIterator listStatements(Resource subject, Property predicate, String object, String lang) {
        return this.inner.listStatements(subject, predicate, object, lang);
    }

    public ResIterator listResourcesWithProperty(Property p, boolean o) {
        return this.inner.listResourcesWithProperty(p, o);
    }

    public ResIterator listResourcesWithProperty(Property p, long o) {
        return this.inner.listResourcesWithProperty(p, o);
    }

    public ResIterator listResourcesWithProperty(Property p, char o) {
        return this.inner.listResourcesWithProperty(p, o);
    }

    public ResIterator listResourcesWithProperty(Property p, float o) {
        return this.inner.listResourcesWithProperty(p, o);
    }

    public ResIterator listResourcesWithProperty(Property p, double o) {
        return this.inner.listResourcesWithProperty(p, o);
    }

    public ResIterator listResourcesWithProperty(Property p, Object o) {
        return this.inner.listResourcesWithProperty(p, o);
    }

    public ResIterator listSubjectsWithProperty(Property p, String o) {
        return this.inner.listSubjectsWithProperty(p, o);
    }

    public ResIterator listSubjectsWithProperty(Property p, String o, String l) {
        return this.inner.listSubjectsWithProperty(p, o, l);
    }

    public boolean containsLiteral(Resource s, Property p, boolean o) {
        return this.inner.containsLiteral(s, p, o);
    }

    public boolean containsLiteral(Resource s, Property p, long o) {
        return this.inner.containsLiteral(s, p, o);
    }

    public boolean containsLiteral(Resource s, Property p, int o) {
        return this.inner.containsLiteral(s, p, o);
    }

    public boolean containsLiteral(Resource s, Property p, char o) {
        return this.inner.containsLiteral(s, p, o);
    }

    public boolean containsLiteral(Resource s, Property p, float o) {
        return this.inner.containsLiteral(s, p, o);
    }

    public boolean containsLiteral(Resource s, Property p, double o) {
        return this.inner.containsLiteral(s, p, o);
    }

    public boolean containsLiteral(Resource s, Property p, Object o) {
        return this.inner.containsLiteral(s, p, o);
    }

    public boolean contains(Resource s, Property p, String o) {
        return this.inner.contains(s, p, o);
    }

    public boolean contains(Resource s, Property p, String o, String l) {
        return this.inner.contains(s, p, o, l);
    }

    public void enterCriticalSection(boolean readLockRequested) {
        this.inner.enterCriticalSection(readLockRequested);
    }

    public void leaveCriticalSection() {
        this.inner.leaveCriticalSection();
    }

    public long size() {
        return this.inner.size();
    }

    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    public ResIterator listSubjects() {
        return this.inner.listSubjects();
    }

    public NsIterator listNameSpaces() {
        return this.inner.listNameSpaces();
    }

    public Resource getResource(String uri) {
        return this.inner.getResource(uri);
    }

    public Property getProperty(String nameSpace, String localName) {
        return this.inner.getProperty(nameSpace, localName);
    }

    public Resource createResource() {
        return this.inner.createResource();
    }

    public Resource createResource(AnonId id) {
        return this.inner.createResource(id);
    }

    public Resource createResource(String uri) {
        return this.inner.createResource(uri);
    }

    public Resource createResource(Statement statement) {
        return this.inner.createResource(statement);
    }

    public Property createProperty(String nameSpace, String localName) {
        return this.inner.createProperty(nameSpace, localName);
    }

    public Literal createLiteral(String v, String language) {
        return this.inner.createLiteral(v, language);
    }

    public Literal createLiteral(String v, boolean wellFormed) {
        return this.inner.createLiteral(v, wellFormed);
    }

    public Literal createTypedLiteral(String lex, RDFDatatype dtype) {
        return this.inner.createTypedLiteral(lex, dtype);
    }

    public Literal createTypedLiteral(Object value, RDFDatatype dtype) {
        return this.inner.createTypedLiteral(value, dtype);
    }

    public Literal createTypedLiteral(Object value) {
        return this.inner.createTypedLiteral(value);
    }

    public Statement createStatement(Resource s, Property p, RDFNode o) {
        return this.inner.createStatement(s, p, o);
    }

    public RDFList createList() {
        return this.inner.createList();
    }

    public RDFList createList(Iterator<? extends RDFNode> members) {
        return this.inner.createList(members);
    }

    public RDFList createList(RDFNode[] members) {
        return this.inner.createList(members);
    }

    public Model add(Statement s) {
        return this.inner.add(s);
    }

    public Model add(Statement[] statements) {
        return this.inner.add(statements);
    }

    public Model remove(Statement[] statements) {
        return this.inner.remove(statements);
    }

    public Model add(List<Statement> statements) {
        return this.inner.add(statements);
    }

    public Model remove(List<Statement> statements) {
        return this.inner.remove(statements);
    }

    public Model add(StmtIterator iter) {
        return this.inner.add(iter);
    }

    public Model add(Model m) {
        return this.inner.add(m);
    }

    public Model read(String url) {
        return this.inner.read(url);
    }

    public Model read(InputStream in, String base) {
        return this.inner.read(in, base);
    }

    public Model read(InputStream in, String base, String lang) {
        return this.inner.read(in, base, lang);
    }

    public Model read(Reader reader, String base) {
        return this.inner.read(reader, base);
    }

    public Model read(String url, String lang) {
        return this.inner.read(url, lang);
    }

    public Model read(Reader reader, String base, String lang) {
        return this.inner.read(reader, base, lang);
    }

    public Model read(String url, String base, String lang) {
        return this.inner.read(url, base, lang);
    }

    public Model write(Writer writer) {
        return this.inner.write(writer);
    }

    public Model write(Writer writer, String lang) {
        return this.inner.write(writer, lang);
    }

    public Model write(Writer writer, String lang, String base) {
        return this.inner.write(writer, lang, base);
    }

    public Model write(OutputStream out) {
        return this.inner.write(out);
    }

    public Model write(OutputStream out, String lang) {
        return this.inner.write(out, lang);
    }

    public Model write(OutputStream out, String lang, String base) {
        return this.inner.write(out, lang, base);
    }

    public Model remove(Statement s) {
        return this.inner.remove(s);
    }

    public Statement getRequiredProperty(Resource s, Property p) {
        return this.inner.getRequiredProperty(s, p);
    }

    public Statement getProperty(Resource s, Property p) {
        return this.inner.getProperty(s, p);
    }

    public ResIterator listSubjectsWithProperty(Property p) {
        return this.inner.listSubjectsWithProperty(p);
    }

    public ResIterator listResourcesWithProperty(Property p) {
        return this.inner.listResourcesWithProperty(p);
    }

    public ResIterator listSubjectsWithProperty(Property p, RDFNode o) {
        return this.inner.listSubjectsWithProperty(p, o);
    }

    public ResIterator listResourcesWithProperty(Property p, RDFNode o) {
        return this.inner.listResourcesWithProperty(p, o);
    }

    public NodeIterator listObjects() {
        return this.inner.listObjects();
    }

    public NodeIterator listObjectsOfProperty(Property p) {
        return this.inner.listObjectsOfProperty(p);
    }

    public NodeIterator listObjectsOfProperty(Resource s, Property p) {
        return this.inner.listObjectsOfProperty(s, p);
    }

    public boolean contains(Resource s, Property p) {
        return this.inner.contains(s, p);
    }

    public boolean containsResource(RDFNode r) {
        return this.inner.containsResource(r);
    }

    public boolean contains(Resource s, Property p, RDFNode o) {
        return this.inner.contains(s, p, o);
    }

    public boolean contains(Statement s) {
        return this.inner.contains(s);
    }

    public boolean containsAny(StmtIterator iter) {
        return this.inner.containsAny(iter);
    }

    public boolean containsAll(StmtIterator iter) {
        return this.inner.containsAll(iter);
    }

    public boolean containsAny(Model model) {
        return this.inner.containsAny(model);
    }

    public boolean containsAll(Model model) {
        return this.inner.containsAll(model);
    }

    public boolean isReified(Statement s) {
        return this.inner.isReified(s);
    }

    public Resource getAnyReifiedStatement(Statement s) {
        return this.inner.getAnyReifiedStatement(s);
    }

    public void removeAllReifications(Statement s) {
        this.inner.removeAllReifications(s);
    }

    public void removeReification(ReifiedStatement rs) {
        this.inner.removeReification(rs);
    }

    public StmtIterator listStatements() {
        return this.inner.listStatements();
    }

    public StmtIterator listStatements(Selector s) {
        return this.inner.listStatements(s);
    }

    public StmtIterator listStatements(Resource s, Property p, RDFNode o) {
        return this.inner.listStatements(s, p, o);
    }

    public ReifiedStatement createReifiedStatement(Statement s) {
        return this.inner.createReifiedStatement(s);
    }

    public ReifiedStatement createReifiedStatement(String uri, Statement s) {
        return this.inner.createReifiedStatement(uri, s);
    }

    public RSIterator listReifiedStatements() {
        return this.inner.listReifiedStatements();
    }

    public RSIterator listReifiedStatements(Statement st) {
        return this.inner.listReifiedStatements(st);
    }

    public Model query(Selector s) {
        return this.inner.query(s);
    }

    public Model union(Model model) {
        return this.inner.union(model);
    }

    public Model intersection(Model model) {
        return this.inner.intersection(model);
    }

    public Model difference(Model model) {
        return this.inner.difference(model);
    }

    public Model begin() {
        return this.inner.begin();
    }

    public Model abort() {
        return this.inner.abort();
    }

    public Model commit() {
        return this.inner.commit();
    }

    public Object executeInTransaction(Command cmd) {
        return this.inner.executeInTransaction(cmd);
    }

    public boolean independent() {
        return this.inner.independent();
    }

    public boolean supportsTransactions() {
        return this.inner.supportsTransactions();
    }

    public boolean supportsSetOperations() {
        return this.inner.supportsSetOperations();
    }

    public boolean isIsomorphicWith(Model g) {
        return this.inner.isIsomorphicWith(g);
    }

    public void close() {
        this.inner.close();
    }

    public Lock getLock() {
        return this.inner.getLock();
    }

    public Model register(ModelChangedListener listener) {
        return this.inner.register(listener);
    }

    public Model unregister(ModelChangedListener listener) {
        return this.inner.unregister(listener);
    }

    public Model notifyEvent(Object e) {
        return this.inner.notifyEvent(e);
    }

    public Model removeAll() {
        return this.inner.removeAll();
    }

    public Model removeAll(Resource s, Property p, RDFNode r) {
        return this.inner.removeAll(s, p, r);
    }

    public boolean isClosed() {
        return this.inner.isClosed();
    }

    public Statement getRequiredProperty(Resource resource, Property property, String s) {
        return this.inner.getRequiredProperty(resource, property, s);
    }

    public Statement getProperty(Resource resource, Property property, String s) {
        return this.inner.getProperty(resource, property, s);
    }

    public void executeInTxn(Runnable runnable) {
        this.inner.executeInTxn(runnable);
    }

    public <T> T calculateInTxn(Supplier<T> supplier) {
        return (T)this.inner.calculateInTxn(supplier);
    }

    public Model clearNsPrefixMap() {
        return this.inner.clearNsPrefixMap();
    }

    public int numPrefixes() {
        return this.inner.numPrefixes();
    }

    public RDFList getList(String s) {
        return this.inner.getList(s);
    }

    public RDFList getList(Resource resource) {
        return this.inner.getList(resource);
    }
}

