/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.adapters;

import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public abstract class AbstractBulkUpdater {
    public void add(Graph g) {
        Model[] model = this.separateStatementsWithBlankNodes(g);
        this.performAddModel(model[1]);
        this.performAddModel(model[0]);
    }

    public void remove(Graph g) {
        this.performRemoveModel(ModelFactory.createModelForGraph((Graph)g));
    }

    public void removeAll() {
        this.performRemoveAll();
    }

    protected abstract void performAddModel(Model var1);

    protected abstract void performRemoveModel(Model var1);

    protected abstract void performRemoveAll();

    private Model[] separateStatementsWithBlankNodes(Graph g) {
        Model gm = ModelFactory.createModelForGraph((Graph)g);
        Model blankNodeModel = ModelFactory.createDefaultModel();
        Model nonBlankNodeModel = ModelFactory.createDefaultModel();
        StmtIterator sit = gm.listStatements();
        while (sit.hasNext()) {
            Statement stmt = sit.nextStatement();
            if (!stmt.getSubject().isAnon() && !stmt.getObject().isAnon()) {
                nonBlankNodeModel.add(stmt);
                continue;
            }
            blankNodeModel.add(stmt);
        }
        Model[] result = new Model[]{blankNodeModel, nonBlankNodeModel};
        return result;
    }
}

