/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.modelaccess.adapters;

import edu.cornell.mannlib.vitro.webapp.modelaccess.adapters.AbstractModelMakerDecorator;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelMaker;
import org.apache.jena.rdf.model.ModelReader;
import org.apache.jena.util.iterator.ExtendedIterator;

public class NamedDefaultModelMaker
extends AbstractModelMakerDecorator {
    private static final Log log = LogFactory.getLog(NamedDefaultModelMaker.class);
    private final String defaultModelUri;

    public NamedDefaultModelMaker(ModelMaker inner, String defaultModelUri) {
        super(inner);
        this.defaultModelUri = defaultModelUri;
    }

    private boolean isDefaultModel(String name) {
        return name != null && name.equals(this.defaultModelUri);
    }

    @Override
    public Model openModel(String name) {
        if (this.isDefaultModel(name)) {
            return super.createDefaultModel();
        }
        return super.openModel(name);
    }

    @Override
    public Model openModelIfPresent(String name) {
        if (this.isDefaultModel(name)) {
            return super.createDefaultModel();
        }
        return super.openModelIfPresent(name);
    }

    @Override
    public Model getModel(String name) {
        if (this.isDefaultModel(name)) {
            return super.createDefaultModel();
        }
        return super.getModel(name);
    }

    @Override
    public Model getModel(String name, ModelReader loadIfAbsent) {
        if (this.isDefaultModel(name)) {
            return super.createDefaultModel();
        }
        return super.getModel(name, loadIfAbsent);
    }

    @Override
    public Model createModel(String name, boolean strict) {
        if (this.isDefaultModel(name)) {
            return super.createDefaultModel();
        }
        return super.createModel(name, strict);
    }

    @Override
    public Model createModel(String name) {
        if (this.isDefaultModel(name)) {
            return super.createDefaultModel();
        }
        return super.createModel(name);
    }

    @Override
    public Model openModel(String name, boolean strict) {
        if (this.isDefaultModel(name)) {
            return super.createDefaultModel();
        }
        return super.openModel(name, strict);
    }

    @Override
    public void removeModel(String name) {
        if (this.isDefaultModel(name)) {
            log.warn((Object)"Attempting to remove the default model.");
        } else {
            super.removeModel(name);
        }
    }

    @Override
    public boolean hasModel(String name) {
        if (this.isDefaultModel(name)) {
            return true;
        }
        return super.hasModel(name);
    }

    @Override
    public ExtendedIterator<String> listModels() {
        return super.listModels().andThen(Collections.singleton(this.defaultModelUri).iterator());
    }
}

