/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.modelaccess.adapters;

import edu.cornell.mannlib.vitro.webapp.modelaccess.adapters.AbstractModelMakerDecorator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelMaker;
import org.apache.jena.rdf.model.ModelReader;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class ModelMakerWithPersistentEmptyModels
extends AbstractModelMakerDecorator {
    private final Set<String> modelNames = new HashSet<String>();

    public ModelMakerWithPersistentEmptyModels(ModelMaker inner) {
        super(inner);
    }

    @Override
    public boolean hasModel(String name) {
        return this.modelNames.contains(name) || super.hasModel(name);
    }

    @Override
    public ExtendedIterator<String> listModels() {
        TreeSet<String> allNames = new TreeSet<String>(this.modelNames);
        allNames.addAll(super.listModels().toList());
        return WrappedIterator.create(allNames.iterator());
    }

    @Override
    public Model getModel(String URL2) {
        Model m = super.getModel(URL2);
        if (m != null) {
            this.addModelNameIfNeeded(URL2);
        }
        return m;
    }

    @Override
    public Model getModel(String URL2, ModelReader loadIfAbsent) {
        Model m = super.getModel(URL2, loadIfAbsent);
        this.addModelNameIfNeeded(URL2);
        return m;
    }

    @Override
    public Model createModel(String name, boolean strict) {
        Model m = super.createModel(name, strict);
        this.addModelNameIfNeeded(name);
        return m;
    }

    @Override
    public Model createModel(String name) {
        return this.createModel(name, false);
    }

    @Override
    public Model openModel(String name) {
        Model m = super.openModel(name);
        this.addModelNameIfNeeded(name);
        return m;
    }

    @Override
    public Model openModelIfPresent(String name) {
        Model m = super.openModelIfPresent(name);
        if (m != null) {
            this.addModelNameIfNeeded(name);
        }
        return m;
    }

    @Override
    public Model openModel(String name, boolean strict) {
        Model m = super.openModel(name, strict);
        this.addModelNameIfNeeded(name);
        return m;
    }

    @Override
    public void removeModel(String name) {
        super.removeModel(name);
        this.modelNames.remove(name);
    }

    private void addModelNameIfNeeded(String name) {
        if (!super.listModels().toList().contains(name)) {
            this.modelNames.add(name);
        }
    }
}

