/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filters;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class VitroURL {
    private String characterEncoding;
    public String protocol;
    public String host;
    public String port;
    public List<String> pathParts;
    public List<String[]> queryParams;
    public String fragment;
    private Pattern pathPattern = Pattern.compile("([^\\?]*)\\??(.*)");
    private Pattern commaPattern = Pattern.compile("/");
    private Pattern equalsSignPattern = Pattern.compile("=");
    private Pattern ampersandPattern = Pattern.compile("&");
    public boolean pathBeginsWithSlash = false;
    public boolean pathEndsInSlash = false;
    public boolean wasXMLEscaped = false;
    private static final Log log = LogFactory.getLog(VitroURL.class);
    private Pattern simpleQueryParamPattern = Pattern.compile("^([^\\=]*)=([^\\&]*)");
    private Pattern finalQueryParamPattern = Pattern.compile("^(uri)=(.*)");

    public VitroURL(String urlStr, String characterEncoding) {
        this.characterEncoding = characterEncoding;
        if (urlStr.indexOf("&amp;") > -1) {
            this.wasXMLEscaped = true;
            urlStr = StringEscapeUtils.unescapeXml((String)urlStr);
        }
        try {
            URL url = new URL(urlStr);
            this.protocol = url.getProtocol();
            this.host = url.getHost();
            this.port = Integer.toString(url.getPort());
            this.pathParts = this.splitPath(url.getPath());
            this.pathBeginsWithSlash = this.beginsWithSlash(url.getPath());
            this.pathEndsInSlash = this.endsInSlash(url.getPath());
            this.queryParams = this.parseQueryParams(url.getQuery());
            this.fragment = url.getRef();
        }
        catch (Exception e) {
            Matcher m = this.pathPattern.matcher(urlStr);
            String[] urlParts = new String[2];
            if (m.matches()) {
                urlParts[0] = m.group(1);
                if (m.groupCount() == 2) {
                    urlParts[1] = m.group(2);
                }
            }
            try {
                this.pathParts = this.splitPath(URLDecoder.decode(this.getPath(urlStr), characterEncoding));
                this.pathBeginsWithSlash = this.beginsWithSlash(urlParts[0]);
                this.pathEndsInSlash = this.endsInSlash(urlParts[0]);
                if (urlParts.length > 1) {
                    this.queryParams = this.parseQueryParams(URLDecoder.decode(urlParts[1], characterEncoding));
                }
            }
            catch (UnsupportedEncodingException uee) {
                log.error((Object)("Unable to use character encoding " + characterEncoding), (Throwable)uee);
            }
        }
    }

    private String getPath(String urlStr) {
        Matcher m = this.pathPattern.matcher(urlStr);
        if (m.matches()) {
            return m.group(1);
        }
        return "";
    }

    private List<String> splitPath(String pathStr) {
        String[] splitStr = this.commaPattern.split(pathStr);
        if (splitStr.length > 0) {
            int len = splitStr.length;
            if (splitStr[0].equals("")) {
                --len;
            }
            if (splitStr[splitStr.length - 1].equals("")) {
                --len;
            }
            if (len > 0) {
                String[] temp = new String[len];
                int tempI = 0;
                for (String aSplitStr : splitStr) {
                    if (aSplitStr.equals("")) continue;
                    temp[tempI] = aSplitStr;
                    ++tempI;
                }
                splitStr = temp;
            }
        }
        ArrayList<String> strList = new ArrayList<String>();
        Collections.addAll(strList, splitStr);
        return strList;
    }

    public boolean beginsWithSlash(String pathStr) {
        if (pathStr.length() == 0) {
            return false;
        }
        return pathStr.charAt(0) == '/';
    }

    public boolean endsInSlash(String pathStr) {
        if (pathStr.length() == 0) {
            return false;
        }
        return pathStr.charAt(pathStr.length() - 1) == '/';
    }

    protected List<String[]> parseQueryParams(String queryStr) {
        ArrayList<String[]> queryParamList = new ArrayList<String[]>();
        if (queryStr == null) {
            return queryParamList;
        }
        while (queryStr.length() > 0) {
            String[] finalPair;
            String[] simplepair;
            if (queryStr.startsWith("&")) {
                queryStr = queryStr.substring(1);
            }
            if ((simplepair = this.getSimpleQueryMatch(queryStr)) != null) {
                if (simplepair[1].contains("?")) {
                    finalPair = this.getFinalPairQueryMatch(queryStr);
                    if (finalPair != null) {
                        queryParamList.add(finalPair);
                        queryStr = "";
                        continue;
                    }
                    throw new Error("Cannot parse query string for URL queryParams: \"" + queryStr + "\" this only accepts complex parameters in the final position with the key 'uri'.");
                }
                queryParamList.add(simplepair);
                queryStr = queryStr.substring(simplepair[0].length() + simplepair[1].length() + 1);
                continue;
            }
            finalPair = this.getFinalPairQueryMatch(queryStr);
            if (finalPair == null) continue;
            queryParamList.add(finalPair);
            queryStr = "";
        }
        return queryParamList;
    }

    protected String[] getSimpleQueryMatch(String querystr) {
        Matcher simpleMatch = this.simpleQueryParamPattern.matcher(querystr);
        if (simpleMatch.find()) {
            String[] rv = new String[]{simpleMatch.group(1), simpleMatch.group(2)};
            return rv;
        }
        return null;
    }

    protected String[] getFinalPairQueryMatch(String querystr) {
        Matcher finalMatch = this.finalQueryParamPattern.matcher(querystr);
        if (finalMatch.find()) {
            String[] rv = new String[]{finalMatch.group(1), finalMatch.group(2)};
            return rv;
        }
        return null;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        try {
            if (this.protocol != null) {
                out.append(this.protocol);
            }
            if (this.host != null) {
                out.append(this.host);
            }
            if (this.port != null) {
                out.append(":").append(this.port);
            }
            if (this.pathParts != null) {
                if (this.pathBeginsWithSlash) {
                    out.append("/");
                }
                Iterator<String> pathIt = this.pathParts.iterator();
                while (pathIt.hasNext()) {
                    String part = pathIt.next();
                    out.append(part);
                    if (!pathIt.hasNext()) continue;
                    out.append("/");
                }
                if (this.pathEndsInSlash) {
                    out.append("/");
                }
            }
            if (this.queryParams != null) {
                Iterator<String[]> qpIt = this.queryParams.iterator();
                if (qpIt.hasNext()) {
                    out.append("?");
                }
                while (qpIt.hasNext()) {
                    String[] keyAndValue = qpIt.next();
                    out.append(URLEncoder.encode(keyAndValue[0], this.characterEncoding)).append("=");
                    if (keyAndValue.length > 1) {
                        out.append(URLEncoder.encode(keyAndValue[1], this.characterEncoding));
                    }
                    if (!qpIt.hasNext()) continue;
                    out.append("&");
                }
            }
        }
        catch (UnsupportedEncodingException uee) {
            log.error((Object)("Unable to use encoding " + this.characterEncoding), (Throwable)uee);
        }
        String str = out.toString();
        if (this.wasXMLEscaped) {
            str = StringEscapeUtils.escapeXml((String)str);
        }
        return str;
    }
}

