/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryConfig;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaBaseDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.SimpleOntModelSelector;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.util.iterator.ExtendedIterator;

public class VClassGroupDaoJena
extends JenaBaseDao
implements VClassGroupDao {
    private static final Log log = LogFactory.getLog((String)VClassGroupDao.class.getName());

    public VClassGroupDaoJena(WebappDaoFactoryJena wadf) {
        super(wadf);
    }

    @Override
    protected OntModel getOntModel() {
        return this.getOntModelSelector().getApplicationMetadataModel();
    }

    @Override
    public void deleteVClassGroup(VClassGroup vcg) {
        this.deleteVClassGroup(vcg, this.getOntModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVClassGroup(VClassGroup vcg, OntModel ontModel) {
        ontModel.enterCriticalSection(false);
        try {
            Individual groupInd = ontModel.getIndividual(vcg.getURI());
            if (groupInd != null) {
                groupInd.remove();
            }
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        OntModel tboxModel = this.getOntModelSelector().getTBoxModel();
        tboxModel.enterCriticalSection(false);
        try {
            Resource groupRes = ResourceFactory.createResource((String)vcg.getURI());
            tboxModel.removeAll(groupRes, null, null);
            tboxModel.removeAll(null, null, (RDFNode)groupRes);
        }
        finally {
            tboxModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<String, VClassGroup> getClassGroupMap() {
        this.getOntModel().enterCriticalSection(true);
        try {
            LinkedHashMap<String, VClassGroup> map = new LinkedHashMap<String, VClassGroup>();
            ArrayList<VClassGroup> groups = new ArrayList<VClassGroup>();
            try (ExtendedIterator groupIt = this.getOntModel().listIndividuals((Resource)this.CLASSGROUP);){
                while (groupIt.hasNext()) {
                    Individual groupInd = (Individual)groupIt.next();
                    VClassGroup group = this.groupFromGroupIndividual(groupInd);
                    if (group == null) continue;
                    groups.add(group);
                }
            }
            Collections.sort(groups);
            for (VClassGroup group : groups) {
                map.put(group.getPublicName(), group);
            }
            LinkedHashMap<String, VClassGroup> linkedHashMap = map;
            return linkedHashMap;
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VClassGroup getGroupByURI(String uri) {
        if (uri == null) {
            return null;
        }
        this.getOntModel().enterCriticalSection(true);
        try {
            Individual group = this.getOntModel().getIndividual(uri);
            VClassGroup vClassGroup = this.groupFromGroupIndividual(group);
            return vClassGroup;
        }
        catch (IllegalArgumentException ex) {
            VClassGroup vClassGroup = null;
            return vClassGroup;
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public List<VClassGroup> getPublicGroupsWithVClasses() {
        return this.getPublicGroupsWithVClasses(false);
    }

    @Override
    public List<VClassGroup> getPublicGroupsWithVClasses(boolean displayOrder) {
        return this.getPublicGroupsWithVClasses(displayOrder, true);
    }

    @Override
    public List<VClassGroup> getPublicGroupsWithVClasses(boolean displayOrder, boolean includeUninstantiatedClasses) {
        return this.getPublicGroupsWithVClasses(displayOrder, includeUninstantiatedClasses, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VClassGroup> getPublicGroupsWithVClasses(boolean displayOrder, boolean includeUninstantiatedClasses, boolean getIndividualCount) {
        VClassDao classDao = this.getWebappDaoFactory().getVClassDao();
        ArrayList<VClassGroup> groups = new ArrayList<VClassGroup>();
        this.getOntModel().enterCriticalSection(true);
        try (ExtendedIterator groupIt = this.getOntModel().listIndividuals((Resource)this.CLASSGROUP);){
            while (groupIt.hasNext()) {
                Individual grp = (Individual)groupIt.next();
                VClassGroup vgrp = this.groupFromGroupIndividual(grp);
                if (vgrp == null) continue;
                groups.add(vgrp);
            }
            Collections.sort(groups);
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        for (VClassGroup vgrp : groups) {
            classDao.addVClassesToGroup(vgrp, includeUninstantiatedClasses, getIndividualCount);
        }
        if (groups.size() > 0) {
            return groups;
        }
        classDao.addVClassesToGroups(groups);
        return groups;
    }

    public VClassGroup groupFromGroupIndividual(Individual groupInd) {
        if (groupInd == null) {
            return null;
        }
        VClassGroup group = new VClassGroup();
        group.setPublicName(groupInd.getLabel(null));
        group.setURI(groupInd.getURI());
        group.setNamespace(groupInd.getNameSpace());
        group.setLocalName(groupInd.getLocalName());
        group.setDisplayRank(this.getPropertyNonNegativeIntValue((OntResource)groupInd, (Property)this.DISPLAY_RANK));
        return group;
    }

    @Override
    public int insertNewVClassGroup(VClassGroup vcg) {
        this.insertNewVClassGroup(vcg, this.getOntModelSelector().getApplicationMetadataModel());
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertNewVClassGroup(VClassGroup vcg, OntModel ontModel) {
        IndividualImpl groupInd = new IndividualImpl();
        groupInd.setURI(vcg.getURI());
        groupInd.setNamespace(this.DEFAULT_NAMESPACE + "vitroClassGroup");
        groupInd.setVClassURI(this.CLASSGROUP.getURI());
        groupInd.setName(vcg.getPublicName());
        String groupURI = null;
        OntModel unionForURIGeneration = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)ModelFactory.createUnion((Model)this.getOntModelSelector().getApplicationMetadataModel(), (Model)this.getOntModelSelector().getFullModel()));
        try (WebappDaoFactory wadfForURIGeneration = null;){
            WebappDaoFactoryConfig wadfConfig = new WebappDaoFactoryConfig();
            wadfConfig.setPreferredLanguages(this.getWebappDaoFactory().getPreferredLanguages());
            wadfForURIGeneration = new WebappDaoFactoryJena(new SimpleOntModelSelector(unionForURIGeneration), wadfConfig, null);
            groupURI = wadfForURIGeneration.getIndividualDao().insertNewIndividual(groupInd);
        }
        if (groupURI != null) {
            ontModel.enterCriticalSection(false);
            try {
                Individual groupJenaInd = ontModel.getIndividual(groupURI);
                try {
                    groupJenaInd.addProperty((Property)this.DISPLAY_RANK, Integer.toString(vcg.getDisplayRank()), (RDFDatatype)XSDDatatype.XSDint);
                }
                catch (Exception e) {
                    log.error((Object)("error setting displayRank for " + groupInd.getURI()));
                }
            }
            finally {
                ontModel.leaveCriticalSection();
            }
            return 0;
        }
        log.error((Object)("Unable to insert class group " + vcg.getPublicName()));
        return 1;
    }

    @Override
    public int removeUnpopulatedGroups(List<VClassGroup> groups) {
        if (groups == null || groups.size() == 0) {
            return 0;
        }
        int removedGroupsCount = 0;
        ListIterator<VClassGroup> it = groups.listIterator();
        while (it.hasNext()) {
            VClassGroup group = it.next();
            List<VClass> classes = group.getVitroClassList();
            if (classes != null && classes.size() >= 1) continue;
            ++removedGroupsCount;
            it.remove();
        }
        return removedGroupsCount;
    }

    @Override
    public void sortGroupList(List<VClassGroup> groupList) {
        groupList.sort(new Comparator<VClassGroup>(){

            @Override
            public int compare(VClassGroup first, VClassGroup second) {
                if (first != null) {
                    if (second != null) {
                        return first.getDisplayRank() - second.getDisplayRank();
                    }
                    log.error((Object)"error--2nd VClassGroup is null in VClassGroupDao.getGroupList().compare()");
                } else {
                    log.error((Object)"error--1st VClassGroup is null in VClassGroupDao.getGroupList().compare()");
                }
                return 0;
            }
        });
    }

    @Override
    public void updateVClassGroup(VClassGroup vcg) {
        this.updateVClassGroup(vcg, this.getOntModelSelector().getApplicationMetadataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVClassGroup(VClassGroup vcg, OntModel ontModel) {
        ontModel.enterCriticalSection(false);
        try {
            Individual groupInd = ontModel.getIndividual(vcg.getURI());
            try {
                this.updateRDFSLabel((OntResource)groupInd, vcg.getPublicName(), this.getDefaultLanguage());
            }
            catch (Exception e) {
                log.error((Object)("error updating name for " + groupInd.getURI()));
            }
            try {
                groupInd.removeAll((Property)this.DISPLAY_RANK);
                groupInd.addProperty((Property)this.DISPLAY_RANK, Integer.toString(vcg.getDisplayRank()), (RDFDatatype)XSDDatatype.XSDint);
            }
            catch (Exception e) {
                log.error((Object)("error updating display rank for " + groupInd.getURI()));
            }
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }

    @Override
    public VClassGroup getGroupByName(String vcgName) {
        if (vcgName == null) {
            return null;
        }
        return this.getClassGroupMap().get(vcgName);
    }
}

