/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.dao.jena.SDBGraphConnectionGenerator;
import edu.cornell.mannlib.vitro.webapp.dao.jena.SQLGraphGenerator;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.graph.Graph;
import org.apache.jena.sdb.SDBFactory;
import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.StoreDesc;

public class SDBGraphGenerator
implements SQLGraphGenerator {
    private static final Log log = LogFactory.getLog((String)SDBGraphGenerator.class.getName());
    private SDBGraphConnectionGenerator connGen;
    private Connection connection;
    private StoreDesc storeDesc;
    private String graphID;

    public SDBGraphGenerator(DataSource dataSource, StoreDesc storeDesc, String graphID) {
        this.connGen = new SDBGraphConnectionGenerator(dataSource);
        this.storeDesc = storeDesc;
        this.graphID = graphID;
    }

    public SDBGraphGenerator(SDBGraphConnectionGenerator connectionGenerator, StoreDesc storeDesc, String graphID) {
        this.connGen = connectionGenerator;
        this.storeDesc = storeDesc;
        this.graphID = graphID;
    }

    @Override
    public boolean isGraphClosed() {
        try {
            return this.connection == null || this.connection.isClosed();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Graph generateGraph() {
        try {
            this.connection = this.connGen.generateConnection();
            Store store = SDBFactory.connectStore((Connection)this.connection, (StoreDesc)this.storeDesc);
            return SDBFactory.connectNamedGraph((Store)store, (String)this.graphID);
        }
        catch (SQLException e) {
            String errMsg = "Unable to generate SDB graph";
            log.error((Object)errMsg, (Throwable)e);
            throw new RuntimeException(errMsg, e);
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }
}

