/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.VitroModelFactory;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEventManager;
import org.apache.jena.graph.GraphStatisticsHandler;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphWithPerform;
import org.apache.jena.graph.impl.SimpleEventManager;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.Command;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.SingletonIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class RDFServiceGraph
implements GraphWithPerform {
    private RDFService rdfService;
    private String graphURI;
    private static final Log log = LogFactory.getLog(RDFServiceGraph.class);
    private PrefixMapping prefixMapping = new PrefixMappingImpl();
    private GraphEventManager eventManager;
    private boolean inTransaction = false;
    private Graph additionsGraph = ModelFactory.createDefaultModel().getGraph();
    private Graph removalsGraph = ModelFactory.createDefaultModel().getGraph();
    private static final Capabilities capabilities = new Capabilities(){

        public boolean addAllowed() {
            return false;
        }

        public boolean addAllowed(boolean everyTriple) {
            return false;
        }

        public boolean canBeEmpty() {
            return true;
        }

        public boolean deleteAllowed() {
            return false;
        }

        public boolean deleteAllowed(boolean everyTriple) {
            return false;
        }

        public boolean findContractSafe() {
            return true;
        }

        public boolean handlesLiteralTyping() {
            return true;
        }

        public boolean iteratorRemoveAllowed() {
            return false;
        }

        public boolean sizeAccurate() {
            return true;
        }
    };
    private final TransactionHandler transactionHandler = new TransactionHandler(){

        public synchronized void abort() {
            RDFServiceGraph.this.inTransaction = false;
            RDFServiceGraph.this.removalsGraph.clear();
            RDFServiceGraph.this.additionsGraph.clear();
        }

        public synchronized void begin() {
            RDFServiceGraph.this.inTransaction = true;
        }

        public synchronized void commit() {
            RDFServiceGraph.this.flush();
            RDFServiceGraph.this.inTransaction = false;
        }

        public Object executeInTransaction(Command arg0) {
            return null;
        }

        public void execute(Runnable runnable) {
        }

        public <T> T calculate(Supplier<T> supplier) {
            return null;
        }

        public boolean transactionsSupported() {
            return true;
        }
    };

    public RDFServiceGraph(RDFService rdfService) {
        this(rdfService, null);
    }

    public RDFServiceGraph(RDFService rdfService, String graphURI) {
        this.rdfService = rdfService;
        this.graphURI = graphURI;
    }

    public RDFService getRDFService() {
        return this.rdfService;
    }

    public String getGraphURI() {
        return this.graphURI;
    }

    public void add(Triple arg0) throws AddDeniedException {
        this.performAdd(arg0);
    }

    private StringBuilder serialize(StringBuilder sb, Triple t) {
        sb.append(RDFServiceGraph.sparqlNodeUpdate(t.getSubject(), "")).append(" ").append(RDFServiceGraph.sparqlNodeUpdate(t.getPredicate(), "")).append(" ").append(RDFServiceGraph.sparqlNodeUpdate(t.getObject(), "")).append(" .");
        return sb;
    }

    private synchronized void flush() {
        ChangeSet changeSet = this.rdfService.manufactureChangeSet();
        try {
            if (!this.removalsGraph.isEmpty()) {
                String removals = this.serializeGraph(this.removalsGraph);
                changeSet.addRemoval(RDFServiceUtils.toInputStream(removals), RDFService.ModelSerializationFormat.N3, this.graphURI);
                this.removalsGraph.clear();
            }
            if (!this.additionsGraph.isEmpty()) {
                String additions = this.serializeGraph(this.additionsGraph);
                changeSet.addAddition(RDFServiceUtils.toInputStream(additions), RDFService.ModelSerializationFormat.N3, this.graphURI);
                this.additionsGraph.clear();
            }
            this.rdfService.changeSetUpdate(changeSet);
        }
        catch (RDFServiceException rdfse) {
            throw new RuntimeException(rdfse);
        }
    }

    private synchronized String serializeGraph(Graph graph) {
        StringBuilder sb = new StringBuilder();
        ExtendedIterator tripIt = graph.find(null, null, null);
        while (tripIt.hasNext()) {
            this.serialize(sb.append(" \n"), (Triple)tripIt.next());
        }
        return sb.toString();
    }

    public void performAdd(Triple t) {
        if (this.inTransaction) {
            this.stageAddition(t);
        } else {
            ChangeSet changeSet = this.rdfService.manufactureChangeSet();
            try {
                changeSet.addAddition(RDFServiceUtils.toInputStream(this.serialize(new StringBuilder(), t).toString()), RDFService.ModelSerializationFormat.N3, this.graphURI);
                this.rdfService.changeSetUpdate(changeSet);
            }
            catch (RDFServiceException rdfse) {
                throw new RuntimeException(rdfse);
            }
        }
    }

    private void stageAddition(Triple t) {
        if (this.removalsGraph.contains(t)) {
            this.removalsGraph.remove(t.getSubject(), t.getPredicate(), t.getObject());
        } else {
            this.additionsGraph.add(t);
        }
    }

    public void performDelete(Triple t) {
        if (this.inTransaction) {
            this.stageDeletion(t);
        } else {
            ChangeSet changeSet = this.rdfService.manufactureChangeSet();
            try {
                changeSet.addRemoval(RDFServiceUtils.toInputStream(this.serialize(new StringBuilder(), t).toString()), RDFService.ModelSerializationFormat.N3, this.graphURI);
                this.rdfService.changeSetUpdate(changeSet);
            }
            catch (RDFServiceException rdfse) {
                throw new RuntimeException(rdfse);
            }
        }
    }

    private synchronized void stageDeletion(Triple t) {
        if (this.additionsGraph.contains(t)) {
            this.additionsGraph.remove(t.getSubject(), t.getPredicate(), t.getObject());
        } else {
            this.removalsGraph.add(t);
        }
    }

    public void removeAll() {
        if (this.graphURI == null) {
            return;
        }
        String constructStr = "CONSTRUCT { ?s ?p ?o } WHERE { GRAPH <" + this.graphURI + "> { ?s ?p ?o } }";
        try {
            if (this.inTransaction) {
                Model model = ModelFactory.createDefaultModel();
                this.rdfService.sparqlConstructQuery(constructStr, model);
                this.stageRemoveAll(model);
            } else {
                InputStream model = this.rdfService.sparqlConstructQuery(constructStr, RDFService.ModelSerializationFormat.N3);
                ChangeSet changeSet = this.rdfService.manufactureChangeSet();
                changeSet.addRemoval(model, RDFService.ModelSerializationFormat.N3, this.graphURI);
                this.rdfService.changeSetUpdate(changeSet);
            }
        }
        catch (RDFServiceException rdfse) {
            throw new RuntimeException(rdfse);
        }
    }

    private void stageRemoveAll(Model removals) {
        StmtIterator sit = removals.listStatements();
        while (sit.hasNext()) {
            Triple t = sit.nextStatement().asTriple();
            this.stageDeletion(t);
        }
    }

    public void close() {
    }

    public boolean contains(Triple arg0) {
        return this.contains(arg0.getSubject(), arg0.getPredicate(), arg0.getObject());
    }

    public boolean contains(Node subject, Node predicate, Node object) {
        if (subject != null && subject.isBlank() || predicate != null && predicate.isBlank() || object != null && object.isBlank()) {
            return false;
        }
        StringBuilder containsQuery = new StringBuilder("SELECT * WHERE { \n");
        if (this.graphURI != null) {
            containsQuery.append("  GRAPH <").append(this.graphURI).append("> { ");
        }
        containsQuery.append(RDFServiceGraph.sparqlNode(subject, "?s")).append(" ").append(RDFServiceGraph.sparqlNode(predicate, "?p")).append(" ").append(RDFServiceGraph.sparqlNode(object, "?o"));
        if (this.graphURI != null) {
            containsQuery.append(" } \n");
        }
        containsQuery.append("} \nLIMIT 1 ");
        ResultSetConsumer.HasResult consumer = new ResultSetConsumer.HasResult();
        this.execSelect(containsQuery.toString(), consumer);
        boolean initialResult = consumer.hasResult();
        if (!this.inTransaction) {
            return initialResult;
        }
        Triple t = Triple.create((Node)subject, (Node)predicate, (Node)object);
        return (initialResult || this.additionsGraphContains(t)) && !this.removalsGraphContains(t);
    }

    private synchronized boolean additionsGraphContains(Triple t) {
        return this.additionsGraph.contains(t);
    }

    private synchronized boolean removalsGraphContains(Triple t) {
        return this.removalsGraph.contains(t);
    }

    public void delete(Triple arg0) throws DeleteDeniedException {
        this.performDelete(arg0);
    }

    public ExtendedIterator<Triple> find(Triple triple) {
        return this.find(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public void remove(Node subject, Node predicate, Node object) {
        for (Triple t : this.find(subject, predicate, object).toList()) {
            this.delete(t);
        }
    }

    public boolean dependsOn(Graph arg0) {
        return false;
    }

    public static String sparqlNode(Node node, String varName) {
        if (node == null || node.isVariable()) {
            return varName;
        }
        if (node.isBlank()) {
            return "<fake:blank>";
        }
        if (node.isURI()) {
            StringBuilder uriBuff = new StringBuilder();
            return uriBuff.append("<").append(node.getURI()).append(">").toString();
        }
        if (node.isLiteral()) {
            StringBuffer literalBuff = new StringBuffer();
            literalBuff.append("\"");
            RDFServiceGraph.pyString(literalBuff, node.getLiteralLexicalForm());
            literalBuff.append("\"");
            if (!StringUtils.isEmpty((CharSequence)node.getLiteralLanguage())) {
                literalBuff.append("@").append(node.getLiteralLanguage());
            } else if (node.getLiteralDatatypeURI() != null) {
                literalBuff.append("^^<").append(node.getLiteralDatatypeURI()).append(">");
            }
            return literalBuff.toString();
        }
        return varName;
    }

    public static String sparqlNodeUpdate(Node node, String varName) {
        if (node.isBlank()) {
            return "_:" + node.getBlankNodeLabel().replaceAll("\\W", "");
        }
        return RDFServiceGraph.sparqlNode(node, varName);
    }

    public static String sparqlNodeDelete(Node node, String varName) {
        if (node.isBlank()) {
            return "?" + node.getBlankNodeLabel().replaceAll("\\W", "");
        }
        return RDFServiceGraph.sparqlNode(node, varName);
    }

    public ExtendedIterator<Triple> find(final Node subject, final Node predicate, final Node object) {
        if (!(this.isVar(subject) || this.isVar(predicate) || this.isVar(object))) {
            if (this.contains(subject, predicate, object)) {
                return new SingletonIterator((Object)new Triple(subject, predicate, object));
            }
            return WrappedIterator.create(Collections.emptyIterator());
        }
        StringBuilder findQuery = new StringBuilder("SELECT * WHERE { \n");
        if (this.graphURI != null) {
            findQuery.append("  GRAPH <").append(this.graphURI).append("> { ");
        }
        findQuery.append(RDFServiceGraph.sparqlNode(subject, "?s")).append(" ").append(RDFServiceGraph.sparqlNode(predicate, "?p")).append(" ").append(RDFServiceGraph.sparqlNode(object, "?o"));
        if (this.graphURI != null) {
            findQuery.append("  } ");
        }
        findQuery.append("\n}");
        String queryString = findQuery.toString();
        final ArrayList<Triple> triplist = new ArrayList<Triple>();
        if (this.inTransaction) {
            this.addAdditions(triplist, (ExtendedIterator<Triple>)this.additionsGraph.find(subject, predicate, object));
            this.subtractRemovals(triplist, (ExtendedIterator<Triple>)this.removalsGraph.find(subject, predicate, object));
        }
        this.execSelect(queryString, new ResultSetConsumer(){

            @Override
            protected void processQuerySolution(QuerySolution qs) {
                Triple t = new Triple(RDFServiceGraph.this.isVar(subject) ? qs.get("?s").asNode() : subject, RDFServiceGraph.this.isVar(predicate) ? qs.get("?p").asNode() : predicate, RDFServiceGraph.this.isVar(object) ? qs.get("?o").asNode() : object);
                triplist.add(t);
            }
        });
        return WrappedIterator.create(triplist.iterator());
    }

    private void addAdditions(List<Triple> tripList, ExtendedIterator<Triple> tripIt) {
        while (tripIt.hasNext()) {
            Triple t = (Triple)tripIt.next();
            if (tripList.contains(t)) continue;
            tripList.add(t);
        }
    }

    private void subtractRemovals(List<Triple> tripList, ExtendedIterator<Triple> tripIt) {
        while (tripIt.hasNext()) {
            Triple t = (Triple)tripIt.next();
            if (!tripList.contains(t)) continue;
            tripList.remove(t);
        }
    }

    private boolean isVar(Node node) {
        return node == null || node.isVariable() || node == Node.ANY;
    }

    public Capabilities getCapabilities() {
        return capabilities;
    }

    public GraphEventManager getEventManager() {
        if (this.eventManager == null) {
            this.eventManager = new SimpleEventManager(){

                public void notifyEvent(Graph g, Object event) {
                    ChangeSet changeSet = RDFServiceGraph.this.rdfService.manufactureChangeSet();
                    changeSet.addPreChangeEvent(event);
                    try {
                        RDFServiceGraph.this.rdfService.changeSetUpdate(changeSet);
                    }
                    catch (RDFServiceException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        return this.eventManager;
    }

    public PrefixMapping getPrefixMapping() {
        return this.prefixMapping;
    }

    public GraphStatisticsHandler getStatisticsHandler() {
        return null;
    }

    public TransactionHandler getTransactionHandler() {
        return this.transactionHandler;
    }

    public boolean isClosed() {
        return false;
    }

    public boolean isEmpty() {
        return !this.contains(null, null, null);
    }

    public boolean isIsomorphicWith(Graph arg0) {
        throw new UnsupportedOperationException("isIsomorphicWith() not supported by SPARQL graphs");
    }

    public int size() {
        int size = this.find(null, null, null).toList().size();
        return size;
    }

    public void clear() {
        this.removeAll();
    }

    private void execSelect(String queryStr, ResultSetConsumer consumer) {
        try {
            this.rdfService.sparqlSelectQuery(queryStr, consumer);
        }
        catch (RDFServiceException rdfse) {
            throw new RuntimeException(rdfse);
        }
    }

    protected static void pyString(StringBuffer sbuff, String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\"') {
                sbuff.append('\\');
                sbuff.append(c);
                continue;
            }
            if (c == '\n') {
                sbuff.append("\\n");
                continue;
            }
            if (c == '\t') {
                sbuff.append("\\t");
                continue;
            }
            if (c == '\r') {
                sbuff.append("\\r");
                continue;
            }
            if (c == '\f') {
                sbuff.append("\\f");
                continue;
            }
            if (c == '\b') {
                sbuff.append("\\b");
                continue;
            }
            if (c == '\u0007') {
                sbuff.append("\\a");
                continue;
            }
            sbuff.append(c);
        }
    }

    public static Model createRDFServiceModel(RDFServiceGraph g) {
        return VitroModelFactory.createModelForGraph((Graph)g);
    }

    public String toString() {
        return "RDFServiceGraph[" + ToString.hashHex(this) + ", " + this.rdfService + ", graphURI=" + ToString.modelName(this.graphURI) + "]";
    }
}

