/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DependentResourceDeleteJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaBaseDaoCon;
import edu.cornell.mannlib.vitro.webapp.dao.jena.OntModelSelector;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.Violation;
import org.apache.jena.ontology.DatatypeProperty;
import org.apache.jena.ontology.ObjectProperty;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class JenaBaseDao
extends JenaBaseDaoCon {
    public static final boolean KEEP_ONLY_IF_TRUE = true;
    public static final boolean KEEP_ONLY_IF_FALSE = false;
    private static final String SWRL_IMP = "http://www.w3.org/2003/11/swrl#Imp";
    protected static final Log log = LogFactory.getLog((String)JenaBaseDao.class.getName());
    protected String PSEUDO_BNODE_NS = "http://vitro.mannlib.cornell.edu/ns/bnode#";
    protected String XSD = "http://www.w3.org/2001/XMLSchema#";
    protected DateFormat xsdDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected DateFormat xsdDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private OntModelSelector ontModelSelector;
    private List<OntModel> writableOntModelList;
    private WebappDaoFactoryJena webappDaoFactory;
    protected String DEFAULT_NAMESPACE;
    protected Set<String> NONUSER_NAMESPACES;
    protected List<String> PREFERRED_LANGUAGES;
    private final boolean ALSO_TRY_NO_LANG = true;

    public JenaBaseDao(WebappDaoFactoryJena wadf) {
        this.ontModelSelector = wadf.getOntModelSelector();
        this.DEFAULT_NAMESPACE = wadf.getDefaultNamespace();
        this.NONUSER_NAMESPACES = wadf.getNonuserNamespaces();
        this.PREFERRED_LANGUAGES = wadf.getPreferredLanguages();
        this.webappDaoFactory = wadf;
    }

    protected OntModel getOntModel() {
        return this.ontModelSelector.getFullModel();
    }

    protected OntModelSelector getOntModelSelector() {
        return this.ontModelSelector;
    }

    protected List<OntModel> getWritableOntModelList() {
        return this.writableOntModelList;
    }

    protected WebappDaoFactoryJena getWebappDaoFactory() {
        return this.webappDaoFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getPropertyStringValue(OntResource res, Property dataprop) {
        if (dataprop == null) return null;
        try (StmtIterator stateIt = res.getModel().listStatements((Resource)res, dataprop, (RDFNode)((Literal)null));){
            if (stateIt.hasNext()) {
                String string = ((Literal)((Statement)stateIt.next()).getObject()).getString();
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void addPropertyStringValue(Resource res, Property dataprop, String value, Model model) {
        if (res != null && dataprop != null && value != null && value.length() > 0) {
            model.add(res, dataprop, value, (RDFDatatype)XSDDatatype.XSDstring);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Boolean getPropertyBooleanValue(OntResource res, Property dataprop) {
        if (dataprop == null) return null;
        try (StmtIterator stateIt = this.getOntModel().listStatements((Resource)res, dataprop, (RDFNode)((Literal)null));){
            if (stateIt.hasNext()) {
                Boolean bl = ((Literal)((Statement)stateIt.next()).getObject()).getBoolean();
                return bl;
            }
            Boolean bl = null;
            return bl;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void addPropertyBooleanValue(Resource res, Property prop, Boolean value, Model model) {
        if (res != null && prop != null && value != null) {
            model.add(res, prop, (RDFNode)model.createTypedLiteral((Object)value));
        }
    }

    protected void updatePropertyStringValue(Resource res, Property dataprop, String value, Model model) {
        if (dataprop != null) {
            RDFNode object;
            String existingValue = null;
            Statement stmt = res.getProperty(dataprop);
            if (stmt != null && (object = stmt.getObject()) != null && object.isLiteral()) {
                existingValue = ((Literal)object).getString();
            }
            if (value == null || value.length() == 0) {
                model.removeAll(res, dataprop, null);
            } else if (existingValue == null) {
                model.add(res, dataprop, value, (RDFDatatype)XSDDatatype.XSDstring);
            } else if (!existingValue.equals(value)) {
                model.removeAll(res, dataprop, null);
                model.add(res, dataprop, value, (RDFDatatype)XSDDatatype.XSDstring);
            }
        }
    }

    protected void updatePropertyBooleanValue(Resource res, Property dataprop, Boolean value, Model model, boolean keepOnlyIfTrue) {
        if (dataprop != null) {
            RDFNode object;
            Boolean existingValue = null;
            Statement stmt = res.getProperty(dataprop);
            if (stmt != null && (object = stmt.getObject()) != null && object.isLiteral()) {
                existingValue = ((Literal)object).getBoolean();
            }
            if (existingValue != null && value == null || existingValue != null && value != null && !existingValue.equals(value) || existingValue != null && !existingValue.booleanValue() && keepOnlyIfTrue) {
                model.removeAll(res, dataprop, null);
            }
            if (existingValue == null && value != null || existingValue != null && value != null && !existingValue.equals(value)) {
                if (keepOnlyIfTrue) {
                    if (value.booleanValue()) {
                        model.add(res, dataprop, (RDFNode)model.createTypedLiteral((Object)value));
                    }
                } else {
                    model.add(res, dataprop, (RDFNode)model.createTypedLiteral((Object)value));
                }
            }
        }
    }

    protected int getPropertyNonNegativeIntValue(OntResource res, Property dataprop) {
        if (dataprop != null) {
            try {
                return ((Literal)res.getPropertyValue(dataprop)).getInt();
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    protected Integer getPropertyNonNegativeIntegerValue(OntResource res, Property dataprop) {
        if (dataprop != null) {
            try {
                return ((Literal)res.getPropertyValue(dataprop)).getInt();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    protected void addPropertyIntValue(Resource res, Property dataprop, int value, Model model) {
        if (dataprop != null) {
            model.add(res, dataprop, Integer.toString(value), (RDFDatatype)XSDDatatype.XSDint);
        }
    }

    protected void addPropertyLongValue(Resource res, Property dataprop, long value, Model model) {
        if (dataprop != null) {
            model.add(res, dataprop, Long.toString(value), (RDFDatatype)XSDDatatype.XSDlong);
        }
    }

    protected void updatePropertyIntValue(Resource res, Property dataprop, int value, Model model) {
        if (dataprop != null) {
            RDFNode object;
            Integer existingValue = null;
            Statement stmt = res.getProperty(dataprop);
            if (stmt != null && (object = stmt.getObject()) != null && object.isLiteral()) {
                existingValue = ((Literal)object).getInt();
            }
            if (existingValue == null) {
                model.add(res, dataprop, Integer.toString(value), (RDFDatatype)XSDDatatype.XSDint);
            } else if (existingValue != value) {
                model.removeAll(res, dataprop, null);
                model.add(res, dataprop, Integer.toString(value), (RDFDatatype)XSDDatatype.XSDint);
            }
        }
    }

    protected int getPropertyIntValue(OntResource res, Property dataprop) {
        if (dataprop != null) {
            try {
                return ((Literal)res.getPropertyValue(dataprop)).getInt();
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    protected void addPropertyNonNegativeIntValue(Resource res, Property dataprop, int value, Model model) {
        if (dataprop != null && value > -1) {
            model.add(res, dataprop, Integer.toString(value), (RDFDatatype)XSDDatatype.XSDint);
        }
    }

    protected void updatePropertyNonNegativeIntValue(Resource res, Property dataprop, int value, Model model) {
        if (value < 0) {
            if (model != null && res != null && dataprop != null) {
                model.removeAll(res, dataprop, (RDFNode)null);
            }
        } else {
            this.updatePropertyIntValue(res, dataprop, value, model);
        }
    }

    protected void updatePropertyNonNegativeIntegerValue(Resource res, Property dataprop, Integer value, Model model) {
        if (value != null) {
            this.updatePropertyIntValue(res, dataprop, value, model);
        } else {
            model.removeAll(res, dataprop, (RDFNode)null);
        }
    }

    protected void updatePropertyLongValue(Resource res, Property dataprop, Long value, Model model) {
        if (dataprop != null) {
            RDFNode object;
            Long existingValue = null;
            Statement stmt = res.getProperty(dataprop);
            if (stmt != null && (object = stmt.getObject()) != null && object.isLiteral()) {
                existingValue = ((Literal)object).getLong();
            }
            if (existingValue == null) {
                model.add(res, dataprop, value.toString(), (RDFDatatype)XSDDatatype.XSDlong);
            } else if (existingValue.longValue() != value.longValue()) {
                model.removeAll(res, dataprop, null);
                model.add(res, dataprop, value.toString(), (RDFDatatype)XSDDatatype.XSDlong);
            }
        }
    }

    protected long getPropertyLongValue(OntResource res, Property dataprop) {
        if (dataprop != null) {
            try {
                return ((Literal)res.getPropertyValue(dataprop)).getLong();
            }
            catch (Exception e) {
                return -1L;
            }
        }
        return -1L;
    }

    protected void addPropertyFloatValue(Resource res, Property dataprop, Float value, Model model) {
        if (dataprop != null && value != null) {
            model.add(res, dataprop, Float.toString(value.floatValue()), (RDFDatatype)XSDDatatype.XSDfloat);
        }
    }

    protected void updatePropertyFloatValue(Resource res, Property dataprop, Float value, Model model) {
        if (dataprop != null) {
            RDFNode object;
            Float existingValue = null;
            Statement stmt = res.getProperty(dataprop);
            if (stmt != null && (object = stmt.getObject()) != null && object.isLiteral()) {
                existingValue = Float.valueOf(((Literal)object).getFloat());
            }
            if (value == null) {
                model.removeAll(res, dataprop, null);
            } else if (existingValue == null) {
                model.add(res, dataprop, Float.toString(value.floatValue()), (RDFDatatype)XSDDatatype.XSDfloat);
            } else if (existingValue.compareTo(value) != 0) {
                model.removeAll(res, dataprop, null);
                model.add(res, dataprop, Float.toString(value.floatValue()), (RDFDatatype)XSDDatatype.XSDfloat);
            }
        }
    }

    protected Float getPropertyFloatValue(OntResource res, Property prop) {
        if (prop != null) {
            try {
                return new Float(((Literal)res.getPropertyValue(prop)).getFloat());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    protected synchronized Date getPropertyDateValue(OntResource res, DatatypeProperty dataprop) {
        if (dataprop != null) {
            try {
                return this.xsdDateFormat.parse(((Literal)res.getPropertyValue((Property)dataprop)).getString());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    protected synchronized void addPropertyDateValue(Resource res, DatatypeProperty dataprop, Date value, Model model) {
        if (dataprop != null && value != null) {
            model.add(res, (Property)dataprop, this.xsdDateFormat.format(value), (RDFDatatype)XSDDatatype.XSDdate);
        }
    }

    protected synchronized void updatePropertyDateValue(Resource res, DatatypeProperty dataprop, Date value, Model model) {
        try {
            if (dataprop != null) {
                if (value == null) {
                    model.removeAll(res, (Property)dataprop, null);
                } else {
                    RDFNode object;
                    Date existingValue = null;
                    Statement stmt = res.getProperty((Property)dataprop);
                    if (stmt != null && (object = stmt.getObject()) != null && object.isLiteral()) {
                        existingValue = (Date)((Literal)object).getValue();
                    }
                    if (existingValue == null) {
                        model.add(res, (Property)dataprop, this.xsdDateFormat.format(value), (RDFDatatype)XSDDatatype.XSDdate);
                    } else if (existingValue != value) {
                        model.removeAll(res, (Property)dataprop, null);
                        model.add(res, (Property)dataprop, this.xsdDateFormat.format(value), (RDFDatatype)XSDDatatype.XSDdate);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in updatePropertyDateValue", (Throwable)e);
        }
    }

    protected synchronized Date getPropertyDateTimeValue(OntResource res, Property dataprop) {
        if (dataprop != null) {
            try {
                return this.xsdDateTimeFormat.parse(((Literal)res.getPropertyValue(dataprop)).getString());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    protected synchronized void addPropertyDateTimeValue(Resource res, Property dataprop, Date value, Model model) {
        if (dataprop != null && value != null) {
            model.add(res, dataprop, this.xsdDateTimeFormat.format(value), (RDFDatatype)XSDDatatype.XSDdateTime);
        }
    }

    protected synchronized void updatePropertyDateTimeValue(Resource res, Property dataprop, Date value, Model model) {
        try {
            if (dataprop != null) {
                String formattedDateStr;
                RDFNode object;
                String existingValue = null;
                Statement stmt = res.getProperty(dataprop);
                if (stmt != null && (object = stmt.getObject()) != null && object.isLiteral()) {
                    existingValue = ((Literal)object).getString();
                }
                String string = formattedDateStr = value == null ? null : this.xsdDateTimeFormat.format(value);
                if (existingValue != null && value == null || existingValue != null && value != null && !existingValue.equals(formattedDateStr)) {
                    model.removeAll(res, dataprop, null);
                }
                if (existingValue == null && value != null || existingValue != null && value != null && !existingValue.equals(formattedDateStr)) {
                    model.add(res, dataprop, formattedDateStr, (RDFDatatype)XSDDatatype.XSDdateTime);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in updatePropertyDateTimeValue", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<String> getPropertyResourceURIValues(Resource res, ObjectProperty prop) {
        ArrayList<String> list = new ArrayList<String>();
        if (prop != null) {
            try (StmtIterator stateIt = res.getModel().listStatements(res, (Property)prop, (RDFNode)((Literal)null));){
                while (stateIt.hasNext()) {
                    list.add(((Statement)stateIt.next()).getObject().asResource().getURI());
                }
            }
            catch (Exception e) {
                log.debug((Object)"can't get object property URI values: ", (Throwable)e);
            }
        }
        return list;
    }

    protected BaseResourceBean.RoleLevel getMostRestrictiveRoleLevel(Resource res, Property prop) {
        BaseResourceBean.RoleLevel level = BaseResourceBean.RoleLevel.getRoleByUri(null);
        for (Statement stmt : res.listProperties(prop).toList()) {
            BaseResourceBean.RoleLevel roleFromModel;
            if (!stmt.getObject().isURIResource() || (roleFromModel = BaseResourceBean.RoleLevel.getRoleByUri(((Resource)stmt.getObject().as(Resource.class)).getURI())).compareTo(level) <= 0) continue;
            level = roleFromModel;
        }
        return level;
    }

    protected void addPropertyResourceURIValue(Resource res, ObjectProperty prop, String objectURI) {
        Resource objectRes = this.getOntModel().getResource(objectURI);
        if (prop != null && objectRes != null) {
            res.addProperty((Property)prop, (RDFNode)objectRes);
        }
    }

    protected void updatePropertyResourceURIValue(Resource res, Property prop, String objectURI) {
        Model model = res.getModel();
        if (model != null) {
            this.updatePropertyResourceURIValue(res, prop, objectURI, model);
        }
    }

    protected void updatePropertyResourceURIValue(Resource res, Property prop, String uri, Model model) {
        log.debug((Object)("updatePropertyResourceURIValue(), resource=" + (res == null ? "null" : res.getURI()) + ", property=" + (prop == null ? "null" : prop.getURI()) + ", uri=" + uri));
        if (prop != null) {
            if (uri == null || uri.length() == 0) {
                model.removeAll(res, prop, null);
            } else {
                RDFNode object;
                String badURIErrorStr = this.checkURI(uri);
                if (badURIErrorStr != null) {
                    log.error((Object)badURIErrorStr);
                    return;
                }
                Resource existingValue = null;
                Statement stmt = res.getProperty(prop);
                if (stmt != null && (object = stmt.getObject()) != null && object.isResource()) {
                    existingValue = (Resource)object;
                }
                if (existingValue == null) {
                    model.add(res, prop, (RDFNode)model.createResource(uri));
                } else if (!this.isEqual(uri, existingValue)) {
                    model.removeAll(res, prop, null);
                    model.add(res, prop, (RDFNode)model.createResource(uri));
                }
            }
        }
    }

    private boolean isEqual(String uri, Resource existingValue) {
        if (existingValue.asNode().isBlank()) {
            String blankNodeId = existingValue.asNode().getBlankNodeId().toString();
            return uri.endsWith(blankNodeId);
        }
        return existingValue.getURI().equals(uri);
    }

    protected void addPropertyResourceValue(Resource res, Property prop, Resource objectRes) {
        if (prop != null && objectRes != null) {
            res.addProperty(prop, (RDFNode)objectRes);
        }
    }

    protected void updatePropertyResourceValue(Resource res, Property prop, Resource objectRes) {
        Model model = res.getModel();
        if (model != null) {
            this.updatePropertyResourceValue(res, prop, objectRes, model);
        }
    }

    protected void updatePropertyResourceValue(Resource res, Property prop, Resource objectRes, Model model) {
        if (prop != null) {
            if (objectRes == null) {
                model.removeAll(res, prop, null);
            } else {
                RDFNode object;
                Resource existingValue = null;
                Statement stmt = res.getProperty(prop);
                if (stmt != null && (object = stmt.getObject()) != null && object.isResource()) {
                    existingValue = (Resource)object;
                }
                if (existingValue == null) {
                    model.add(res, prop, (RDFNode)objectRes);
                } else if (!existingValue.equals((Object)objectRes)) {
                    model.removeAll(res, prop, null);
                    model.add(res, prop, (RDFNode)objectRes);
                }
            }
        }
    }

    protected void updatePropertyResourceURIValues(Resource res, Property prop, Collection<String> uris, Model model) {
        log.debug((Object)("updatePropertyResourceURIValues(), resource=" + (res == null ? "null" : res.getURI()) + ", property=" + (prop == null ? "null" : prop.getURI()) + ", uris=" + uris));
        if (res == null || prop == null) {
            return;
        }
        HashSet<String> existingUris = new HashSet<String>();
        StmtIterator stmts = model.listStatements(res, prop, (RDFNode)null);
        while (stmts.hasNext()) {
            Statement stmt = (Statement)stmts.next();
            RDFNode o = stmt.getObject();
            if (!(o instanceof Resource)) continue;
            existingUris.add(((Resource)o).getURI());
        }
        HashSet<String> addingUris = new HashSet<String>(uris);
        addingUris.removeAll(existingUris);
        HashSet removingUris = new HashSet(existingUris);
        removingUris.removeAll(uris);
        for (String removeUri : removingUris) {
            Resource o = model.getResource(removeUri);
            model.remove(res, prop, (RDFNode)o);
        }
        for (String addUri : addingUris) {
            if (addUri == null || addUri.isEmpty()) continue;
            String badUriErrorStr = this.checkURI(addUri);
            if (badUriErrorStr == null) {
                Resource o = model.getResource(addUri);
                model.add(res, prop, (RDFNode)o);
                continue;
            }
            log.warn((Object)badUriErrorStr);
        }
    }

    protected void updateRDFSLabel(OntResource ontRes, String lexicalForm) {
        this.updatePlainLiteralValue(ontRes, RDFS.label, lexicalForm);
    }

    protected void updateRDFSLabel(OntResource ontRes, String lexicalForm, String lang) {
        this.updatePlainLiteralValue(ontRes, RDFS.label, lexicalForm, lang);
    }

    protected void updatePlainLiteralValue(OntResource ontRes, Property property, String lexicalForm) {
        this.updatePlainLiteralValue(ontRes, property, lexicalForm, this.getDefaultLanguage());
    }

    protected void updatePlainLiteralValue(OntResource ontRes, Property property, String lexicalForm, String lang) {
        if (ontRes == null) {
            throw new IllegalArgumentException("ontRes may not be null.");
        }
        boolean addNew = true;
        ArrayList<Statement> toRemove = new ArrayList<Statement>();
        StmtIterator existingStmts = ontRes.listProperties(property);
        while (existingStmts.hasNext()) {
            Statement stmt = (Statement)existingStmts.next();
            if (!stmt.getObject().isLiteral()) continue;
            Literal lit = stmt.getObject().asLiteral();
            if ((lang != null || !this.isLanguageLessPlainLiteral(lit)) && (lang == null || !lang.equals(lit.getLanguage()))) continue;
            if (!lit.getLexicalForm().equals(lexicalForm)) {
                toRemove.add(stmt);
                continue;
            }
            addNew = false;
        }
        if (!toRemove.isEmpty()) {
            ontRes.getModel().remove(toRemove);
        }
        if (addNew && lexicalForm != null) {
            if (!StringUtils.isEmpty((CharSequence)lang)) {
                ontRes.addProperty(property, (RDFNode)ResourceFactory.createLangLiteral((String)lexicalForm, (String)lang));
            } else {
                ontRes.addProperty(property, (RDFNode)ResourceFactory.createPlainLiteral((String)lexicalForm));
            }
        }
    }

    private boolean isLanguageLessPlainLiteral(Literal lit) {
        return StringUtils.isEmpty((CharSequence)lit.getLanguage()) && (lit.getDatatype() == null || XSDDatatype.XSDstring.equals(lit.getDatatype()) || (RDF.getURI() + "PlainLiteral").equals(lit.getDatatypeURI()));
    }

    private Literal getLabel(String lang, List<RDFNode> labelList) {
        for (RDFNode label : labelList) {
            if (!label.isLiteral()) continue;
            Literal labelLit = (Literal)label;
            String labelLanguage = labelLit.getLanguage();
            if (labelLanguage == null && (lang == null || lang.isEmpty())) {
                return labelLit;
            }
            if (lang != null && lang.equals(labelLanguage)) {
                return labelLit;
            }
            if (lang == null || !Arrays.asList(lang.split("-")).get(0).equals(labelLanguage)) continue;
            return labelLit;
        }
        return null;
    }

    protected String getLabelOrId(OntResource r) {
        String label = null;
        r.getOntModel().enterCriticalSection(true);
        try {
            label = this.getLabel(r);
            if (label == null || label.length() == 0) {
                label = this.getLocalNameOrId(r);
            }
        }
        finally {
            r.getOntModel().leaveCriticalSection();
        }
        return label;
    }

    protected String getLabel(OntResource r) {
        String label = null;
        Literal labelLiteral = this.getLabelLiteral(r);
        if (labelLiteral != null) {
            label = labelLiteral.getLexicalForm();
        }
        return label;
    }

    protected Literal getLabelLiteral(String individualUri) {
        OntResource resource = this.webappDaoFactory.getOntModel().createOntResource(individualUri);
        return this.getLabelLiteral(resource);
    }

    protected Literal getLabelLiteral(OntResource r) {
        Literal labelLiteral = null;
        r.getOntModel().enterCriticalSection(true);
        try {
            labelLiteral = this.tryPropertyForPreferredLanguages(r, RDFS.label, true);
        }
        finally {
            r.getOntModel().leaveCriticalSection();
        }
        return labelLiteral;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLocalNameOrId(OntResource r) {
        String label = null;
        r.getOntModel().enterCriticalSection(true);
        try {
            String localName = r.getLocalName();
            label = localName != null ? (localName.trim().length() > 0 ? localName : r.getURI()) : (r.isAnon() ? r.getId().toString() : r.getURI());
        }
        finally {
            r.getOntModel().leaveCriticalSection();
        }
        return label;
    }

    protected Literal tryLiteralForPreferredLanguages(List<Literal> labels) {
        for (Literal literal : labels) {
            for (String lang : this.PREFERRED_LANGUAGES) {
                if (!lang.equals(literal.getLanguage())) continue;
                return literal;
            }
        }
        return 0 == labels.size() ? null : labels.get(0);
    }

    private Literal tryPropertyForPreferredLanguages(OntResource r, Property p, boolean alsoTryNoLang) {
        String lang;
        Literal label = null;
        List labels = r.listPropertyValues(p).toList();
        if (labels.size() == 0) {
            return null;
        }
        labels.sort(new Comparator<RDFNode>(){

            @Override
            public int compare(RDFNode left, RDFNode right) {
                if (left == null) {
                    return right == null ? 0 : -1;
                }
                if (left.isLiteral() && right.isLiteral()) {
                    return ((Literal)left).getLexicalForm().compareTo(((Literal)right).getLexicalForm());
                }
                return 0;
            }
        });
        Iterator<String> iterator = this.PREFERRED_LANGUAGES.iterator();
        while (iterator.hasNext() && (label = this.getLabel(lang = iterator.next(), labels)) == null) {
        }
        if (label == null && alsoTryNoLang && (label = this.getLabel("", labels)) == null) {
            for (RDFNode labelNode : labels) {
                if (!(labelNode instanceof Literal)) continue;
                label = (Literal)labelNode;
                break;
            }
        }
        return label;
    }

    protected String getDefaultLanguage() {
        return this.PREFERRED_LANGUAGES.get(0);
    }

    protected String checkURI(String uri) {
        IRIFactory factory = IRIFactory.jenaImplementation();
        IRI iri = factory.create(uri);
        if (iri.hasViolation(false)) {
            String errorStr = "Bad URI: " + uri + "\nOnly well-formed absolute URIrefs can be included in RDF/XML output: " + ((Violation)iri.violations(false).next()).getShortMessage();
            return errorStr;
        }
        return null;
    }

    public synchronized boolean isBooleanClassExpression(OntClass cls) {
        return cls.isComplementClass() || cls.isIntersectionClass() || cls.isUnionClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OntClass getOntClass(OntModel ontModel, String vitroURIStr) {
        ontModel.enterCriticalSection(true);
        try {
            OntClass cls = null;
            if (vitroURIStr == null) {
                OntClass ontClass = null;
                return ontClass;
            }
            if (vitroURIStr.indexOf(this.PSEUDO_BNODE_NS) == 0) {
                String idStr = vitroURIStr.split("#")[1];
                log.debug((Object)("Trying to get bnode " + idStr));
                RDFNode rdfNode = ontModel.getRDFNode(NodeFactory.createBlankNode((String)idStr));
                if (rdfNode != null && rdfNode.canAs(OntClass.class)) {
                    log.debug((Object)"found it");
                    cls = (OntClass)rdfNode.as(OntClass.class);
                }
            } else {
                try {
                    cls = ontModel.getOntClass(vitroURIStr);
                }
                catch (Exception e) {
                    cls = null;
                }
            }
            OntClass ontClass = cls;
            return ontClass;
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }

    protected String getClassURIStr(Resource cls) {
        if (cls.isAnon()) {
            return this.PSEUDO_BNODE_NS + cls.getId().toString();
        }
        return cls.getURI();
    }

    protected Node makeNodeForURI(String vitroURIStr) {
        if (vitroURIStr.indexOf(this.PSEUDO_BNODE_NS) == 0) {
            return NodeFactory.createBlankNode((String)vitroURIStr.split("#")[1]);
        }
        return NodeFactory.createURI((String)vitroURIStr);
    }

    protected List<Resource> listDirectObjectPropertyValues(Resource subj, Property prop) {
        HashSet<Resource> possibleValueSet = new HashSet<Resource>();
        ArrayList<Resource> directValueList = new ArrayList<Resource>();
        StmtIterator stmtIt = this.getOntModel().listStatements(subj, prop, (RDFNode)null);
        while (stmtIt.hasNext()) {
            Statement stmt = stmtIt.nextStatement();
            if (!stmt.getObject().isResource()) continue;
            possibleValueSet.add((Resource)stmt.getObject());
        }
        for (Resource possibleRes : possibleValueSet) {
            StmtIterator pStmtIt = this.getOntModel().listStatements((Resource)null, prop, (RDFNode)possibleRes);
            boolean hasAlternatePath = false;
            while (stmtIt.hasNext()) {
                Statement stmt = stmtIt.nextStatement();
                if (!possibleValueSet.contains(stmt.getSubject())) continue;
                hasAlternatePath = true;
                break;
            }
            if (hasAlternatePath) continue;
            directValueList.add(possibleRes);
        }
        return directValueList;
    }

    protected List<Resource> listDirectObjectPropertySubjects(Resource value, Property prop) {
        HashSet<Resource> possibleSubjectSet = new HashSet<Resource>();
        ArrayList<Resource> directSubjectList = new ArrayList<Resource>();
        StmtIterator stmtIt = this.getOntModel().listStatements((Resource)null, prop, (RDFNode)value);
        while (stmtIt.hasNext()) {
            Statement stmt = stmtIt.nextStatement();
            possibleSubjectSet.add(stmt.getSubject());
        }
        for (Resource possibleRes : possibleSubjectSet) {
            StmtIterator pStmtIt = this.getOntModel().listStatements(possibleRes, prop, (RDFNode)null);
            boolean hasAlternatePath = false;
            while (stmtIt.hasNext()) {
                Statement stmt = stmtIt.nextStatement();
                if (!stmt.getObject().isResource() || !possibleSubjectSet.contains(stmt.getObject())) continue;
                hasAlternatePath = true;
                break;
            }
            if (hasAlternatePath) continue;
            directSubjectList.add(possibleRes);
        }
        return directSubjectList;
    }

    protected Model[] getSmartRemoval(OntResource ontRes, OntModel ontModel) {
        Model[] changeSet = this.removeFromLists(ontRes, ontModel);
        List<Statement> stmtForDependentRes = DependentResourceDeleteJena.getDependentResourceDeleteList((Resource)ontRes, (Model)ontModel);
        changeSet[0].add(this.removeUsingDescribe(ontRes, ontModel));
        changeSet[0].add(stmtForDependentRes);
        return changeSet;
    }

    protected void smartRemove(OntResource ontRes, OntModel ontModel) {
        Model[] changes = this.getSmartRemoval(ontRes, ontModel);
        ontModel.remove(changes[0]);
        ontModel.add(changes[1]);
    }

    private Model[] removeFromLists(OntResource res, OntModel ontModel) {
        Model[] changeSet = new Model[2];
        Model retractions = ModelFactory.createDefaultModel();
        Model additions = ModelFactory.createDefaultModel();
        changeSet[0] = retractions;
        changeSet[1] = additions;
        ResIterator listNodeIt = ontModel.listSubjectsWithProperty(RDF.first, (RDFNode)res);
        while (listNodeIt.hasNext()) {
            Resource listNode = (Resource)listNodeIt.next();
            Statement nextNodeStmt = listNode.getProperty(RDF.rest);
            if (nextNodeStmt != null) {
                RDFNode nextNode = nextNodeStmt.getObject();
                StmtIterator prevNodeIt = ontModel.listStatements((Resource)null, null, (RDFNode)listNode);
                while (prevNodeIt.hasNext()) {
                    Statement stmt = prevNodeIt.nextStatement();
                    if (!stmt.getPredicate().equals(RDF.rest)) {
                        if (nextNode.equals(RDF.nil)) continue;
                        additions.add(stmt.getSubject(), RDF.rest, nextNode);
                        continue;
                    }
                    additions.add(stmt.getSubject(), RDF.rest, nextNode);
                }
            }
            retractions.add(listNode, (Property)null, (RDFNode)null);
        }
        return changeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRulesMentioningResource(Resource res, OntModel ontModel) {
        ResIterator impIt = ontModel.listSubjectsWithProperty(RDF.type, SWRL_IMP);
        while (impIt.hasNext()) {
            Resource imp = (Resource)impIt.next();
            boolean removeMe = false;
            Model description = this.describeResource(imp, ontModel);
            try (NodeIterator objIt = description.listObjects();){
                while (objIt.hasNext()) {
                    RDFNode obj = objIt.nextNode();
                    if (!obj.equals(res)) continue;
                    removeMe = true;
                }
            }
            if (!removeMe) continue;
            ontModel.remove(description);
        }
    }

    private Model removeUsingDescribe(OntResource ontRes, OntModel ontModel) {
        Model temp = this.describeResource((Resource)ontRes, ontModel);
        temp.add(ontModel.listStatements((Resource)null, (Property)null, (RDFNode)ontRes));
        return temp;
    }

    private Model describeResource(Resource res, OntModel ontModel) {
        Model temp = ModelFactory.createDefaultModel();
        if (res.isAnon()) {
            temp.add(ontModel.listStatements(res, (Property)null, (RDFNode)null));
            return temp;
        }
        String describeQueryStr = "DESCRIBE <" + res.getURI() + ">";
        Query describeQuery = QueryFactory.create((String)describeQueryStr, (Syntax)Syntax.syntaxARQ);
        QueryExecution qe = QueryExecutionFactory.create((Query)describeQuery, (Model)ontModel);
        qe.execDescribe(temp);
        return temp;
    }
}

