/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.beans.FauxProperty;
import edu.cornell.mannlib.vitro.webapp.dao.FauxPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaBaseDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import edu.cornell.mannlib.vitro.webapp.utils.jena.criticalsection.LockableOntModel;
import edu.cornell.mannlib.vitro.webapp.utils.jena.criticalsection.LockableOntModelSelector;
import edu.cornell.mannlib.vitro.webapp.utils.jena.criticalsection.LockedOntModel;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.QueryHolder;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.ResultSetParser;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.SparqlQueryRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.ObjectProperty;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;

public class FauxPropertyDaoJena
extends JenaBaseDao
implements FauxPropertyDao {
    private static final Log log = LogFactory.getLog(FauxPropertyDaoJena.class);
    private static final String APPLICATION_CONTEXT_NS = "http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationConfiguration#";
    private static OntModel _constModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
    private static final Resource CONFIG_CONTEXT = ResourceFactory.createResource((String)FauxPropertyDaoJena.appContext("ConfigContext"));
    private static final Resource OBJECT_PROPERTY_DISPLAY_CONFIG = ResourceFactory.createResource((String)FauxPropertyDaoJena.appContext("ObjectPropertyDisplayConfig"));
    private static final ObjectProperty HAS_CONFIGURATION = FauxPropertyDaoJena.createProperty(FauxPropertyDaoJena.appContext("hasConfiguration"));
    private static final ObjectProperty CONFIG_CONTEXT_FOR = FauxPropertyDaoJena.createProperty(FauxPropertyDaoJena.appContext("configContextFor"));
    private static final ObjectProperty QUALIFIED_BY_RANGE = FauxPropertyDaoJena.createProperty(FauxPropertyDaoJena.appContext("qualifiedBy"));
    private static final ObjectProperty QUALIFIED_BY_DOMAIN = FauxPropertyDaoJena.createProperty(FauxPropertyDaoJena.appContext("qualifiedByDomain"));
    private static final ObjectProperty QUALIFIED_BY_ROOT = FauxPropertyDaoJena.createProperty(FauxPropertyDaoJena.appContext("qualifiedByRoot"));
    private static final ObjectProperty LIST_VIEW_FILE = FauxPropertyDaoJena.createProperty(FauxPropertyDaoJena.appContext("listViewConfigFile"));
    private static final ObjectProperty DISPLAY_NAME = FauxPropertyDaoJena.createProperty(FauxPropertyDaoJena.appContext("displayName"));
    private static final ObjectProperty PROPERTY_GROUP = FauxPropertyDaoJena.createProperty(FauxPropertyDaoJena.appContext("propertyGroup"));
    private static final ObjectProperty RDFS_LABEL = FauxPropertyDaoJena.createProperty("http://www.w3.org/2000/01/rdf-schema#label");
    private static final String SITE_CONFIG_NAMESPACE = "http://vitro.mannlib.cornell.edu/ns/vitro/siteConfig/";
    private final LockableOntModelSelector models;
    private static final String VCARD_KIND_URI = "http://www.w3.org/2006/vcard/ns#Kind";
    private static final String VCARD_NAMESPACE = "http://www.w3.org/2006/vcard/ns#";

    private static String appContext(String localName) {
        return APPLICATION_CONTEXT_NS + localName;
    }

    private static ObjectProperty createProperty(String uri) {
        return _constModel.createObjectProperty(uri);
    }

    public FauxPropertyDaoJena(WebappDaoFactoryJena wadf) {
        super(wadf);
        this.models = new LockableOntModelSelector(wadf.getOntModelSelector());
    }

    @Override
    protected OntModel getOntModel() {
        return this.getOntModelSelector().getDisplayModel();
    }

    @Override
    public List<FauxProperty> getFauxPropertiesForBaseUri(String uri) {
        if (uri == null) {
            return Collections.emptyList();
        }
        try (LockedOntModel displayModel = this.models.getDisplayModel().read();){
            HashSet<String> contextUris = new HashSet<String>();
            ResIterator contextResources = displayModel.listSubjectsWithProperty((Property)CONFIG_CONTEXT_FOR, (RDFNode)ResourceFactory.createResource((String)uri));
            for (Resource context : contextResources.toList()) {
                if (!context.isURIResource()) continue;
                contextUris.add(context.asResource().getURI());
            }
            ArrayList<FauxProperty> fpList = new ArrayList<FauxProperty>();
            for (String contextUri : contextUris) {
                FauxProperty fp = this.getFauxPropertyFromContextUri(contextUri);
                if (fp == null) continue;
                fpList.add(fp);
            }
            log.debug((Object)("Located " + fpList.size() + " FauxProperties."));
            ArrayList<FauxProperty> arrayList = fpList;
            return arrayList;
        }
    }

    @Override
    public FauxProperty getFauxPropertyFromContextUri(String contextUri) {
        if (contextUri == null) {
            return null;
        }
        try (LockedOntModel displayModel = this.models.getDisplayModel().read();){
            Collection<String> domainUris;
            OntResource context = displayModel.createOntResource(contextUri);
            if (!displayModel.contains((Resource)context, RDF.type, (RDFNode)CONFIG_CONTEXT)) {
                log.debug((Object)("'" + contextUri + "' is not a CONFIG_CONTEXT"));
                FauxProperty fauxProperty = null;
                return fauxProperty;
            }
            Collection<String> baseUris = this.getPropertyResourceURIValues((Resource)context, CONFIG_CONTEXT_FOR);
            if (baseUris.isEmpty()) {
                log.debug((Object)("'" + contextUri + "' has no value for '" + CONFIG_CONTEXT_FOR + "'"));
                FauxProperty fauxProperty = null;
                return fauxProperty;
            }
            String baseUri = baseUris.iterator().next();
            Collection<String> rangeUris = this.getPropertyResourceURIValues((Resource)context, QUALIFIED_BY_RANGE);
            String rangeUri = null;
            if (!rangeUris.isEmpty()) {
                rangeUri = rangeUris.iterator().next();
            }
            String domainUri = (domainUris = this.getPropertyResourceURIValues((Resource)context, QUALIFIED_BY_DOMAIN)).isEmpty() ? null : domainUris.iterator().next();
            Collection<String> rootRangeUris = this.getPropertyResourceURIValues((Resource)context, QUALIFIED_BY_ROOT);
            FauxProperty fp = new FauxProperty(domainUri, baseUri, rangeUri);
            if (!rootRangeUris.isEmpty()) {
                fp.setRootRangeUri(rootRangeUris.iterator().next());
            }
            fp.setContextUri(contextUri);
            this.populateInstance(fp);
            log.debug((Object)("Loaded FauxProperty: " + fp));
            FauxProperty fauxProperty = fp;
            return fauxProperty;
        }
    }

    @Override
    public FauxProperty getFauxPropertyByUris(String domainUri, String baseUri, String rangeUri) {
        Set<ConfigContext> contexts = ConfigContext.findByQualifiers(this.models.getDisplayModel(), domainUri, baseUri, rangeUri);
        if (contexts.isEmpty()) {
            log.debug((Object)("Can't find a FauxProperty for '" + domainUri + "', '" + baseUri + "', '" + rangeUri + "'"));
            return null;
        }
        FauxProperty fp = new FauxProperty(domainUri, baseUri, rangeUri);
        fp.setContextUri(contexts.iterator().next().getContextUri());
        this.populateInstance(fp);
        log.debug((Object)("Loaded FauxProperty: " + fp));
        return fp;
    }

    @Override
    public void insertFauxProperty(FauxProperty fp) {
        if (fp.getContextUri() != null || fp.getConfigUri() != null) {
            throw new IllegalStateException("ContextUri and ConfigUri must be null on insert: " + fp);
        }
        Set<ConfigContext> existingcontexts = ConfigContext.findByQualifiers(this.models.getDisplayModel(), fp.getDomainURI(), fp.getBaseURI(), fp.getRangeURI());
        if (!existingcontexts.isEmpty()) {
            throw new IllegalStateException("FauxProperty with these qualifiers already exists: " + fp);
        }
        try (LockedOntModel displayModel = this.models.getDisplayModel().write();){
            fp.setContextUri(this.getUnusedURI());
            OntResource context = displayModel.createOntResource(fp.getContextUri());
            this.addPropertyResourceValue((Resource)context, RDF.type, CONFIG_CONTEXT);
            this.addPropertyResourceURIValue((Resource)context, CONFIG_CONTEXT_FOR, fp.getBaseURI());
            this.addPropertyResourceURINotEmpty(context, QUALIFIED_BY_RANGE, fp.getRangeURI());
            this.addPropertyResourceURINotEmpty(context, QUALIFIED_BY_DOMAIN, fp.getDomainURI());
            this.storeQualifiedByRoot(context, fp.getRangeURI());
            fp.setConfigUri(this.getUnusedURI());
            this.addPropertyResourceURIValue((Resource)context, HAS_CONFIGURATION, fp.getConfigUri());
            OntResource config = displayModel.createOntResource(fp.getConfigUri());
            this.addPropertyResourceValue((Resource)config, RDF.type, OBJECT_PROPERTY_DISPLAY_CONFIG);
            this.addPropertyResourceURINotEmpty(config, PROPERTY_GROUP, fp.getGroupURI());
            this.updatePlainLiteralValue(config, (Property)DISPLAY_NAME, fp.getDisplayName());
            this.updatePlainLiteralValue(config, (Property)this.PUBLIC_DESCRIPTION_ANNOT, fp.getPublicDescription());
            this.addPropertyIntValue((Resource)config, (Property)this.DISPLAY_RANK_ANNOT, fp.getDisplayTier(), (Model)displayModel);
            this.addPropertyIntValue((Resource)config, (Property)this.DISPLAY_LIMIT, fp.getDisplayLimit(), (Model)displayModel);
            this.addPropertyBooleanValue((Resource)config, (Property)this.PROPERTY_COLLATEBYSUBCLASSANNOT, fp.isCollateBySubclass(), (Model)displayModel);
            this.addPropertyBooleanValue((Resource)config, (Property)this.PROPERTY_SELECTFROMEXISTINGANNOT, fp.isSelectFromExisting(), (Model)displayModel);
            this.addPropertyBooleanValue((Resource)config, (Property)this.PROPERTY_OFFERCREATENEWOPTIONANNOT, fp.isOfferCreateNewOption(), (Model)displayModel);
            this.addPropertyStringValue((Resource)config, (Property)this.PROPERTY_CUSTOMENTRYFORMANNOT, fp.getCustomEntryForm(), (Model)displayModel);
            this.addPropertyStringValue((Resource)config, (Property)LIST_VIEW_FILE, fp.getCustomListView(), (Model)displayModel);
            this.updatePropertyResourceURIValue((Resource)config, (Property)this.HIDDEN_FROM_DISPLAY_BELOW_ROLE_LEVEL_ANNOT, fp.getHiddenFromDisplayBelowRoleLevel().getURI());
            this.updatePropertyResourceURIValue((Resource)config, (Property)this.HIDDEN_FROM_PUBLISH_BELOW_ROLE_LEVEL_ANNOT, fp.getHiddenFromPublishBelowRoleLevel().getURI());
            this.updatePropertyResourceURIValue((Resource)config, (Property)this.PROHIBITED_FROM_UPDATE_BELOW_ROLE_LEVEL_ANNOT, fp.getProhibitedFromUpdateBelowRoleLevel().getURI());
        }
        catch (InsertException e) {
            throw new RuntimeException(e);
        }
    }

    private void addPropertyResourceURINotEmpty(OntResource context, ObjectProperty prop, String uri) {
        if (uri != null && !uri.isEmpty()) {
            this.addPropertyResourceURIValue((Resource)context, prop, uri);
        }
    }

    private void storeQualifiedByRoot(OntResource context, String rangeURI) {
        if (rangeURI.startsWith(VCARD_NAMESPACE)) {
            this.updatePropertyResourceURIValue((Resource)context, (Property)QUALIFIED_BY_ROOT, VCARD_KIND_URI);
        } else {
            this.updatePropertyResourceURIValue((Resource)context, (Property)QUALIFIED_BY_ROOT, null);
        }
    }

    @Override
    public void updateFauxProperty(FauxProperty fp) {
        Resource config;
        Resource context;
        log.debug((Object)("Updating FauxProperty: " + fp));
        try (LockedOntModel displayModel = this.models.getDisplayModel().read();){
            if (fp.getContextUri() == null) {
                throw new IllegalStateException("ContextURI may not be null: " + fp);
            }
            context = ResourceFactory.createResource((String)fp.getContextUri());
            if (fp.getConfigUri() == null) {
                throw new IllegalStateException("ConfigURI may not be null: " + fp);
            }
            config = ResourceFactory.createResource((String)fp.getConfigUri());
            if (!displayModel.contains(context, RDF.type, (RDFNode)CONFIG_CONTEXT)) {
                throw new IllegalStateException("'" + context + "' is not a '" + CONFIG_CONTEXT + "'");
            }
            if (!displayModel.contains(config, RDF.type, (RDFNode)OBJECT_PROPERTY_DISPLAY_CONFIG)) {
                throw new IllegalStateException("'" + config + "' is not a '" + OBJECT_PROPERTY_DISPLAY_CONFIG + "'");
            }
            if (!displayModel.contains(context, (Property)HAS_CONFIGURATION, (RDFNode)config)) {
                throw new IllegalStateException("'" + config + "' is not a configuration for '" + context + "'");
            }
        }
        displayModel = this.models.getDisplayModel().write();
        try {
            context = displayModel.createOntResource(fp.getContextUri());
            this.updatePropertyResourceURIValue(context, (Property)QUALIFIED_BY_RANGE, fp.getRangeURI());
            this.updatePropertyResourceURIValue(context, (Property)QUALIFIED_BY_DOMAIN, fp.getDomainURI());
            this.storeQualifiedByRoot((OntResource)context, fp.getRangeURI());
            config = displayModel.createOntResource(fp.getConfigUri());
            this.updatePropertyResourceURIValue(config, (Property)PROPERTY_GROUP, fp.getGroupURI());
            this.updatePlainLiteralValue((OntResource)config, (Property)DISPLAY_NAME, fp.getDisplayName());
            this.updatePlainLiteralValue((OntResource)config, (Property)this.PUBLIC_DESCRIPTION_ANNOT, fp.getPublicDescription());
            this.updatePropertyIntValue(config, (Property)this.DISPLAY_RANK_ANNOT, fp.getDisplayTier(), (Model)displayModel);
            this.updatePropertyIntValue(config, (Property)this.DISPLAY_LIMIT, fp.getDisplayLimit(), (Model)displayModel);
            this.updatePropertyBooleanValue(config, (Property)this.PROPERTY_COLLATEBYSUBCLASSANNOT, fp.isCollateBySubclass(), (Model)displayModel, true);
            this.updatePropertyBooleanValue(config, (Property)this.PROPERTY_SELECTFROMEXISTINGANNOT, fp.isSelectFromExisting(), (Model)displayModel, true);
            this.updatePropertyBooleanValue(config, (Property)this.PROPERTY_OFFERCREATENEWOPTIONANNOT, fp.isOfferCreateNewOption(), (Model)displayModel, true);
            this.updatePropertyStringValue(config, (Property)this.PROPERTY_CUSTOMENTRYFORMANNOT, fp.getCustomEntryForm(), (Model)displayModel);
            this.updatePropertyStringValue(config, (Property)LIST_VIEW_FILE, fp.getCustomListView(), (Model)displayModel);
            this.updatePropertyResourceURIValue(config, (Property)this.HIDDEN_FROM_DISPLAY_BELOW_ROLE_LEVEL_ANNOT, fp.getHiddenFromDisplayBelowRoleLevel().getURI());
            this.updatePropertyResourceURIValue(config, (Property)this.HIDDEN_FROM_PUBLISH_BELOW_ROLE_LEVEL_ANNOT, fp.getHiddenFromPublishBelowRoleLevel().getURI());
            this.updatePropertyResourceURIValue(config, (Property)this.PROHIBITED_FROM_UPDATE_BELOW_ROLE_LEVEL_ANNOT, fp.getProhibitedFromUpdateBelowRoleLevel().getURI());
        }
        finally {
            if (displayModel != null) {
                displayModel.close();
            }
        }
    }

    @Override
    public void deleteFauxProperty(FauxProperty fp) {
        Set<ConfigContext> contexts = ConfigContext.findByQualifiers(this.models.getDisplayModel(), fp.getDomainURI(), fp.getURI(), fp.getRangeURI());
        try (LockedOntModel displayModel = this.models.getDisplayModel().write();){
            for (ConfigContext context : contexts) {
                Resource configResource = ResourceFactory.createResource((String)context.getConfigUri());
                displayModel.removeAll(configResource, null, null);
                displayModel.removeAll(null, null, (RDFNode)configResource);
                Resource contextResource = ResourceFactory.createResource((String)context.getContextUri());
                displayModel.removeAll(contextResource, null, null);
                displayModel.removeAll(null, null, (RDFNode)contextResource);
            }
        }
    }

    private String getUnusedURI() throws InsertException {
        String errMsg = null;
        String namespace = SITE_CONFIG_NAMESPACE;
        String uri = null;
        Random random = new Random(System.currentTimeMillis());
        for (int attempts = 0; attempts < 30; ++attempts) {
            int upperBound = (int)Math.pow(2.0, attempts + 13);
            uri = namespace + "fp" + random.nextInt(upperBound);
            if (this.isUriUsed(uri)) continue;
            return uri;
        }
        throw new InsertException("Could not create URI for individual: " + errMsg);
    }

    private boolean isUriUsed(String uri) {
        try (LockedOntModel displayModel = this.models.getDisplayModel().read();){
            boolean bl = displayModel.getOntResource(uri) != null;
            return bl;
        }
    }

    private void populateInstance(FauxProperty fp) {
        this.populateLabelsFromTBox(fp);
        this.populateFieldsFromDisplayModel(fp);
    }

    private void populateLabelsFromTBox(FauxProperty fp) {
        fp.setBaseLabel(this.findLabelForClass(fp.getBaseURI()));
        fp.setRangeLabel(this.findLabelForClass(fp.getRangeURI()));
        fp.setDomainLabel(this.findLabelForClass(fp.getDomainURI()));
    }

    private String findLabelForClass(String classUri) {
        if (classUri == null) {
            return null;
        }
        try (LockedOntModel tboxModel = this.models.getTBoxModel().read();){
            String string = this.getPropertyStringValue(tboxModel.createOntResource(classUri), (Property)RDFS_LABEL);
            return string;
        }
    }

    private void populateFieldsFromDisplayModel(FauxProperty fp) {
        String configUri = this.locateConfigurationFromContext(fp.getContextUri());
        fp.setConfigUri(configUri);
        if (configUri != null) {
            try (LockedOntModel displayModel = this.models.getDisplayModel().read();){
                OntResource config = displayModel.createOntResource(configUri);
                fp.setDisplayName(this.getPropertyStringValue(config, (Property)DISPLAY_NAME));
                fp.setPublicDescription(this.getPropertyStringValue(config, (Property)this.PUBLIC_DESCRIPTION_ANNOT));
                fp.setGroupURI(this.getSingleResourceURIValue(config, PROPERTY_GROUP));
                fp.setCustomListView(this.getPropertyStringValue(config, (Property)LIST_VIEW_FILE));
                fp.setDisplayTier(this.getPropertyIntValue(config, (Property)this.DISPLAY_RANK_ANNOT));
                fp.setDisplayLimit(this.getPropertyIntValue(config, (Property)this.DISPLAY_LIMIT));
                fp.setCollateBySubclass(Boolean.TRUE.equals(this.getPropertyBooleanValue(config, (Property)this.PROPERTY_COLLATEBYSUBCLASSANNOT)));
                fp.setSelectFromExisting(Boolean.TRUE.equals(this.getPropertyBooleanValue(config, (Property)this.PROPERTY_SELECTFROMEXISTINGANNOT)));
                fp.setOfferCreateNewOption(Boolean.TRUE.equals(this.getPropertyBooleanValue(config, (Property)this.PROPERTY_OFFERCREATENEWOPTIONANNOT)));
                fp.setCustomEntryForm(this.getPropertyStringValue(config, (Property)this.PROPERTY_CUSTOMENTRYFORMANNOT));
                fp.setHiddenFromDisplayBelowRoleLevel(this.getMostRestrictiveRoleLevel((Resource)config, (Property)this.HIDDEN_FROM_DISPLAY_BELOW_ROLE_LEVEL_ANNOT));
                fp.setHiddenFromPublishBelowRoleLevel(this.getMostRestrictiveRoleLevel((Resource)config, (Property)this.HIDDEN_FROM_PUBLISH_BELOW_ROLE_LEVEL_ANNOT));
                fp.setProhibitedFromUpdateBelowRoleLevel(this.getMostRestrictiveRoleLevel((Resource)config, (Property)this.PROHIBITED_FROM_UPDATE_BELOW_ROLE_LEVEL_ANNOT));
            }
        }
    }

    private String locateConfigurationFromContext(String contextUri) {
        try (LockedOntModel displayModel = this.models.getDisplayModel().read();){
            Collection<String> configUris = this.getPropertyResourceURIValues((Resource)displayModel.createOntResource(contextUri), HAS_CONFIGURATION);
            if (configUris.isEmpty()) {
                String string = null;
                return string;
            }
            String string = configUris.iterator().next();
            return string;
        }
    }

    private String getSingleResourceURIValue(OntResource config, ObjectProperty prop) {
        Collection<String> values = this.getPropertyResourceURIValues((Resource)config, prop);
        if (values.isEmpty()) {
            return null;
        }
        return values.iterator().next();
    }

    private static String queryLocateConfigContext(boolean hasDomain, boolean hasRange) {
        return "PREFIX : <http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationConfiguration#> \nSELECT DISTINCT ?context ?config \nWHERE { \n    ?context a :ConfigContext . \n    ?context :configContextFor ?baseUri . \n" + (hasDomain ? "" : " FILTER NOT EXISTS { \n ") + "    ?context :qualifiedByDomain ?domainUri . \n" + (hasDomain ? "" : "} \n") + (hasRange ? "" : " FILTER NOT EXISTS { \n ") + "    ?context :qualifiedBy ?rangeUri . \n" + (hasRange ? "" : "} \n") + "    ?context :hasConfiguration ?config . \n} \n";
    }

    private static class ConfigContext {
        private final String contextUri;
        private final String configUri;
        private final String domainUri;
        private final String baseUri;
        private final String rangeUri;

        public static Set<ConfigContext> findByQualifiers(LockableOntModel lockableDisplayModel, String domainUri, String baseUri, String rangeUri) {
            try (LockedOntModel displayModel = lockableDisplayModel.read();){
                boolean hasDomain = !StringUtils.isEmpty((CharSequence)domainUri) && !domainUri.equals(OWL.Thing.getURI());
                boolean hasRange = !StringUtils.isEmpty((CharSequence)rangeUri);
                QueryHolder qHolder = SparqlQueryRunner.queryHolder(FauxPropertyDaoJena.queryLocateConfigContext(hasDomain, hasRange)).bindToUri("baseUri", baseUri);
                if (hasDomain) {
                    qHolder = qHolder.bindToUri("domainUri", domainUri);
                }
                if (hasRange) {
                    qHolder = qHolder.bindToUri("rangeUri", rangeUri);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("domainUri=" + domainUri + ", baseUri=" + baseUri + ", rangeUri=" + rangeUri + ", qHolder=" + qHolder));
                }
                ParserLocateConfigContext parser = new ParserLocateConfigContext(domainUri, baseUri, rangeUri);
                Set<ConfigContext> contexts = SparqlQueryRunner.createSelectQueryContext((Model)displayModel, qHolder).execute().parse(parser);
                log.debug((Object)("found " + contexts.size() + " contexts: " + contexts));
                Set<ConfigContext> set = contexts;
                return set;
            }
        }

        public ConfigContext(String contextUri, String configUri, String domainUri, String baseUri, String rangeUri) {
            this.contextUri = contextUri;
            this.configUri = configUri;
            this.domainUri = domainUri;
            this.baseUri = baseUri;
            this.rangeUri = rangeUri;
        }

        public String getContextUri() {
            return this.contextUri;
        }

        public String getConfigUri() {
            return this.configUri;
        }

        public String getDomainUri() {
            return this.domainUri;
        }

        public String getBaseUri() {
            return this.baseUri;
        }

        public String getRangeUri() {
            return this.rangeUri;
        }

        public String toString() {
            return "ConfigContext[contextUri=" + this.contextUri + ", configUri=" + this.configUri + ", domainUri=" + this.domainUri + ", baseUri=" + this.baseUri + ", rangeUri=" + this.rangeUri + "]";
        }
    }

    private static class ParserLocateConfigContext
    extends ResultSetParser<Set<ConfigContext>> {
        private final String domainUri;
        private final String baseUri;
        private final String rangeUri;

        public ParserLocateConfigContext(String domainUri, String baseUri, String rangeUri) {
            this.domainUri = domainUri;
            this.baseUri = baseUri;
            this.rangeUri = rangeUri;
        }

        @Override
        protected Set<ConfigContext> defaultValue() {
            return Collections.emptySet();
        }

        @Override
        protected Set<ConfigContext> parseResults(String queryStr, ResultSet results) {
            HashSet<ConfigContext> set = new HashSet<ConfigContext>();
            while (results.hasNext()) {
                QuerySolution row = results.next();
                String contextUri = this.ifResourcePresent(row, "context", null);
                String configUri = this.ifResourcePresent(row, "config", null);
                if (contextUri == null || configUri == null) continue;
                set.add(new ConfigContext(contextUri, configUri, this.domainUri, this.baseUri, this.rangeUri));
            }
            return set;
        }
    }
}

