/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.beans.Datatype;
import edu.cornell.mannlib.vitro.webapp.dao.DatatypeDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaBaseDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DatatypeDaoJena
extends JenaBaseDao
implements DatatypeDao {
    private List<Datatype> allDatatypes;
    private HashMap<String, Datatype> allDatatypesMap;

    public DatatypeDaoJena(WebappDaoFactoryJena wadf) {
        super(wadf);
    }

    @Override
    public void deleteDatatype(Datatype dtp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteDatatype(int id) {
        throw new UnsupportedOperationException();
    }

    public List getAllDatatypes() {
        if (this.allDatatypes == null) {
            this.init();
        }
        return this.allDatatypes;
    }

    @Override
    public Datatype getDatatypeById(int id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Datatype getDatatypeByURI(String uri) {
        if (this.allDatatypesMap == null) {
            this.init();
        }
        return this.allDatatypesMap.get(uri);
    }

    @Override
    public int getDatatypeIdByURI(String uri) {
        if (this.allDatatypesMap == null) {
            this.init();
        }
        return this.allDatatypesMap.get(uri).getId();
    }

    @Override
    public void updateDatatype(Datatype dtp) {
        throw new UnsupportedOperationException();
    }

    private synchronized void init() {
        ArrayList<Datatype> allDatatypes = new ArrayList<Datatype>();
        HashMap<String, Datatype> allDatatypesMap = new HashMap<String, Datatype>();
        int index = 0;
        Datatype stringD = new Datatype();
        stringD.setUri(this.XSD + "string");
        stringD.setName("string");
        stringD.setId(index++);
        allDatatypes.add(stringD);
        allDatatypesMap.put(stringD.getUri(), stringD);
        Datatype intD = new Datatype();
        intD.setUri(this.XSD + "int");
        intD.setName("integer between -2147483648 and 2147483647 (int)");
        intD.setId(index++);
        allDatatypes.add(intD);
        allDatatypesMap.put(this.XSD + "int", intD);
        Datatype integerD = new Datatype();
        integerD.setUri(this.XSD + "integer");
        integerD.setName("integer");
        integerD.setId(index++);
        allDatatypes.add(integerD);
        allDatatypesMap.put(integerD.getUri(), integerD);
        Datatype floatD = new Datatype();
        floatD.setUri(this.XSD + "float");
        floatD.setName("float");
        floatD.setId(index++);
        allDatatypes.add(floatD);
        allDatatypesMap.put(floatD.getUri(), floatD);
        Datatype dateTimeD = new Datatype();
        dateTimeD.setUri(this.XSD + "dateTime");
        dateTimeD.setName("date and time (YYYY-MM-DDThh:mm:ss)");
        dateTimeD.setId(index++);
        allDatatypes.add(dateTimeD);
        allDatatypesMap.put(this.XSD + "dateTime", dateTimeD);
        Datatype dateD = new Datatype();
        dateD.setUri(this.XSD + "date");
        dateD.setName("date (YYYY-MM-DD)");
        dateD.setId(index++);
        allDatatypes.add(dateD);
        allDatatypesMap.put(dateD.getUri(), dateD);
        Datatype timeD = new Datatype();
        timeD.setUri(this.XSD + "time");
        timeD.setName("time (hh:mm:ss)");
        timeD.setId(index++);
        allDatatypes.add(timeD);
        allDatatypesMap.put(timeD.getUri(), timeD);
        Datatype gYearD = new Datatype();
        gYearD.setUri(this.XSD + "gYear");
        gYearD.setName("year (YYYY)");
        gYearD.setId(index++);
        allDatatypes.add(gYearD);
        allDatatypesMap.put(gYearD.getUri(), gYearD);
        Datatype gMonthD = new Datatype();
        gMonthD.setUri(this.XSD + "gMonth");
        gMonthD.setName("month (MM)");
        gMonthD.setId(index++);
        allDatatypes.add(gMonthD);
        allDatatypesMap.put(gMonthD.getUri(), gYearD);
        Datatype gYearMonthD = new Datatype();
        gYearMonthD.setUri(this.XSD + "gYearMonth");
        gYearMonthD.setName("year and month (YYYY-MM)");
        gYearMonthD.setId(index++);
        allDatatypes.add(gYearMonthD);
        allDatatypesMap.put(gYearMonthD.getUri(), gYearMonthD);
        Datatype anyURID = new Datatype();
        anyURID.setUri(this.XSD + "anyURI");
        anyURID.setName("URI/URL");
        anyURID.setId(index++);
        allDatatypes.add(anyURID);
        allDatatypesMap.put(this.XSD + "anyURI", anyURID);
        Datatype booleanD = new Datatype();
        booleanD.setUri(this.XSD + "boolean");
        booleanD.setName("boolean (true/false)");
        booleanD.setId(index++);
        allDatatypes.add(booleanD);
        allDatatypesMap.put(booleanD.getUri(), booleanD);
        this.allDatatypes = allDatatypes;
        this.allDatatypesMap = allDatatypesMap;
    }
}

