/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DataPropertyStatementDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapper;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapperFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactorySDB;
import java.util.ArrayList;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;

public class DataPropertyStatementDaoSDB
extends DataPropertyStatementDaoJena
implements DataPropertyStatementDao {
    private DatasetWrapperFactory dwf;
    private WebappDaoFactorySDB.SDBDatasetMode datasetMode;

    public DataPropertyStatementDaoSDB(DatasetWrapperFactory datasetWrapperFactory, WebappDaoFactorySDB.SDBDatasetMode datasetMode, WebappDaoFactoryJena wadf) {
        super(datasetWrapperFactory, wadf);
        this.dwf = datasetWrapperFactory;
        this.datasetMode = datasetMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Individual fillExistingDataPropertyStatementsForIndividual(Individual entity) {
        if (entity.getURI() == null) {
            return entity;
        }
        String query = "CONSTRUCT { \n   <" + entity.getURI() + "> ?p ?o . \n} WHERE { \n   <" + entity.getURI() + "> ?p ?o . \n   FILTER(isLiteral(?o)) \n}";
        Model results = null;
        DatasetWrapper w = this.dwf.getDatasetWrapper();
        Dataset dataset = w.getDataset();
        dataset.getLock().enterCriticalSection(true);
        QueryExecution qexec = null;
        try {
            qexec = QueryExecutionFactory.create((Query)QueryFactory.create((String)query), (Dataset)dataset);
            results = qexec.execConstruct();
        }
        finally {
            if (qexec != null) {
                qexec.close();
            }
            dataset.getLock().leaveCriticalSection();
            w.close();
        }
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)results);
        ontModel.enterCriticalSection(true);
        try {
            Resource ind = ontModel.getResource(entity.getURI());
            ArrayList<DataPropertyStatement> edList = new ArrayList<DataPropertyStatement>();
            StmtIterator stmtIt = ind.listProperties();
            while (stmtIt.hasNext()) {
                Statement st = (Statement)stmtIt.next();
                boolean addToList = st.getObject().isLiteral() && (RDF.value.equals(st.getPredicate()) || "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#value".equals(st.getPredicate().getURI()) || this.MONIKER.equals(st.getPredicate()) || !this.NONUSER_NAMESPACES.contains(st.getPredicate().getNameSpace()));
                if (!addToList) continue;
                DataPropertyStatementImpl ed = new DataPropertyStatementImpl();
                Literal lit = (Literal)st.getObject();
                this.fillDataPropertyStatementWithJenaLiteral(ed, lit);
                ed.setDatapropURI(st.getPredicate().getURI());
                ed.setIndividualURI(ind.getURI());
                ed.setIndividual(entity);
                edList.add(ed);
            }
            entity.setDataPropertyStatements(edList);
            Individual individual = entity;
            return individual;
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }
}

