/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapper;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapperFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaBaseDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.IndividualUpdateEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;

public class DataPropertyStatementDaoJena
extends JenaBaseDao
implements DataPropertyStatementDao {
    private static final Log log = LogFactory.getLog(DataPropertyStatementDaoJena.class);
    private DatasetWrapperFactory dwf;
    private int NO_LIMIT = -1;
    protected static final String DATA_PROPERTY_VALUE_QUERY_STRING = "SELECT ?value WHERE { \n    ?subject ?property ?value . \n FILTER ( isLiteral(?value) ) } ORDER BY ?value";
    protected static Query dataPropertyValueQuery;

    public DataPropertyStatementDaoJena(DatasetWrapperFactory dwf, WebappDaoFactoryJena wadf) {
        super(wadf);
        this.dwf = dwf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDataPropertyStatement(DataPropertyStatement dataPropertyStatement) {
        OntModel ontModel = this.getOntModelSelector().getABoxModel();
        try {
            ontModel.enterCriticalSection(false);
            this.getOntModel().getBaseModel().notifyEvent((Object)new IndividualUpdateEvent(this.getWebappDaoFactory().getUserURI(), true, dataPropertyStatement.getIndividualURI()));
            Individual ind = ontModel.getIndividual(dataPropertyStatement.getIndividualURI());
            OntModel tboxModel = this.getOntModelSelector().getTBoxModel();
            tboxModel.enterCriticalSection(true);
            try {
                Property prop = tboxModel.getProperty(dataPropertyStatement.getDatapropURI());
                Literal l = this.jenaLiteralFromDataPropertyStatement(dataPropertyStatement, ontModel);
                if (ind != null && prop != null && l != null) {
                    ontModel.getBaseModel().remove((Resource)ind, prop, (RDFNode)l);
                }
            }
            finally {
                tboxModel.leaveCriticalSection();
            }
        }
        finally {
            this.getOntModel().getBaseModel().notifyEvent((Object)new IndividualUpdateEvent(this.getWebappDaoFactory().getUserURI(), false, dataPropertyStatement.getIndividualURI()));
            ontModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public edu.cornell.mannlib.vitro.webapp.beans.Individual fillExistingDataPropertyStatementsForIndividual(edu.cornell.mannlib.vitro.webapp.beans.Individual entity) {
        if (entity.getURI() == null) {
            return entity;
        }
        OntModel ontModel = this.getOntModelSelector().getABoxModel();
        ontModel.enterCriticalSection(true);
        try {
            Resource ind = ontModel.getResource(entity.getURI());
            ArrayList<DataPropertyStatement> edList = new ArrayList<DataPropertyStatement>();
            StmtIterator stmtIt = ind.listProperties();
            while (stmtIt.hasNext()) {
                Statement st = (Statement)stmtIt.next();
                boolean addToList = st.getObject().isLiteral() && (RDF.value.equals(st.getPredicate()) || "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#value".equals(st.getPredicate().getURI()) || !this.NONUSER_NAMESPACES.contains(st.getPredicate().getNameSpace()));
                if (!addToList) continue;
                DataPropertyStatementImpl ed = new DataPropertyStatementImpl();
                Literal lit = (Literal)st.getObject();
                this.fillDataPropertyStatementWithJenaLiteral(ed, lit);
                ed.setDatapropURI(st.getPredicate().getURI());
                ed.setIndividualURI(ind.getURI());
                ed.setIndividual(entity);
                edList.add(ed);
            }
            entity.setDataPropertyStatements(edList);
            edu.cornell.mannlib.vitro.webapp.beans.Individual individual = entity;
            return individual;
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }

    @Override
    public void deleteDataPropertyStatementsForIndividualByDataProperty(String individualURI, String dataPropertyURI) {
        this.deleteDataPropertyStatementsForIndividualByDataProperty(individualURI, dataPropertyURI, this.getOntModelSelector().getABoxModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDataPropertyStatementsForIndividualByDataProperty(String individualURI, String dataPropertyURI, OntModel ontModel) {
        ontModel.enterCriticalSection(false);
        this.getOntModel().getBaseModel().notifyEvent((Object)new IndividualUpdateEvent(this.getWebappDaoFactory().getUserURI(), true, individualURI));
        try {
            Resource indRes = ResourceFactory.createResource((String)individualURI);
            Property datatypeProperty = ResourceFactory.createProperty((String)dataPropertyURI);
            ontModel.removeAll(indRes, datatypeProperty, (RDFNode)((Literal)null));
        }
        catch (Exception ex) {
            log.error((Object)("Error occurred in removal of data property " + dataPropertyURI + " for " + individualURI));
        }
        finally {
            this.getOntModel().getBaseModel().notifyEvent((Object)new IndividualUpdateEvent(this.getWebappDaoFactory().getUserURI(), false, individualURI));
            ontModel.leaveCriticalSection();
        }
    }

    @Override
    public void deleteDataPropertyStatementsForIndividualByDataProperty(edu.cornell.mannlib.vitro.webapp.beans.Individual individual, DataProperty dataProperty) {
        this.deleteDataPropertyStatementsForIndividualByDataProperty(individual.getURI(), dataProperty.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DataPropertyStatement> getDataPropertyStatementsForIndividualByDataPropertyURI(edu.cornell.mannlib.vitro.webapp.beans.Individual entity, String datapropURI) {
        ArrayList<DataPropertyStatement> edList = new ArrayList<DataPropertyStatement>();
        if (entity.getURI() == null || datapropURI == null) {
            return edList;
        }
        Resource res = ResourceFactory.createResource((String)entity.getURI());
        if (!"http://vitro.mannlib.cornell.edu/ns/bnode#".equals(entity.getNamespace())) {
            for (Literal lit : this.getDataPropertyValuesForIndividualByProperty(res.getURI(), datapropURI)) {
                log.debug((Object)("Literal lit = " + lit));
                DataPropertyStatementImpl ed = new DataPropertyStatementImpl();
                this.fillDataPropertyStatementWithJenaLiteral(ed, lit);
                ed.setIndividualURI(entity.getURI());
                ed.setIndividual(entity);
                ed.setDatapropURI(datapropURI);
                edList.add(ed);
            }
            return edList;
        }
        try {
            this.getOntModel().enterCriticalSection(true);
            OntResource ontRes = (OntResource)this.getOntModel().createResource(new AnonId(entity.getLocalName())).as(OntResource.class);
            if (ontRes == null) {
                ArrayList<DataPropertyStatement> lit = edList;
                return lit;
            }
            try (StmtIterator stmtIt = datapropURI != null ? ontRes.listProperties(this.getOntModel().getProperty(datapropURI)) : ontRes.listProperties();){
                while (stmtIt.hasNext()) {
                    Statement st = (Statement)stmtIt.next();
                    if (!st.getObject().isLiteral()) continue;
                    DataPropertyStatementImpl ed = new DataPropertyStatementImpl();
                    Literal lit = (Literal)st.getObject();
                    this.fillDataPropertyStatementWithJenaLiteral(ed, lit);
                    ed.setIndividualURI(entity.getURI());
                    ed.setIndividual(entity);
                    ed.setDatapropURI(st.getPredicate().getURI());
                    edList.add(ed);
                }
            }
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        return edList;
    }

    @Override
    @Deprecated
    public List getExistingQualifiers(String datapropURI) {
        return null;
    }

    @Override
    public List<DataPropertyStatement> getDataPropertyStatements(DataProperty dp) {
        return this.getDataPropertyStatements(dp, this.NO_LIMIT, this.NO_LIMIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DataPropertyStatement> getDataPropertyStatements(DataProperty dp, int startIndex, int endIndex) {
        this.getOntModel().enterCriticalSection(true);
        ArrayList<DataPropertyStatement> dpss = new ArrayList<DataPropertyStatement>();
        try {
            Property prop = ResourceFactory.createProperty((String)dp.getURI());
            try (StmtIterator dpsIt = this.getOntModel().listStatements(null, prop, (RDFNode)((Literal)null));){
                int count = 0;
                while (dpsIt.hasNext() && (endIndex < 0 || count < endIndex)) {
                    Statement stmt = (Statement)dpsIt.next();
                    if (startIndex >= 0 && startIndex > ++count) continue;
                    Literal lit = (Literal)stmt.getObject();
                    DataPropertyStatementImpl dps = new DataPropertyStatementImpl();
                    dps.setDatapropURI(dp.getURI());
                    dps.setIndividualURI(stmt.getSubject().getURI());
                    this.fillDataPropertyStatementWithJenaLiteral(dps, lit);
                    dpss.add(dps);
                }
            }
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        return dpss;
    }

    @Override
    public int insertNewDataPropertyStatement(DataPropertyStatement dataPropertyStmt) {
        return this.insertNewDataPropertyStatement(dataPropertyStmt, this.getOntModelSelector().getABoxModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertNewDataPropertyStatement(DataPropertyStatement dataPropertyStmt, OntModel ontModel) {
        ontModel.enterCriticalSection(false);
        this.getOntModel().getBaseModel().notifyEvent((Object)new IndividualUpdateEvent(this.getWebappDaoFactory().getUserURI(), true, dataPropertyStmt.getIndividualURI()));
        DataProperty dp = this.getWebappDaoFactory().getDataPropertyDao().getDataPropertyByURI(dataPropertyStmt.getDatapropURI());
        if (dataPropertyStmt.getDatatypeURI() == null && dp != null && dp.getRangeDatatypeURI() != null) {
            dataPropertyStmt.setDatatypeURI(dp.getRangeDatatypeURI());
        }
        Property prop = ontModel.getProperty(dataPropertyStmt.getDatapropURI());
        try {
            Resource res = ontModel.getResource(dataPropertyStmt.getIndividualURI());
            Literal literal = this.jenaLiteralFromDataPropertyStatement(dataPropertyStmt, ontModel);
            if (res != null && prop != null && literal != null && dataPropertyStmt.getData().length() > 0) {
                res.addProperty(prop, (RDFNode)literal);
            }
        }
        catch (Exception ex) {
            log.error((Object)("Error occurred in adding a data property for " + dataPropertyStmt.toString()));
        }
        finally {
            this.getOntModel().getBaseModel().notifyEvent((Object)new IndividualUpdateEvent(this.getWebappDaoFactory().getUserURI(), false, dataPropertyStmt.getIndividualURI()));
            ontModel.leaveCriticalSection();
        }
        return 0;
    }

    protected DataPropertyStatement fillDataPropertyStatementWithJenaLiteral(DataPropertyStatement dataPropertyStatement, Literal l) {
        dataPropertyStatement.setData(l.getLexicalForm());
        dataPropertyStatement.setDatatypeURI(l.getDatatypeURI());
        dataPropertyStatement.setLanguage(l.getLanguage());
        return dataPropertyStatement;
    }

    protected Literal jenaLiteralFromDataPropertyStatement(DataPropertyStatement dataPropertyStatement, OntModel ontModel) {
        Literal l = null;
        l = dataPropertyStatement.getLanguage() != null && dataPropertyStatement.getLanguage().length() > 0 ? ontModel.createLiteral(dataPropertyStatement.getData(), dataPropertyStatement.getLanguage()) : (dataPropertyStatement.getDatatypeURI() != null && dataPropertyStatement.getDatatypeURI().length() > 0 ? ontModel.createTypedLiteral(dataPropertyStatement.getData(), TypeMapper.getInstance().getSafeTypeByName(dataPropertyStatement.getDatatypeURI())) : ontModel.createLiteral(dataPropertyStatement.getData()));
        return l;
    }

    @Override
    public List<Literal> getDataPropertyValuesForIndividualByProperty(edu.cornell.mannlib.vitro.webapp.beans.Individual subject, DataProperty property) {
        return this.getDataPropertyValuesForIndividualByProperty(subject.getURI(), property.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Literal> getDataPropertyValuesForIndividualByProperty(String subjectUri, String propertyUri) {
        log.debug((Object)"Data property value query string:\nSELECT ?value WHERE { \n    ?subject ?property ?value . \n FILTER ( isLiteral(?value) ) } ORDER BY ?value");
        log.debug((Object)("Data property value:\n" + dataPropertyValueQuery));
        HashMap<String, String> bindings = new HashMap<String, String>();
        bindings.put("subject", subjectUri);
        bindings.put("property", propertyUri);
        String queryString = QueryUtils.subUrisForQueryVars(DATA_PROPERTY_VALUE_QUERY_STRING, bindings);
        ArrayList<Literal> values = new ArrayList<Literal>();
        DatasetWrapper w = this.dwf.getDatasetWrapper();
        Dataset dataset = w.getDataset();
        dataset.getLock().enterCriticalSection(true);
        QueryExecution qexec = null;
        try {
            qexec = QueryExecutionFactory.create((String)queryString, (Dataset)dataset);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution sol = results.next();
                Literal value = sol.getLiteral("value");
                values.add(value);
            }
            ArrayList<Literal> arrayList = values;
            return arrayList;
        }
        catch (Exception e) {
            log.error((Object)("Error getting data property values for individual " + subjectUri + " and property " + propertyUri));
            List<Literal> list = Collections.emptyList();
            return list;
        }
        finally {
            dataset.getLock().leaveCriticalSection();
            w.close();
            if (qexec != null) {
                qexec.close();
            }
        }
    }

    @Override
    public List<Literal> getDataPropertyValuesForIndividualByProperty(edu.cornell.mannlib.vitro.webapp.beans.Individual subject, DataProperty property, String queryString, Set<String> constructQueryStrings) {
        return this.getDataPropertyValuesForIndividualByProperty(subject.getURI(), property.getURI(), queryString, constructQueryStrings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Literal> getDataPropertyValuesForIndividualByProperty(String subjectUri, String propertyUri, String queryString, Set<String> constructQueryStrings) {
        Model constructedModel = this.constructModelForSelectQueries(subjectUri, propertyUri, constructQueryStrings);
        log.debug((Object)("Query string for data property " + propertyUri + ": " + queryString));
        Query query = null;
        try {
            query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        }
        catch (Throwable th) {
            log.error((Object)("Could not create SPARQL query for query string. " + th.getMessage()));
            log.error((Object)queryString);
            return Collections.emptyList();
        }
        QuerySolutionMap initialBindings = new QuerySolutionMap();
        initialBindings.add("subject", (RDFNode)ResourceFactory.createResource((String)subjectUri));
        initialBindings.add("property", (RDFNode)ResourceFactory.createResource((String)propertyUri));
        ArrayList<Literal> values = new ArrayList<Literal>();
        DatasetWrapper w = this.dwf.getDatasetWrapper();
        Dataset dataset = w.getDataset();
        dataset.getLock().enterCriticalSection(true);
        QueryExecution qexec = null;
        try {
            qexec = constructedModel == null ? QueryExecutionFactory.create((Query)query, (Dataset)dataset, (QuerySolution)initialBindings) : QueryExecutionFactory.create((Query)query, (Model)constructedModel, (QuerySolution)initialBindings);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution sol = results.next();
                Literal value = sol.getLiteral("value");
                if (value == null) continue;
                values.add(value);
            }
            log.debug((Object)("values = " + values));
            ArrayList<Literal> arrayList = values;
            return arrayList;
        }
        catch (Exception e) {
            log.error((Object)("Error getting data property values for subject " + subjectUri + " and property " + propertyUri));
            List<Literal> list = Collections.emptyList();
            return list;
        }
        finally {
            dataset.getLock().leaveCriticalSection();
            w.close();
            if (qexec != null) {
                qexec.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model constructModelForSelectQueries(String subjectUri, String propertyUri, Set<String> constructQueries) {
        if (constructQueries == null || constructQueries.isEmpty()) {
            return null;
        }
        Model constructedModel = ModelFactory.createDefaultModel();
        for (String queryString : constructQueries) {
            log.debug((Object)("CONSTRUCT query string for object property " + propertyUri + ": " + queryString));
            Query query = null;
            try {
                query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
            }
            catch (Throwable th) {
                log.error((Object)("Could not create CONSTRUCT SPARQL query for query string. " + th.getMessage()));
                log.error((Object)queryString);
                return constructedModel;
            }
            QuerySolutionMap initialBindings = new QuerySolutionMap();
            initialBindings.add("subject", (RDFNode)ResourceFactory.createResource((String)subjectUri));
            initialBindings.add("property", (RDFNode)ResourceFactory.createResource((String)propertyUri));
            DatasetWrapper w = this.dwf.getDatasetWrapper();
            Dataset dataset = w.getDataset();
            dataset.getLock().enterCriticalSection(true);
            QueryExecution qe = null;
            try {
                qe = QueryExecutionFactory.create((Query)query, (Dataset)dataset, (QuerySolution)initialBindings);
                qe.execConstruct(constructedModel);
            }
            catch (Exception e) {
                log.error((Object)("Error getting constructed model for subject " + subjectUri + " and property " + propertyUri));
            }
            finally {
                if (qe != null) {
                    qe.close();
                }
                dataset.getLock().leaveCriticalSection();
                w.close();
            }
        }
        return constructedModel;
    }

    static {
        try {
            dataPropertyValueQuery = QueryFactory.create((String)DATA_PROPERTY_VALUE_QUERY_STRING);
        }
        catch (Throwable th) {
            log.error((Object)("could not create SPARQL query for DATA_PROPERTY_VALUE_QUERY_STRING " + th.getMessage()));
            log.error((Object)DATA_PROPERTY_VALUE_QUERY_STRING);
        }
    }
}

