/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.filtering;

import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupDao;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.BaseFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.WebappDaoFactoryFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFilters;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class VClassGroupDaoFiltering
extends BaseFiltering
implements VClassGroupDao {
    private final VClassGroupDao innerDao;
    private final WebappDaoFactoryFiltering filteredDaos;
    private final VitroFilters filters;

    public VClassGroupDaoFiltering(VClassGroupDao classGroupDao, WebappDaoFactoryFiltering webappDaoFactoryFiltering, VitroFilters filters) {
        this.innerDao = classGroupDao;
        this.filteredDaos = webappDaoFactoryFiltering;
        this.filters = filters;
    }

    @Override
    public void deleteVClassGroup(VClassGroup vcg) {
        this.innerDao.deleteVClassGroup(vcg);
    }

    @Override
    public LinkedHashMap<String, VClassGroup> getClassGroupMap() {
        LinkedHashMap<String, VClassGroup> lhm = this.innerDao.getClassGroupMap();
        Set<String> keys = lhm.keySet();
        for (String key : keys) {
            VClassGroup vcg = lhm.get(key);
            if (vcg != null && ((Boolean)this.filters.getVClassGroupFilter().fn((Object)vcg)).booleanValue()) continue;
            lhm.remove(key);
        }
        return lhm;
    }

    @Override
    public VClassGroup getGroupByURI(String uri) {
        VClassGroup vg = this.innerDao.getGroupByURI(uri);
        if (vg != null && ((Boolean)this.filters.getVClassGroupFilter().fn((Object)vg)).booleanValue()) {
            return vg;
        }
        return null;
    }

    @Override
    public List<VClassGroup> getPublicGroupsWithVClasses() {
        return this.getPublicGroupsWithVClasses(false);
    }

    @Override
    public List<VClassGroup> getPublicGroupsWithVClasses(boolean displayOrder) {
        return this.getPublicGroupsWithVClasses(displayOrder, true);
    }

    @Override
    public List<VClassGroup> getPublicGroupsWithVClasses(boolean displayOrder, boolean includeUninstantiatedClasses) {
        return this.getPublicGroupsWithVClasses(displayOrder, includeUninstantiatedClasses, false);
    }

    @Override
    public List<VClassGroup> getPublicGroupsWithVClasses(boolean displayOrder, boolean includeUninstantiatedClasses, boolean getIndividualCount) {
        LinkedHashMap<String, VClassGroup> groupMap = this.getClassGroupMap();
        ArrayList<VClassGroup> groups = new ArrayList<VClassGroup>(groupMap.values());
        VClassDao vclassDao = this.filteredDaos.getVClassDao();
        for (VClassGroup vg : groups) {
            vclassDao.addVClassesToGroup(vg, includeUninstantiatedClasses, getIndividualCount);
        }
        if (!includeUninstantiatedClasses) {
            ListIterator it = groups.listIterator();
            while (it.hasNext()) {
                if (((VClassGroup)it.next()).size() != 0) continue;
                it.remove();
            }
        }
        return groups;
    }

    @Override
    public int insertNewVClassGroup(VClassGroup vcg) {
        return this.innerDao.insertNewVClassGroup(vcg);
    }

    @Override
    public int removeUnpopulatedGroups(List<VClassGroup> groups) {
        return this.innerDao.removeUnpopulatedGroups(groups);
    }

    @Override
    public void sortGroupList(List<VClassGroup> groupList) {
        this.innerDao.sortGroupList(groupList);
    }

    @Override
    public void updateVClassGroup(VClassGroup vcg) {
        this.innerDao.updateVClassGroup(vcg);
    }

    @Override
    public VClassGroup getGroupByName(String vcgName) {
        return this.innerDao.getGroupByName(vcgName);
    }
}

