/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.filtering;

import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.ObjectPropertyStatementFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFilters;
import java.util.LinkedList;
import java.util.List;
import net.sf.jga.algorithms.Filter;

public class ObjectPropertyFiltering
extends ObjectProperty {
    private VitroFilters filters;
    private ObjectProperty innerObjectProperty;

    public ObjectPropertyFiltering(ObjectProperty innerObjectProperty, VitroFilters filters) {
        this.innerObjectProperty = innerObjectProperty;
        this.filters = filters;
    }

    @Override
    public List<ObjectPropertyStatement> getObjectPropertyStatements() {
        List<ObjectPropertyStatement> propStmts = this.innerObjectProperty.getObjectPropertyStatements();
        if (propStmts == null) {
            return null;
        }
        LinkedList fileredStmts = new LinkedList();
        Filter.filter(propStmts, this.filters.getObjectPropertyStatementFilter(), fileredStmts);
        LinkedList<ObjectPropertyStatement> filteredOnSubjStmts = new LinkedList<ObjectPropertyStatement>();
        for (ObjectPropertyStatement stmt : fileredStmts) {
            filteredOnSubjStmts.add(new ObjectPropertyStatementFiltering(stmt, this.filters));
        }
        return filteredOnSubjStmts;
    }

    @Override
    public int compareTo(ObjectProperty op) {
        return this.innerObjectProperty.compareTo(op);
    }

    @Override
    public boolean equals(Object obj) {
        return this.innerObjectProperty.equals(obj);
    }

    @Override
    public String getCustomEntryForm() {
        return this.innerObjectProperty.getCustomEntryForm();
    }

    @Override
    public String getDescription() {
        return this.innerObjectProperty.getDescription();
    }

    @Override
    public int getDomainDisplayLimit() {
        return this.innerObjectProperty.getDomainDisplayLimit();
    }

    @Override
    public Integer getDomainDisplayLimitInteger() {
        return this.innerObjectProperty.getDomainDisplayLimitInteger();
    }

    @Override
    public int getDomainDisplayTier() {
        return this.innerObjectProperty.getDomainDisplayTier();
    }

    @Override
    public Integer getDomainDisplayTierInteger() {
        return this.innerObjectProperty.getDomainDisplayTierInteger();
    }

    @Override
    public String getDomainEntitySortDirection() {
        return this.innerObjectProperty.getDomainEntitySortDirection();
    }

    @Override
    public String getDomainEntityURI() {
        return this.innerObjectProperty.getDomainEntityURI();
    }

    @Override
    public String getDomainPublic() {
        return this.innerObjectProperty.getDomainPublic();
    }

    @Override
    public VClass getDomainVClass() {
        return this.innerObjectProperty.getDomainVClass();
    }

    @Override
    public String getDomainVClassURI() {
        return this.innerObjectProperty.getDomainVClassURI();
    }

    @Override
    public String getLabel() {
        return this.innerObjectProperty.getLabel();
    }

    @Override
    public String getExample() {
        return this.innerObjectProperty.getExample();
    }

    @Override
    public boolean getFunctional() {
        return this.innerObjectProperty.getFunctional();
    }

    @Override
    public String getGroupURI() {
        return this.innerObjectProperty.getGroupURI();
    }

    @Override
    public BaseResourceBean.RoleLevel getHiddenFromDisplayBelowRoleLevel() {
        return this.innerObjectProperty.getHiddenFromDisplayBelowRoleLevel();
    }

    @Override
    public BaseResourceBean.RoleLevel getProhibitedFromUpdateBelowRoleLevel() {
        return this.innerObjectProperty.getProhibitedFromUpdateBelowRoleLevel();
    }

    @Override
    public BaseResourceBean.RoleLevel getHiddenFromPublishBelowRoleLevel() {
        return this.innerObjectProperty.getHiddenFromPublishBelowRoleLevel();
    }

    @Override
    public boolean getInverseFunctional() {
        return this.innerObjectProperty.getInverseFunctional();
    }

    @Override
    public String getLocalName() {
        return this.innerObjectProperty.getLocalName();
    }

    @Override
    public String getLocalNameInverse() {
        return this.innerObjectProperty.getLocalNameInverse();
    }

    @Override
    public String getLocalNameWithPrefix() {
        return this.innerObjectProperty.getLocalNameWithPrefix();
    }

    @Override
    public String getPickListName() {
        return this.innerObjectProperty.getPickListName();
    }

    @Override
    public String getNamespace() {
        return this.innerObjectProperty.getNamespace();
    }

    @Override
    public String getNamespaceInverse() {
        return this.innerObjectProperty.getNamespaceInverse();
    }

    @Override
    public String getObjectIndividualSortPropertyURI() {
        return this.innerObjectProperty.getObjectIndividualSortPropertyURI();
    }

    @Override
    public boolean getOfferCreateNewOption() {
        return this.innerObjectProperty.getOfferCreateNewOption();
    }

    @Override
    public String getParentURI() {
        return this.innerObjectProperty.getParentURI();
    }

    @Override
    public String getPublicDescription() {
        return this.innerObjectProperty.getPublicDescription();
    }

    @Override
    public int getRangeDisplayLimit() {
        return this.innerObjectProperty.getRangeDisplayLimit();
    }

    @Override
    public Integer getRangeDisplayLimitInteger() {
        return this.innerObjectProperty.getRangeDisplayLimitInteger();
    }

    @Override
    public int getRangeDisplayTier() {
        return this.innerObjectProperty.getRangeDisplayTier();
    }

    @Override
    public Integer getRangeDisplayTierInteger() {
        return this.innerObjectProperty.getRangeDisplayTierInteger();
    }

    @Override
    public String getRangeEntitySortDirection() {
        return this.innerObjectProperty.getRangeEntitySortDirection();
    }

    @Override
    public String getRangeEntityURI() {
        return this.innerObjectProperty.getRangeEntityURI();
    }

    @Override
    public String getRangePublic() {
        return this.innerObjectProperty.getRangePublic();
    }

    @Override
    public VClass getRangeVClass() {
        return this.innerObjectProperty.getRangeVClass();
    }

    @Override
    public String getRangeVClassURI() {
        return this.innerObjectProperty.getRangeVClassURI();
    }

    @Override
    public boolean getSelectFromExisting() {
        return this.innerObjectProperty.getSelectFromExisting();
    }

    @Override
    public boolean getSymmetric() {
        return this.innerObjectProperty.getSymmetric();
    }

    @Override
    public boolean getTransitive() {
        return this.innerObjectProperty.getTransitive();
    }

    @Override
    public String getURI() {
        return this.innerObjectProperty.getURI();
    }

    @Override
    public String getURIInverse() {
        return this.innerObjectProperty.getURIInverse();
    }

    @Override
    public int hashCode() {
        return this.innerObjectProperty.hashCode();
    }

    @Override
    public boolean isAnonymous() {
        return this.innerObjectProperty.isAnonymous();
    }

    @Override
    public boolean isSubjectSide() {
        return this.innerObjectProperty.isSubjectSide();
    }

    @Override
    public void setCustomEntryForm(String s) {
        this.innerObjectProperty.setCustomEntryForm(s);
    }

    @Override
    public void setDescription(String description) {
        this.innerObjectProperty.setDescription(description);
    }

    @Override
    public void setDomainDisplayLimit(Integer domainDisplayLimit) {
        this.innerObjectProperty.setDomainDisplayLimit(domainDisplayLimit);
    }

    @Override
    public void setDomainDisplayTier(Integer domainDisplayTier) {
        this.innerObjectProperty.setDomainDisplayTier(domainDisplayTier);
    }

    @Override
    public void setDomainEntitySortDirection(String domainEntitySortDirection) {
        this.innerObjectProperty.setDomainEntitySortDirection(domainEntitySortDirection);
    }

    @Override
    public void setDomainEntityURI(String domainEntityURI) {
        this.innerObjectProperty.setDomainEntityURI(domainEntityURI);
    }

    @Override
    public void setDomainPublic(String domainPublic) {
        this.innerObjectProperty.setDomainPublic(domainPublic);
    }

    @Override
    public void setDomainVClass(VClass domainVClass) {
        this.innerObjectProperty.setDomainVClass(domainVClass);
    }

    @Override
    public void setDomainVClassURI(String domainClassURI) {
        this.innerObjectProperty.setDomainVClassURI(domainClassURI);
    }

    @Override
    public void setLabel(String label) {
        this.innerObjectProperty.setLabel(label);
    }

    @Override
    public void setExample(String example) {
        this.innerObjectProperty.setExample(example);
    }

    @Override
    public void setFunctional(boolean functional) {
        this.innerObjectProperty.setFunctional(functional);
    }

    @Override
    public void setGroupURI(String in) {
        this.innerObjectProperty.setGroupURI(in);
    }

    @Override
    public void setHiddenFromDisplayBelowRoleLevel(BaseResourceBean.RoleLevel eR) {
        this.innerObjectProperty.setHiddenFromDisplayBelowRoleLevel(eR);
    }

    @Override
    public void setHiddenFromDisplayBelowRoleLevelUsingRoleUri(String roleUri) {
        this.innerObjectProperty.setHiddenFromDisplayBelowRoleLevel(BaseResourceBean.RoleLevel.getRoleByUri(roleUri));
    }

    @Override
    public void setProhibitedFromUpdateBelowRoleLevel(BaseResourceBean.RoleLevel eR) {
        this.innerObjectProperty.setProhibitedFromUpdateBelowRoleLevel(eR);
    }

    @Override
    public void setProhibitedFromUpdateBelowRoleLevelUsingRoleUri(String roleUri) {
        this.innerObjectProperty.setProhibitedFromUpdateBelowRoleLevel(BaseResourceBean.RoleLevel.getRoleByUri(roleUri));
    }

    @Override
    public void setHiddenFromPublishBelowRoleLevel(BaseResourceBean.RoleLevel eR) {
        this.innerObjectProperty.setHiddenFromPublishBelowRoleLevel(eR);
    }

    @Override
    public void setHiddenFromPublishBelowRoleLevelUsingRoleUri(String roleUri) {
        this.innerObjectProperty.setHiddenFromPublishBelowRoleLevel(BaseResourceBean.RoleLevel.getRoleByUri(roleUri));
    }

    @Override
    public void setInverseFunctional(boolean inverseFunctional) {
        this.innerObjectProperty.setInverseFunctional(inverseFunctional);
    }

    @Override
    public void setLocalName(String localName) {
        this.innerObjectProperty.setLocalName(localName);
    }

    @Override
    public void setLocalNameInverse(String localNameInverse) {
        this.innerObjectProperty.setLocalNameInverse(localNameInverse);
    }

    @Override
    public void setLocalNameWithPrefix(String localNameWithPrefix) {
        this.innerObjectProperty.setLocalNameWithPrefix(localNameWithPrefix);
    }

    @Override
    public void setPickListName(String pickListName) {
        this.innerObjectProperty.setPickListName(pickListName);
    }

    @Override
    public void setNamespace(String namespace) {
        this.innerObjectProperty.setNamespace(namespace);
    }

    @Override
    public void setNamespaceInverse(String namespaceInverse) {
        this.innerObjectProperty.setNamespaceInverse(namespaceInverse);
    }

    @Override
    public void setObjectIndividualSortPropertyURI(String objectIndividualSortPropertyURI) {
        this.innerObjectProperty.setObjectIndividualSortPropertyURI(objectIndividualSortPropertyURI);
    }

    @Override
    public void setObjectPropertyStatements(List<ObjectPropertyStatement> objectPropertyStatements) {
        this.innerObjectProperty.setObjectPropertyStatements(objectPropertyStatements);
    }

    @Override
    public void setOfferCreateNewOption(boolean b) {
        this.innerObjectProperty.setOfferCreateNewOption(b);
    }

    @Override
    public void setParentURI(String parentURI) {
        this.innerObjectProperty.setParentURI(parentURI);
    }

    @Override
    public void setPublicDescription(String s) {
        this.innerObjectProperty.setPublicDescription(s);
    }

    @Override
    public void setRangeDisplayLimit(int rangeDisplayLimit) {
        this.innerObjectProperty.setRangeDisplayLimit(rangeDisplayLimit);
    }

    @Override
    public void setRangeDisplayTier(Integer rangeDisplayTier) {
        this.innerObjectProperty.setRangeDisplayTier(rangeDisplayTier);
    }

    @Override
    public void setRangeEntitySortDirection(String rangeEntitySortDirection) {
        this.innerObjectProperty.setRangeEntitySortDirection(rangeEntitySortDirection);
    }

    @Override
    public void setRangeEntityURI(String rangeEntityURI) {
        this.innerObjectProperty.setRangeEntityURI(rangeEntityURI);
    }

    @Override
    public void setRangePublic(String rangePublic) {
        this.innerObjectProperty.setRangePublic(rangePublic);
    }

    @Override
    public void setRangeVClass(VClass rangeVClass) {
        this.innerObjectProperty.setRangeVClass(rangeVClass);
    }

    @Override
    public void setRangeVClassURI(String rangeClassURI) {
        this.innerObjectProperty.setRangeVClassURI(rangeClassURI);
    }

    @Override
    public void setSelectFromExisting(boolean b) {
        this.innerObjectProperty.setSelectFromExisting(b);
    }

    @Override
    public void setSymmetric(boolean symmetric) {
        this.innerObjectProperty.setSymmetric(symmetric);
    }

    @Override
    public void setTransitive(boolean transitive) {
        this.innerObjectProperty.setTransitive(transitive);
    }

    @Override
    public void setURI(String URI2) {
        this.innerObjectProperty.setURI(URI2);
    }

    @Override
    public void setURIInverse(String URIInverse) {
        this.innerObjectProperty.setURIInverse(URIInverse);
    }

    @Override
    public String toString() {
        return this.innerObjectProperty.toString();
    }

    @Override
    public void xmlToSysOut() {
        this.innerObjectProperty.xmlToSysOut();
    }

    @Override
    public boolean getStubObjectRelation() {
        return this.innerObjectProperty.getStubObjectRelation();
    }

    @Override
    public void setStubObjectRelation(boolean b) {
        this.innerObjectProperty.setStubObjectRelation(b);
    }

    @Override
    public boolean getCollateBySubclass() {
        return this.innerObjectProperty.getCollateBySubclass();
    }

    @Override
    public void setCollateBySubclass(boolean collate) {
        this.innerObjectProperty.setCollateBySubclass(collate);
    }

    @Override
    public boolean isEditLinkSuppressed() {
        return this.innerObjectProperty.isEditLinkSuppressed();
    }

    @Override
    public boolean isAddLinkSuppressed() {
        return this.innerObjectProperty.isAddLinkSuppressed();
    }

    @Override
    public boolean isDeleteLinkSuppressed() {
        return this.innerObjectProperty.isDeleteLinkSuppressed();
    }

    @Override
    public void setEditLinkSuppressed(boolean editLinkSuppressed) {
        this.innerObjectProperty.setEditLinkSuppressed(editLinkSuppressed);
    }

    @Override
    public void setAddLinkSuppressed(boolean addLinkSuppressed) {
        this.innerObjectProperty.setAddLinkSuppressed(addLinkSuppressed);
    }

    @Override
    public void setDeleteLinkSuppressed(boolean deleteLinkSuppressed) {
        this.innerObjectProperty.setDeleteLinkSuppressed(deleteLinkSuppressed);
    }
}

