/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.filtering;

import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.BaseFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFilters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DataPropertyDaoFiltering
extends BaseFiltering
implements DataPropertyDao {
    final DataPropertyDao innerDataPropertyDao;
    final VitroFilters filters;

    public DataPropertyDaoFiltering(DataPropertyDao dataPropertyDao, VitroFilters filters) {
        this.innerDataPropertyDao = dataPropertyDao;
        this.filters = filters;
    }

    @Override
    public void fillDataPropertiesForIndividual(Individual individual) {
        this.innerDataPropertyDao.fillDataPropertiesForIndividual(individual);
        List<DataProperty> props = individual.getDataPropertyList();
        if (props != null && props.size() > 0) {
            individual.setDatatypePropertyList(this.filter(props, this.filters.getDataPropertyFilter()));
        }
    }

    @Override
    public List<DataProperty> getAllDataProperties() {
        return this.filter(this.innerDataPropertyDao.getAllDataProperties(), this.filters.getDataPropertyFilter());
    }

    @Override
    public List<DataProperty> getAllExternalIdDataProperties() {
        return this.filter(this.innerDataPropertyDao.getAllDataProperties(), this.filters.getDataPropertyFilter());
    }

    @Override
    public List<DataProperty> getDataPropertiesForVClass(String classURI) {
        return this.filter(this.innerDataPropertyDao.getDataPropertiesForVClass(classURI), this.filters.getDataPropertyFilter());
    }

    @Override
    public Collection<DataProperty> getAllPossibleDatapropsForIndividual(String individualURI) {
        ArrayList<DataProperty> filteredProps = new ArrayList<DataProperty>();
        for (DataProperty dp : this.innerDataPropertyDao.getAllPossibleDatapropsForIndividual(individualURI)) {
            DataPropertyStatementImpl dps = new DataPropertyStatementImpl(individualURI, dp.getURI(), RequestedAction.SOME_LITERAL);
            if (!((Boolean)this.filters.getDataPropertyStatementFilter().fn((Object)dps)).booleanValue()) continue;
            filteredProps.add(dp);
        }
        return filteredProps;
    }

    @Override
    public void deleteDataProperty(DataProperty dataProperty) {
        this.innerDataPropertyDao.deleteDataProperty(dataProperty);
    }

    @Override
    public void deleteDataProperty(String dataPropertyURI) {
        this.innerDataPropertyDao.deleteDataProperty(dataPropertyURI);
    }

    @Override
    public boolean annotateDataPropertyAsExternalIdentifier(String dataPropertyURI) {
        return this.innerDataPropertyDao.annotateDataPropertyAsExternalIdentifier(dataPropertyURI);
    }

    @Override
    public String getRequiredDatatypeURI(Individual individual, DataProperty dataProperty) {
        return this.innerDataPropertyDao.getRequiredDatatypeURI(individual, dataProperty);
    }

    @Override
    public DataProperty getDataPropertyByURI(String dataPropertyURI) {
        return this.innerDataPropertyDao.getDataPropertyByURI(dataPropertyURI);
    }

    @Override
    public String insertDataProperty(DataProperty dataProperty) throws InsertException {
        return this.innerDataPropertyDao.insertDataProperty(dataProperty);
    }

    @Override
    public void updateDataProperty(DataProperty dataProperty) {
        this.innerDataPropertyDao.updateDataProperty(dataProperty);
    }

    @Override
    public void addSuperproperty(String propertyURI, String superpropertyURI) {
        this.innerDataPropertyDao.addSuperproperty(propertyURI, superpropertyURI);
    }

    @Override
    public void removeSuperproperty(String propertyURI, String superpropertyURI) {
        this.innerDataPropertyDao.removeSuperproperty(propertyURI, superpropertyURI);
    }

    @Override
    public void addSubproperty(String propertyURI, String subpropertyURI) {
        this.innerDataPropertyDao.addSubproperty(propertyURI, subpropertyURI);
    }

    @Override
    public void removeSubproperty(String propertyURI, String subpropertyURI) {
        this.innerDataPropertyDao.removeSubproperty(propertyURI, subpropertyURI);
    }

    @Override
    public List<String> getSubPropertyURIs(String propertyURI) {
        return this.innerDataPropertyDao.getSubPropertyURIs(propertyURI);
    }

    @Override
    public List<String> getAllSubPropertyURIs(String propertyURI) {
        return this.innerDataPropertyDao.getAllSubPropertyURIs(propertyURI);
    }

    @Override
    public List<String> getSuperPropertyURIs(String propertyURI, boolean direct) {
        return this.innerDataPropertyDao.getSuperPropertyURIs(propertyURI, direct);
    }

    @Override
    public List<String> getAllSuperPropertyURIs(String propertyURI) {
        return this.innerDataPropertyDao.getAllSuperPropertyURIs(propertyURI);
    }

    @Override
    public List<DataProperty> getRootDataProperties() {
        return this.innerDataPropertyDao.getRootDataProperties();
    }

    @Override
    public void addSubproperty(Property property, Property subproperty) {
        this.innerDataPropertyDao.addSubproperty(property, subproperty);
    }

    @Override
    public void addSuperproperty(Property property, Property superproperty) {
        this.innerDataPropertyDao.addSuperproperty(property, superproperty);
    }

    @Override
    public void removeSubproperty(Property property, Property subproperty) {
        this.innerDataPropertyDao.removeSubproperty(property, subproperty);
    }

    @Override
    public void removeSuperproperty(Property property, Property superproperty) {
        this.innerDataPropertyDao.removeSuperproperty(property, superproperty);
    }

    @Override
    public void addEquivalentProperty(String propertyURI, String equivalentPropertyURI) {
        this.innerDataPropertyDao.addEquivalentProperty(propertyURI, equivalentPropertyURI);
    }

    @Override
    public void addEquivalentProperty(Property property, Property equivalentProperty) {
        this.innerDataPropertyDao.addEquivalentProperty(property, equivalentProperty);
    }

    @Override
    public List<String> getEquivalentPropertyURIs(String propertyURI) {
        return this.innerDataPropertyDao.getEquivalentPropertyURIs(propertyURI);
    }

    @Override
    public void removeEquivalentProperty(String propertyURI, String equivalentPropertyURI) {
        this.innerDataPropertyDao.removeEquivalentProperty(propertyURI, equivalentPropertyURI);
    }

    @Override
    public void removeEquivalentProperty(Property property, Property equivalentProperty) {
        this.innerDataPropertyDao.removeEquivalentProperty(property, equivalentProperty);
    }

    @Override
    public List<VClass> getClassesWithRestrictionOnProperty(String propertyURI) {
        return this.innerDataPropertyDao.getClassesWithRestrictionOnProperty(propertyURI);
    }

    @Override
    public List<DataProperty> getDataPropertyList(Individual subject) {
        return this.innerDataPropertyDao.getDataPropertyList(subject);
    }

    @Override
    public List<DataProperty> getDataPropertyList(String subjectUri) {
        return this.innerDataPropertyDao.getDataPropertyList(subjectUri);
    }

    @Override
    public String getCustomListViewConfigFileName(DataProperty dataProperty) {
        return this.innerDataPropertyDao.getCustomListViewConfigFileName(dataProperty);
    }
}

