/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JsonProducer {
    private static final Log log = LogFactory.getLog(JsonProducer.class);

    protected ArrayNode individualsToJson(List<Individual> individuals) throws ServletException {
        ArrayNode ja = JsonNodeFactory.instance.arrayNode();
        for (Individual ent : individuals) {
            ObjectNode entJ = JsonNodeFactory.instance.objectNode();
            entJ.put("name", ent.getName());
            entJ.put("URI", ent.getURI());
            ja.add((JsonNode)entJ);
        }
        return ja;
    }

    protected VClass getVclassParameter(VitroRequest vreq) {
        String vclassId = vreq.getParameter("vclassId");
        if (StringUtils.isEmpty((CharSequence)vclassId)) {
            log.error((Object)"parameter vclassId expected but not found");
            throw new IllegalStateException("parameter vclassId expected ");
        }
        return this.instantiateVclass(vclassId, vreq);
    }

    protected List<String> getVclassIds(VitroRequest vreq) {
        String[] vclassIds = vreq.getParameterValues("vclassId");
        if (vclassIds == null || vclassIds.length == 0) {
            log.error((Object)"parameter vclassId expected but not found");
            throw new IllegalStateException("parameter vclassId expected ");
        }
        for (String vclassId : vclassIds) {
            this.instantiateVclass(vclassId, vreq);
        }
        return Arrays.asList(vclassIds);
    }

    private VClass instantiateVclass(String uri, VitroRequest vreq) {
        VClass vclass = vreq.getWebappDaoFactory().getVClassDao().getVClassByURI(uri);
        if (vclass == null) {
            log.error((Object)("Couldn't retrieve vclass '" + uri + "'"));
            throw new IllegalStateException("Class " + uri + " not found");
        }
        return vclass;
    }
}

