/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.individuallist;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.Controllers;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.IndividualListController;
import edu.cornell.mannlib.vitro.webapp.controller.individuallist.IndividualJsonWrapper;
import edu.cornell.mannlib.vitro.webapp.controller.individuallist.IndividualListResults;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndividualListResultsUtils {
    private static final Log log = LogFactory.getLog(IndividualListResultsUtils.class);

    public static ObjectNode wrapIndividualListResultsInJson(IndividualListResults results, VitroRequest vreq, boolean multipleVclasses) {
        ObjectNode rObj = JsonNodeFactory.instance.objectNode();
        if (log.isDebugEnabled()) {
            IndividualListResultsUtils.dumpParametersFromRequest(vreq);
        }
        try {
            List<VClass> vclasses = IndividualListResultsUtils.buildListOfRequestedVClasses(vreq);
            VClass vclass = null;
            vclass = !multipleVclasses ? vclasses.get(0) : vclasses.get(vclasses.size() - 1);
            rObj.put("vclass", (JsonNode)IndividualListResultsUtils.packageVClassAsJson(vclass));
            rObj.put("totalCount", results.getTotalCount());
            rObj.put("alpha", results.getAlpha());
            rObj.put("individuals", (JsonNode)IndividualListResultsUtils.packageIndividualsAsJson(vreq, results.getEntities()));
            rObj.put("pages", (JsonNode)IndividualListResultsUtils.packagePageRecordsAsJson(results.getPages()));
            rObj.put("letters", (JsonNode)IndividualListResultsUtils.packageLettersAsJson());
        }
        catch (Exception ex) {
            log.error((Object)"Error occurred in processing JSON object", (Throwable)ex);
        }
        return rObj;
    }

    private static List<VClass> buildListOfRequestedVClasses(VitroRequest vreq) throws Exception {
        Object[] vitroClassIdStr = vreq.getParameterValues("vclassId");
        if (ArrayUtils.isEmpty((Object[])vitroClassIdStr)) {
            log.error((Object)"parameter vclassId URI parameter expected ");
            throw new Exception("parameter vclassId URI parameter expected ");
        }
        ArrayList<VClass> list = new ArrayList<VClass>();
        for (Object vclassId : vitroClassIdStr) {
            VClass vclass = vreq.getWebappDaoFactory().getVClassDao().getVClassByURI((String)vclassId);
            if (vclass == null) {
                log.error((Object)"Couldn't retrieve vclass ");
                throw new Exception("Class " + (String)vclassId + " not found");
            }
            list.add(vclass);
        }
        return list;
    }

    private static ObjectNode packageVClassAsJson(VClass vclass) {
        ObjectNode jvclass = JsonNodeFactory.instance.objectNode();
        jvclass.put("URI", vclass.getURI());
        jvclass.put("name", vclass.getName());
        return jvclass;
    }

    private static ArrayNode packageLettersAsJson() throws UnsupportedEncodingException {
        List<String> letters = Controllers.getLetters();
        ArrayNode jletters = JsonNodeFactory.instance.arrayNode();
        for (String s : letters) {
            ObjectNode jo = JsonNodeFactory.instance.objectNode();
            jo.put("text", s);
            jo.put("param", "alpha=" + URLEncoder.encode(s, "UTF-8"));
            jletters.add((JsonNode)jo);
        }
        return jletters;
    }

    private static ArrayNode packagePageRecordsAsJson(List<IndividualListController.PageRecord> pages) {
        ArrayNode wpages = JsonNodeFactory.instance.arrayNode();
        for (IndividualListController.PageRecord pr : pages) {
            ObjectNode p = JsonNodeFactory.instance.objectNode();
            p.put("text", pr.text);
            p.put("param", pr.param);
            p.put("index", pr.index);
            wpages.add((JsonNode)p);
        }
        return wpages;
    }

    private static ArrayNode packageIndividualsAsJson(VitroRequest vreq, List<Individual> inds) {
        log.debug((Object)("Number of individuals returned from request: " + inds.size()));
        ArrayNode jInds = JsonNodeFactory.instance.arrayNode();
        for (Individual ind : inds) {
            jInds.add((JsonNode)IndividualJsonWrapper.packageIndividualAsJson(vreq, ind));
        }
        return jInds;
    }

    private static void dumpParametersFromRequest(VitroRequest vreq) {
        Map<String, String[]> pMap = vreq.getParameterMap();
        for (String name : pMap.keySet()) {
            for (String value : pMap.get(name)) {
                log.debug((Object)("value for " + name + ": '" + value + "'"));
            }
        }
    }
}

