/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.individual;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.SelfEditingConfiguration;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualRequestAnalysisContext;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.filestorage.model.FileInfo;
import java.util.List;
import javax.servlet.ServletRequest;

public class IndividualRequestAnalysisContextImpl
implements IndividualRequestAnalysisContext {
    private final VitroRequest vreq;
    private final WebappDaoFactory wadf;
    private final IndividualDao iDao;

    public IndividualRequestAnalysisContextImpl(VitroRequest vreq) {
        this.vreq = vreq;
        this.wadf = vreq.getWebappDaoFactory();
        this.iDao = this.wadf.getIndividualDao();
    }

    @Override
    public String getDefaultNamespace() {
        return this.wadf.getDefaultNamespace();
    }

    @Override
    public Individual getIndividualByURI(String individualUri) {
        if (individualUri == null) {
            return null;
        }
        return this.iDao.getIndividualByURI(individualUri);
    }

    @Override
    public Individual getIndividualByNetId(String netId) {
        if (netId == null) {
            return null;
        }
        SelfEditingConfiguration sec = SelfEditingConfiguration.getBean((ServletRequest)this.vreq);
        List<Individual> assocInds = sec.getAssociatedIndividuals(this.iDao, netId);
        if (!assocInds.isEmpty()) {
            return assocInds.get(0);
        }
        return null;
    }

    @Override
    public String getAliasUrlForBytestreamIndividual(Individual individual) {
        if (individual == null) {
            return null;
        }
        FileInfo fileInfo = FileInfo.instanceFromBytestreamUri(this.wadf, individual.getURI());
        if (fileInfo == null) {
            return null;
        }
        return fileInfo.getBytestreamAliasUrl();
    }
}

