/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.FauxProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.FauxPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyGroupDao;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.annotation.WebServlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="ListFauxPropertiesController", urlPatterns={"/listFauxProperties"})
public class ListFauxPropertiesController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog((String)ListFauxPropertiesController.class.getName());
    private static final String TEMPLATE_NAME = "siteAdmin-fauxPropertiesList.ftl";
    private String notFoundMessage = "";

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.EDIT_ONTOLOGY.ACTION;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        try {
            String displayOption = "";
            displayOption = vreq.getParameter("displayOption") != null ? vreq.getParameter("displayOption") : "listing";
            body.put("displayOption", displayOption);
            if (displayOption.equals("listing")) {
                body.put("pageTitle", "Faux Property Listing");
            } else {
                body.put("pageTitle", "Faux Properties by Base Property");
            }
            List<ObjectProperty> objectProps = this.getOPDao(vreq).getRootObjectProperties();
            List<DataProperty> dataProps = this.getDPDao(vreq).getRootDataProperties();
            TreeMap<String, Object> allFauxProps = new TreeMap<String, Object>();
            if (displayOption.equals("listing")) {
                allFauxProps.putAll(this.getFauxPropertyList(objectProps, vreq));
                allFauxProps.putAll(this.getFauxDataPropertyList(dataProps, vreq));
            } else {
                allFauxProps.putAll(this.getFauxByBaseList(objectProps, vreq));
                allFauxProps.putAll(this.getFauxDataPropsByBaseList(dataProps, vreq));
            }
            log.debug((Object)((Object)allFauxProps).toString());
            if (this.notFoundMessage.length() == 0) {
                body.put("message", this.notFoundMessage);
            } else {
                body.put("fauxProps", allFauxProps);
            }
        }
        catch (Throwable t) {
            log.error((Object)t, t);
        }
        return new TemplateResponseValues(TEMPLATE_NAME, body);
    }

    private PropertyGroupDao getPGDao(VitroRequest vreq) {
        return vreq.getUnfilteredAssertionsWebappDaoFactory().getPropertyGroupDao();
    }

    private FauxPropertyDao getFPDao(VitroRequest vreq) {
        return vreq.getUnfilteredAssertionsWebappDaoFactory().getFauxPropertyDao();
    }

    private DataPropertyDao getDPDao(VitroRequest vreq) {
        return vreq.getUnfilteredAssertionsWebappDaoFactory().getDataPropertyDao();
    }

    private ObjectPropertyDao getOPDao(VitroRequest vreq) {
        return vreq.getUnfilteredAssertionsWebappDaoFactory().getObjectPropertyDao();
    }

    private TreeMap<String, Object> getFauxPropertyList(List<ObjectProperty> objectProps, VitroRequest vreq) {
        List<FauxProperty> fauxProps = null;
        TreeMap<String, Object> theFauxProps = new TreeMap<String, Object>();
        if (objectProps != null) {
            Iterator<ObjectProperty> opIt = objectProps.iterator();
            if (!opIt.hasNext()) {
                this.notFoundMessage = "No object properties found.";
            } else {
                while (opIt.hasNext()) {
                    ObjectProperty op = opIt.next();
                    String baseURI = op.getURI();
                    fauxProps = this.getFPDao(vreq).getFauxPropertiesForBaseUri(baseURI);
                    if (fauxProps == null) continue;
                    Iterator<FauxProperty> fpIt = fauxProps.iterator();
                    if (!fpIt.hasNext()) {
                        this.notFoundMessage = "No faux properties found.";
                        continue;
                    }
                    while (fpIt.hasNext()) {
                        String baseLabel = this.getBaseLabel(op, false);
                        FauxProperty fp = fpIt.next();
                        String fauxLabel = fp.getDisplayName();
                        String rangeLabel = fp.getRangeLabel();
                        String rangeURI = fp.getRangeURI();
                        String domainLabel = fp.getDomainLabel();
                        String domainURI = fp.getDomainURI();
                        String groupURI = fp.getGroupURI();
                        PropertyGroup pGroup = this.getPGDao(vreq).getGroupByURI(groupURI);
                        String groupLabel = pGroup == null ? "unspecified" : pGroup.getName();
                        HashMap<String, String> tmpHash = new HashMap<String, String>();
                        tmpHash.put("base", baseLabel);
                        tmpHash.put("baseURI", baseURI);
                        tmpHash.put("group", groupLabel);
                        tmpHash.put("range", rangeLabel);
                        tmpHash.put("rangeURI", rangeURI);
                        tmpHash.put("domain", domainLabel);
                        tmpHash.put("domainURI", domainURI);
                        tmpHash.put("editUrl", "propertyEdit");
                        theFauxProps.put(fauxLabel + "@@" + domainLabel, tmpHash);
                    }
                }
            }
        }
        return theFauxProps;
    }

    private TreeMap<String, Object> getFauxByBaseList(List<ObjectProperty> objectProps, VitroRequest vreq) {
        List<FauxProperty> fauxProps = null;
        TreeMap<String, Object> fauxByBaseProps = new TreeMap<String, Object>();
        if (objectProps != null) {
            Iterator<ObjectProperty> opIt = objectProps.iterator();
            if (!opIt.hasNext()) {
                this.notFoundMessage = "No object properties found.";
            } else {
                while (opIt.hasNext()) {
                    TreeMap<String, Object> fauxForGivenBase = new TreeMap<String, Object>();
                    ObjectProperty op = opIt.next();
                    String baseURI = op.getURI();
                    fauxProps = this.getFPDao(vreq).getFauxPropertiesForBaseUri(baseURI);
                    if (fauxProps == null) continue;
                    Iterator<FauxProperty> fpIt = fauxProps.iterator();
                    if (!fpIt.hasNext()) {
                        this.notFoundMessage = "No faux properties found.";
                        continue;
                    }
                    String baseLabel = this.getBaseLabel(op, true);
                    while (fpIt.hasNext()) {
                        FauxProperty fp = fpIt.next();
                        String fauxLabel = fp.getDisplayName();
                        String rangeLabel = fp.getRangeLabel();
                        String rangeURI = fp.getRangeURI();
                        String domainLabel = fp.getDomainLabel();
                        String domainURI = fp.getDomainURI();
                        String groupURI = fp.getGroupURI();
                        PropertyGroup pGroup = this.getPGDao(vreq).getGroupByURI(groupURI);
                        String groupLabel = pGroup == null ? "unspecified" : pGroup.getName();
                        HashMap<String, String> tmpHash = new HashMap<String, String>();
                        tmpHash.put("baseURI", baseURI);
                        tmpHash.put("group", groupLabel);
                        tmpHash.put("range", rangeLabel);
                        tmpHash.put("rangeURI", rangeURI);
                        tmpHash.put("domain", domainLabel);
                        tmpHash.put("domainURI", domainURI);
                        fauxForGivenBase.put(fauxLabel + "@@" + domainLabel, tmpHash);
                        fauxForGivenBase.put("editUrl", "propertyEdit");
                    }
                    fauxByBaseProps.put(baseLabel, fauxForGivenBase);
                }
            }
        }
        return fauxByBaseProps;
    }

    private TreeMap<String, Object> getFauxDataPropertyList(List<DataProperty> dataProps, VitroRequest vreq) {
        List<FauxProperty> fauxProps = null;
        TreeMap<String, Object> theFauxProps = new TreeMap<String, Object>();
        if (dataProps != null) {
            Iterator<DataProperty> opIt = dataProps.iterator();
            if (!opIt.hasNext()) {
                this.notFoundMessage = "No data properties found.";
            } else {
                while (opIt.hasNext()) {
                    DataProperty dp = opIt.next();
                    String baseURI = dp.getURI();
                    fauxProps = this.getFPDao(vreq).getFauxPropertiesForBaseUri(baseURI);
                    if (fauxProps == null) continue;
                    Iterator<FauxProperty> fpIt = fauxProps.iterator();
                    if (!fpIt.hasNext()) {
                        this.notFoundMessage = "No faux properties found.";
                        continue;
                    }
                    while (fpIt.hasNext()) {
                        String baseLabel = this.getBaseLabel(dp, false);
                        FauxProperty fp = fpIt.next();
                        String fauxLabel = fp.getDisplayName();
                        String rangeLabel = fp.getRangeLabel();
                        String rangeURI = fp.getRangeURI();
                        String domainLabel = fp.getDomainLabel();
                        String domainURI = fp.getDomainURI();
                        String groupURI = fp.getGroupURI();
                        PropertyGroup pGroup = this.getPGDao(vreq).getGroupByURI(groupURI);
                        String groupLabel = pGroup == null ? "unspecified" : pGroup.getName();
                        HashMap<String, String> tmpHash = new HashMap<String, String>();
                        tmpHash.put("base", baseLabel);
                        tmpHash.put("baseURI", baseURI);
                        tmpHash.put("group", groupLabel);
                        tmpHash.put("range", rangeLabel);
                        tmpHash.put("rangeURI", rangeURI);
                        tmpHash.put("domain", domainLabel);
                        tmpHash.put("domainURI", domainURI);
                        tmpHash.put("editUrl", "datapropEdit");
                        theFauxProps.put(fauxLabel + "@@" + domainLabel, tmpHash);
                    }
                }
            }
        }
        return theFauxProps;
    }

    private TreeMap<String, Object> getFauxDataPropsByBaseList(List<DataProperty> dataProps, VitroRequest vreq) {
        List<FauxProperty> fauxProps = null;
        TreeMap<String, Object> fauxByBaseProps = new TreeMap<String, Object>();
        if (dataProps != null) {
            Iterator<DataProperty> opIt = dataProps.iterator();
            if (!opIt.hasNext()) {
                this.notFoundMessage = "No data properties found.";
            } else {
                while (opIt.hasNext()) {
                    TreeMap<String, Object> fauxForGivenBase = new TreeMap<String, Object>();
                    DataProperty dp = opIt.next();
                    String baseURI = dp.getURI();
                    fauxProps = this.getFPDao(vreq).getFauxPropertiesForBaseUri(baseURI);
                    if (fauxProps == null) continue;
                    Iterator<FauxProperty> fpIt = fauxProps.iterator();
                    if (!fpIt.hasNext()) {
                        this.notFoundMessage = "No faux properties found.";
                        continue;
                    }
                    String baseLabel = this.getBaseLabel(dp, true);
                    while (fpIt.hasNext()) {
                        FauxProperty fp = fpIt.next();
                        String fauxLabel = fp.getDisplayName();
                        String rangeLabel = fp.getRangeLabel();
                        String rangeURI = fp.getRangeURI();
                        String domainLabel = fp.getDomainLabel();
                        String domainURI = fp.getDomainURI();
                        String groupURI = fp.getGroupURI();
                        PropertyGroup pGroup = this.getPGDao(vreq).getGroupByURI(groupURI);
                        String groupLabel = pGroup == null ? "unspecified" : pGroup.getName();
                        HashMap<String, String> tmpHash = new HashMap<String, String>();
                        tmpHash.put("baseURI", baseURI);
                        tmpHash.put("group", groupLabel);
                        tmpHash.put("range", rangeLabel);
                        tmpHash.put("rangeURI", rangeURI);
                        tmpHash.put("domain", domainLabel);
                        tmpHash.put("domainURI", domainURI);
                        fauxForGivenBase.put(fauxLabel + "@@" + domainLabel, tmpHash);
                        fauxForGivenBase.put("editUrl", "datapropEdit");
                    }
                    fauxByBaseProps.put(baseLabel, fauxForGivenBase);
                }
            }
        }
        return fauxByBaseProps;
    }

    private String getBaseLabel(Property property, boolean addUri) {
        String baseLabel = property.getPickListName();
        if (StringUtils.isEmpty((CharSequence)baseLabel)) {
            baseLabel = property.getLocalName();
        }
        if (StringUtils.isEmpty((CharSequence)baseLabel)) {
            baseLabel = "[property]";
        }
        String baseLocalName = property.getLocalNameWithPrefix();
        int indexOf = baseLabel.indexOf("(");
        if (indexOf > 0) {
            baseLabel = baseLabel.substring(0, indexOf);
        }
        baseLabel = baseLabel + "(" + baseLocalName + ")";
        if (addUri) {
            baseLabel = baseLabel + "|" + property.getURI();
        }
        return baseLabel;
    }
}

