/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.ImageUploadController;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.filestorage.TempFileHolder;
import edu.cornell.mannlib.vitro.webapp.filestorage.UploadedFileHelper;
import edu.cornell.mannlib.vitro.webapp.filestorage.model.FileInfo;
import edu.cornell.mannlib.vitro.webapp.modules.fileStorage.FileAlreadyExistsException;
import edu.cornell.mannlib.vitro.webapp.modules.fileStorage.FileStorage;
import edu.cornell.mannlib.vitro.webapp.modules.imageProcessor.ImageProcessor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageUploadHelper {
    private static final Log log = LogFactory.getLog(ImageUploadHelper.class);
    private static final String ERROR_CODE_NO_IMAGE_TO_CROP = "imageUpload.errorNoImageForCropping";
    private static final String ERROR_CODE_IMAGE_TOO_SMALL = "imageUpload.errorImageTooSmall";
    private static final String ERROR_CODE_UNKNOWN = "imageUpload.errorUnknown";
    private static final String ERROR_CODE_UNRECOGNIZED_FILE_TYPE = "imageUpload.errorUnrecognizedFileType";
    private static final String ERROR_CODE_NO_PHOTO_SELECTED = "imageUpload.errorNoPhotoSelected";
    private static final String ERROR_CODE_BAD_MULTIPART_REQUEST = "imageUpload.errorBadMultipartRequest";
    private static final String ERROR_CODE_FORM_FIELD_MISSING = "imageUpload.errorFormFieldMissing";
    public static final String ATTRIBUTE_TEMP_FILE = "ImageUploadHelper.tempFile";
    public static final int MAXIMUM_IMAGE_DISPLAY_WIDTH = 500;
    private static final Map<String, String> RECOGNIZED_FILE_TYPES = ImageUploadHelper.createFileTypesMap();
    private static final Map<String, String> NON_STANDARD_MIME_TYPES = ImageUploadHelper.createNonStandardMimeTypesMap();
    private final FileStorage fileStorage;
    private final UploadedFileHelper uploadedFileHelper;

    private static Map<String, String> createFileTypesMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(".gif", "image/gif");
        map.put(".png", "image/png");
        map.put(".jpg", "image/jpeg");
        map.put(".jpeg", "image/jpeg");
        map.put(".jpe", "image/jpeg");
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, String> createNonStandardMimeTypesMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("image/x-png", "image/png");
        map.put("image/pjpeg", "image/jpeg");
        return Collections.unmodifiableMap(map);
    }

    ImageUploadHelper(FileStorage fileStorage, WebappDaoFactory webAppDaoFactory, ServletContext ctx) {
        this.fileStorage = fileStorage;
        this.uploadedFileHelper = new UploadedFileHelper(fileStorage, webAppDaoFactory, ctx);
    }

    FileItem validateImageFromRequest(VitroRequest vreq) throws ImageUploadController.UserMistakeException {
        Map<String, List<FileItem>> map = vreq.getFiles();
        if (map == null) {
            throw new IllegalStateException(ERROR_CODE_BAD_MULTIPART_REQUEST);
        }
        List<FileItem> list = map.get("datafile");
        if (list == null || list.isEmpty()) {
            throw new ImageUploadController.UserMistakeException(ERROR_CODE_FORM_FIELD_MISSING, "datafile");
        }
        FileItem file = list.get(0);
        if (file.getSize() == 0L) {
            throw new ImageUploadController.UserMistakeException(ERROR_CODE_NO_PHOTO_SELECTED, new Object[0]);
        }
        String filename = this.getSimpleFilename(file);
        String mimeType = this.getMimeType(file);
        if (!RECOGNIZED_FILE_TYPES.containsValue(mimeType)) {
            log.debug((Object)("Unrecognized MIME type: '" + mimeType + "'"));
            throw new ImageUploadController.UserMistakeException(ERROR_CODE_UNRECOGNIZED_FILE_TYPE, filename);
        }
        return file;
    }

    FileInfo storeNewImage(FileItem fileItem, VitroRequest vreq) {
        InputStream inputStream = null;
        try {
            inputStream = fileItem.getInputStream();
            String mimeType = this.getMimeType(fileItem);
            String filename = this.getSimpleFilename(fileItem);
            FileInfo fileInfo = this.uploadedFileHelper.createFile(filename, mimeType, inputStream);
            TempFileHolder.attach(vreq.getSession(), ATTRIBUTE_TEMP_FILE, fileInfo);
            FileInfo fileInfo2 = fileInfo;
            return fileInfo2;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't create the new image file.", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    ImageProcessor.Dimensions getNewImageSize(FileInfo fileInfo) throws ImageUploadController.UserMistakeException {
        InputStream source = null;
        try {
            String uri = fileInfo.getBytestreamUri();
            String filename = fileInfo.getFilename();
            source = this.fileStorage.getInputStream(uri, filename);
            ImageProcessor.Dimensions size = ApplicationUtils.instance().getImageProcessor().getDimensions(source);
            log.debug((Object)("new image size is " + size));
            if (size.height < 200 || size.width < 200) {
                throw new ImageUploadController.UserMistakeException(ERROR_CODE_IMAGE_TOO_SMALL, 200, 200);
            }
            ImageProcessor.Dimensions dimensions = size;
            return dimensions;
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("File not found: " + fileInfo, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't read image file: " + fileInfo, e);
        }
        catch (ImageUploadController.UserMistakeException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn((Object)"Unexpected exception in image handling", (Throwable)e);
            throw new ImageUploadController.UserMistakeException(ERROR_CODE_UNKNOWN, new Object[0]);
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    FileInfo getNewImageInfo(VitroRequest vreq) throws ImageUploadController.UserMistakeException {
        FileInfo fileInfo = TempFileHolder.remove(vreq.getSession(), ATTRIBUTE_TEMP_FILE);
        if (fileInfo == null) {
            throw new ImageUploadController.UserMistakeException(ERROR_CODE_NO_IMAGE_TO_CROP, new Object[0]);
        }
        return fileInfo;
    }

    FileInfo generateThumbnail(ImageProcessor.CropRectangle crop, FileInfo newImage) {
        InputStream mainStream = null;
        InputStream thumbStream = null;
        try {
            String mainBytestreamUri = newImage.getBytestreamUri();
            String mainFilename = newImage.getFilename();
            mainStream = this.fileStorage.getInputStream(mainBytestreamUri, mainFilename);
            thumbStream = ApplicationUtils.instance().getImageProcessor().cropAndScale(mainStream, crop, new ImageProcessor.Dimensions(200, 200));
            String mimeType = RECOGNIZED_FILE_TYPES.get(".jpg");
            String filename = this.createThumbnailFilename(mainFilename);
            FileInfo fileInfo = this.uploadedFileHelper.createFile(filename, mimeType, thumbStream);
            log.debug((Object)("Created thumbnail: " + fileInfo));
            FileInfo fileInfo2 = fileInfo;
            return fileInfo2;
        }
        catch (FileAlreadyExistsException e) {
            throw new IllegalStateException("Can't create the thumbnail file: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't create the thumbnail file", e);
        }
        catch (ImageProcessor.ImageProcessorException e) {
            throw new IllegalStateException("Failed to scale the image", e);
        }
        finally {
            if (mainStream != null) {
                try {
                    mainStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (thumbStream != null) {
                try {
                    thumbStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    void removeExistingImage(Individual person) {
        this.uploadedFileHelper.removeMainImage(person);
    }

    void storeImageFiles(Individual entity, FileInfo newImage, FileInfo thumbnail) {
        this.uploadedFileHelper.setImagesOnEntity(entity.getURI(), newImage, thumbnail);
    }

    private String getSimpleFilename(FileItem item) {
        String fileName = item.getName();
        if (fileName == null) {
            return null;
        }
        return FilenameUtils.getName((String)fileName);
    }

    private String getMimeType(FileItem file) {
        String mimeType = file.getContentType();
        if (mimeType != null) {
            if (NON_STANDARD_MIME_TYPES.containsKey(mimeType)) {
                mimeType = NON_STANDARD_MIME_TYPES.get(mimeType);
            }
            return mimeType;
        }
        String filename = this.getSimpleFilename(file);
        int periodHere = filename.lastIndexOf(46);
        if (periodHere == -1) {
            return null;
        }
        String extension = filename.substring(periodHere);
        return RECOGNIZED_FILE_TYPES.get(extension);
    }

    private String createThumbnailFilename(String filename) {
        String prefix = "thumbnail_";
        String extension = ".jpg";
        int periodHere = filename.lastIndexOf(46);
        if (periodHere == -1) {
            return prefix + filename + extension;
        }
        return prefix + filename.substring(0, periodHere) + extension;
    }
}

