/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit.listing.jena;

import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.util.iterator.ExtendedIterator;

@WebServlet(name="NamespacesListingController", urlPatterns={"/listNamespaces"})
public class NamespacesListingController
extends BaseEditController {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.USE_MISCELLANEOUS_ADMIN_PAGES.ACTION)) {
            return;
        }
        VitroRequest vrequest = new VitroRequest(request);
        OntModel ontModel = ModelAccess.on((HttpServletRequest)vrequest).getOntModel(new ModelAccess.LanguageOption[0]);
        ArrayList<String> results = new ArrayList<String>();
        request.setAttribute("results", results);
        results.add("XX");
        results.add("namespace");
        results.add("prefix");
        Property namespaceURIProp = ontModel.getProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#namespaceURI");
        ontModel.enterCriticalSection(true);
        try (ExtendedIterator closeIt = ontModel.listIndividuals(ontModel.getResource("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#Namespace"));){
            ExtendedIterator namespaceIt = closeIt;
            while (namespaceIt.hasNext()) {
                Individual prefixMappingInd;
                RDFNode prefixNode;
                Individual namespaceInd = (Individual)namespaceIt.next();
                String namespaceURI = "";
                try {
                    namespaceURI = ((Literal)namespaceInd.getPropertyValue(namespaceURIProp)).getLexicalForm();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                results.add("XX");
                results.add(namespaceURI);
                RDFNode prefixMapping = namespaceInd.getPropertyValue(ontModel.getProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#hasPrefixMapping"));
                boolean prefixFound = false;
                if (prefixMapping != null && prefixMapping.canAs(Individual.class) && (prefixNode = (prefixMappingInd = (Individual)prefixMapping.as(Individual.class)).getPropertyValue(ontModel.getProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#namespacePrefix"))) != null && prefixNode.isLiteral()) {
                    prefixFound = true;
                    try {
                        results.add("<a href=\"editForm?controller=NamespacePrefix&amp;prefix=" + ((Literal)prefixNode).getLexicalForm() + "&amp;namespace=" + URLEncoder.encode(namespaceURI, "UTF-8") + "\">" + ((Literal)prefixNode).getLexicalForm() + "</a>");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (prefixFound) continue;
                try {
                    results.add("<a href=\"editForm?controller=NamespacePrefix&amp;namespace=" + URLEncoder.encode(namespaceURI, "UTF-8") + "\">add prefix</a>");
                }
                catch (Exception exception) {}
            }
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        request.setAttribute("columncount", (Object)new Integer(3));
        request.setAttribute("suppressquery", (Object)"true");
        request.setAttribute("title", (Object)"Recognized Namespaces");
        try {
            JSPPageHandler.renderBasicPage(request, response, "/templates/edit/fetch/horizontal.jsp");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

