/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.beans.Option;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vedit.util.FormUtils;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.ApplicationBean;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyInstance;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyInstanceDao;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="EntityEditController", urlPatterns={"/entityEdit"})
public class EntityEditController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)EntityEditController.class.getName());

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        Individual inferredEnt;
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.DO_BACK_END_EDITING.ACTION)) {
            return;
        }
        String entURI = request.getParameter("uri");
        VitroRequest vreq = new VitroRequest(request);
        ApplicationBean application = vreq.getAppBean();
        Individual ent = vreq.getUnfilteredAssertionsWebappDaoFactory().getIndividualDao().getIndividualByURI(entURI);
        if (ent == null) {
            try {
                request.setAttribute("title", (Object)"Individual Not Found");
                request.setAttribute("css", (Object)("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + application.getThemeDir() + "css/edit.css\"/>"));
                JSPPageHandler.renderBasicPage(request, response, "/jenaIngest/notfound.jsp");
            }
            catch (Exception e) {
                log.error((Object)"EntityEditController could not forward to view.");
                log.error((Object)e.getMessage());
                log.error((Object)e.getStackTrace());
            }
        }
        if ((inferredEnt = vreq.getUnfilteredWebappDaoFactory().getIndividualDao().getIndividualByURI(entURI)) == null) {
            inferredEnt = new IndividualImpl(entURI);
        }
        request.setAttribute("entity", (Object)ent);
        ArrayList<String> results = new ArrayList<String>();
        int colCount = 4;
        results.add("Name");
        results.add("class");
        results.add("display level");
        results.add("edit level");
        results.add("last updated");
        ++colCount;
        results.add("URI");
        ++colCount;
        results.add("publish level");
        ++colCount;
        String rName = null;
        rName = ent.getName() != null && ent.getName().length() > 0 ? ent.getName() : (ent.getLocalName() != null && ent.getLocalName().length() > 0 ? ent.getLocalName() : (ent.isAnonymous() ? "[anonymous resource]" : "[resource]"));
        results.add(rName);
        StringBuilder classStr = new StringBuilder();
        List<VClass> classList = inferredEnt.getVClasses(false);
        this.sortForPickList(classList, vreq);
        if (classList != null) {
            Iterator<VClass> classIt = classList.iterator();
            while (classIt.hasNext()) {
                VClass vc = classIt.next();
                String rClassName = "";
                try {
                    rClassName = "<a href=\"vclassEdit?uri=" + URLEncoder.encode(vc.getURI(), "UTF-8") + "\">" + vc.getPickListName() + "</a>";
                }
                catch (Exception e) {
                    rClassName = vc.getLocalNameWithPrefix();
                }
                classStr.append(rClassName);
                if (!classIt.hasNext()) continue;
                classStr.append(", ");
            }
        }
        results.add(classStr.toString());
        results.add(ent.getHiddenFromDisplayBelowRoleLevel() == null ? "unspecified" : ent.getHiddenFromDisplayBelowRoleLevel().getDisplayLabel());
        results.add(ent.getProhibitedFromUpdateBelowRoleLevel() == null ? "unspecified" : ent.getProhibitedFromUpdateBelowRoleLevel().getUpdateLabel());
        String rModTime = ent.getModTime() == null ? "" : publicDateFormat.format(ent.getModTime());
        results.add(rModTime);
        results.add(ent.getURI() == null ? "[anonymous individual]" : ent.getURI());
        results.add(ent.getHiddenFromPublishBelowRoleLevel() == null ? "unspecified" : ent.getHiddenFromPublishBelowRoleLevel().getDisplayLabel());
        request.setAttribute("results", results);
        request.setAttribute("columncount", (Object)colCount);
        request.setAttribute("suppressquery", (Object)"true");
        EditProcessObject epo = super.createEpo(request, true);
        request.setAttribute("epo", (Object)epo);
        FormObject foo = new FormObject();
        HashMap<String, List<Option>> OptionMap = new HashMap<String, List<Option>>();
        List<VClass> types = ent.getVClasses(false);
        this.sortForPickList(types, vreq);
        request.setAttribute("types", types);
        try {
            LinkedList<Option> externalIdOptionList = new LinkedList<Option>();
            if (ent.getExternalIds() != null) {
                for (DataPropertyStatement eid : ent.getExternalIds()) {
                    String multiplexedString = "DatapropURI:" + new String(Base64.encodeBase64((byte[])eid.getDatapropURI().getBytes())) + ";Data:" + new String(Base64.encodeBase64((byte[])eid.getData().getBytes()));
                    externalIdOptionList.add(new Option(multiplexedString, eid.getData()));
                }
            }
            OptionMap.put("externalIds", externalIdOptionList);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        try {
            OptionMap.put("VClassURI", FormUtils.makeOptionListFromBeans(vreq.getUnfilteredWebappDaoFactory().getVClassDao().getAllVclasses(), "URI", "PickListName", ent.getVClassURI(), null, false));
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        PropertyInstanceDao piDao = vreq.getUnfilteredWebappDaoFactory().getPropertyInstanceDao();
        try {
            LinkedList<Option> epiOptionList = new LinkedList<Option>();
            Collection<PropertyInstance> epiColl = piDao.getExistingProperties(ent.getURI(), null);
            for (PropertyInstance pi : epiColl) {
                String multiplexedString = "PropertyURI:" + new String(Base64.encodeBase64((byte[])pi.getPropertyURI().getBytes())) + ";ObjectEntURI:" + new String(Base64.encodeBase64((byte[])pi.getObjectEntURI().getBytes()));
                epiOptionList.add(new Option(multiplexedString, pi.getDomainPublic() + " " + pi.getObjectName()));
            }
            OptionMap.put("ExistingPropertyInstances", epiOptionList);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        try {
            Collection<PropertyInstance> piColl = piDao.getAllPossiblePropInstForIndividual(ent.getURI());
            ArrayList<PropertyInstance> piList = new ArrayList<PropertyInstance>();
            piList.addAll(piColl);
            OptionMap.put("PropertyURI", FormUtils.makeOptionListFromBeans(piList, "PropertyURI", "DomainPublic", null, null, false));
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        foo.setOptionLists(OptionMap);
        epo.setFormObject(foo);
        request.setAttribute("epoKey", (Object)epo.getKey());
        request.setAttribute("entityWebapp", (Object)ent);
        request.setAttribute("title", (Object)"Individual Control Panel");
        request.setAttribute("css", (Object)("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + application.getThemeDir() + "css/edit.css\"/>"));
        request.setAttribute("scripts", (Object)"/templates/edit/specific/ents_edit_head.jsp");
        try {
            JSPPageHandler.renderBasicPage(request, response, "/templates/edit/specific/ents_edit.jsp");
        }
        catch (Exception e) {
            log.error((Object)"EntityEditController could not forward to view.");
            log.error((Object)e.getMessage());
            log.error((Object)e.getStackTrace());
        }
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        log.trace((Object)("Please don't POST to the " + this.getClass().getName() + ". Use GET instead as there should be no change of state."));
        this.doGet(request, response);
    }
}

