/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vedit.forwarder.PageForwarder;
import edu.cornell.mannlib.vedit.util.FormUtils;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.Datatype;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.DatatypeDao;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.io.IOException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="DatatypeRetryController", urlPatterns={"/datatype_retry"})
public class DatatypeRetryController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)DatatypeRetryController.class.getName());

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(req, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        VitroRequest request = new VitroRequest(req);
        EditProcessObject epo = super.createEpo((HttpServletRequest)request);
        DatatypeDao dDao = request.getUnfilteredWebappDaoFactory().getDatatypeDao();
        epo.setDataAccessObject(dDao);
        Datatype objectForEditing = null;
        String action = "";
        if (request.getParameter("id") != null) {
            int id = Integer.parseInt(request.getParameter("id"));
            if (id > 0) {
                try {
                    log.debug((Object)("Trying to retrieve datatype " + id));
                    objectForEditing = dDao.getDatatypeById(id);
                    action = "update";
                }
                catch (NullPointerException e) {
                    log.error((Object)"Need to implement 'record not found' error message.");
                }
            }
        } else {
            action = "insert";
            objectForEditing = new Datatype();
        }
        epo.setOriginalBean(objectForEditing);
        Object[] simpleMaskPair = new Object[]{"Id", objectForEditing.getId()};
        epo.getSimpleMask().add(simpleMaskPair);
        try {
            Class[] args = new Class[]{Integer.TYPE};
            epo.setGetMethod(dDao.getClass().getDeclaredMethod("getDatatypeById", args));
        }
        catch (NoSuchMethodException e) {
            log.error((Object)"EntityRetryController could not find the entityById method in the facade");
        }
        epo.setPostInsertPageForwarder(new DatatypeInsertPageForwarder());
        epo.setPostDeletePageForwarder(new DatatypeDeletePageForwarder());
        FormObject foo = new FormObject();
        epo.setFormObject(foo);
        FormUtils.populateFormFromBean(objectForEditing, action, foo);
        request.setAttribute("scripts", "/templates/edit/formBasic.js");
        request.setAttribute("formJsp", "/templates/edit/specific/datatype_retry.jsp");
        request.setAttribute("title", "Datatype Editing Form");
        request.setAttribute("_action", action);
        request.setAttribute("unqualifiedClassName", "Datatype");
        this.setRequestAttributes((HttpServletRequest)request, epo);
        try {
            JSPPageHandler.renderBasicPage((HttpServletRequest)request, response, "/templates/edit/formBasic.jsp");
        }
        catch (Exception e) {
            log.error((Object)"VclassRetryController could not forward to view.");
            log.error((Object)e.getMessage());
            log.error((Object)e.getStackTrace());
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doPost(request, response);
    }

    class DatatypeDeletePageForwarder
    implements PageForwarder {
        DatatypeDeletePageForwarder() {
        }

        @Override
        public void doForward(HttpServletRequest request, HttpServletResponse response, EditProcessObject epo) {
            String newDtpUrl = "fetch?queryspec=private_datatypes";
            Datatype dtp = (Datatype)epo.getNewBean();
            try {
                response.sendRedirect(newDtpUrl);
            }
            catch (IOException ioe) {
                log.error((Object)"DatatypeInsertPageForwarder could not send redirect.");
            }
        }
    }

    class DatatypeInsertPageForwarder
    implements PageForwarder {
        DatatypeInsertPageForwarder() {
        }

        @Override
        public void doForward(HttpServletRequest request, HttpServletResponse response, EditProcessObject epo) {
            String newDtpUrl = "fetch?queryspec=private_datatypev&postGenLimit=-1&linkwhere=datatypes.id=";
            Datatype dtp = (Datatype)epo.getNewBean();
            newDtpUrl = newDtpUrl + dtp.getId();
            try {
                response.sendRedirect(newDtpUrl);
            }
            catch (IOException ioe) {
                log.error((Object)"DatatypeInsertPageForwarder could not send redirect.");
            }
        }
    }
}

