/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore;

import edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore.DumpNode;
import edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore.DumpParser;
import edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore.DumpQuad;
import edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore.NQuadLineSplitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;

public class NquadsParser
implements DumpParser {
    private final BufferedReader r;

    public NquadsParser(InputStream is) throws IOException {
        this.r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
    }

    @Override
    public void close() throws IOException {
        this.r.close();
    }

    @Override
    public Iterator<DumpQuad> iterator() {
        return new NQIterator();
    }

    private class NQIterator
    implements Iterator<DumpQuad> {
        private DumpQuad next = null;

        NQIterator() {
            this.lookAhead();
        }

        private void lookAhead() {
            this.next = null;
            String line = null;
            try {
                do {
                    if ((line = NquadsParser.this.r.readLine()) != null) continue;
                    return;
                } while (line.trim().startsWith("#"));
            }
            catch (IOException e) {
                return;
            }
            this.next = this.parseLine(line);
        }

        private DumpQuad parseLine(String line) {
            try {
                List<String> strings = this.parseNodeStrings(line);
                int stringCount = strings.size();
                if (stringCount != 3 && stringCount != 4) {
                    throw new DumpParser.BadInputException("Input line is invalid: has " + stringCount + " groups: '" + line + "' ==> " + strings);
                }
                DumpNode s = DumpNode.fromNquad(strings.get(0));
                DumpNode p = DumpNode.fromNquad(strings.get(1));
                DumpNode o = DumpNode.fromNquad(strings.get(2));
                DumpNode g = DumpNode.fromNquad(stringCount == 4 ? strings.get(3) : null);
                return new DumpQuad(s, p, o, g);
            }
            catch (DumpNode.BadNodeException e) {
                throw new DumpParser.BadInputException("unable to parse node, line='" + line + "'", e);
            }
        }

        private List<String> parseNodeStrings(String line) throws DumpNode.BadNodeException {
            return new NQuadLineSplitter(line).split();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public DumpQuad next() {
            DumpQuad dq = this.next;
            this.lookAhead();
            return dq;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

