/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore.DumpModelsAction;
import edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore.RestoreModelsAction;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

@WebServlet(name="DumpRestoreController", urlPatterns={"/dumpRestore/*"})
public class DumpRestoreController
extends FreemarkerHttpServlet {
    private static final RequestedAction REQUIRED_ACTION = SimplePermission.USE_ADVANCED_DATA_TOOLS_PAGES.ACTION;
    static final String ACTION_DUMP = "/dump";
    static final String ACTION_RESTORE = "/restore";
    static final String ACTION_SELECT = "/select";
    static final String PARAMETER_WHICH = "which";
    static final String PARAMETER_SOURCE_FILE = "sourceFile";
    static final String PARAMETER_PURGE = "purge";
    static final String ATTRIBUTE_TRIPLE_COUNT = "tripleCount";
    private static final String TEMPLATE_NAME = "datatools-dumpRestore.ftl";

    @Override
    public long maximumMultipartFileSize() {
        long gigabyte = 0x40000000L;
        return 100L * gigabyte;
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        if (!this.isAuthorizedToDisplayPage(req, resp, REQUIRED_ACTION)) {
            return;
        }
        try {
            String action = req.getPathInfo();
            if (ACTION_SELECT.equals(action)) {
                new DumpModelsAction(req, resp).redirectToFilename();
            } else if (StringUtils.startsWith((CharSequence)action, (CharSequence)ACTION_DUMP)) {
                new DumpModelsAction(req, resp).dumpModels();
            } else {
                super.doGet(req, resp);
            }
        }
        catch (BadRequestException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        if (!PolicyHelper.isAuthorizedForActions(req, new AuthorizationRequest[]{REQUIRED_ACTION})) {
            resp.sendError(403);
        }
        try {
            if (ACTION_RESTORE.equals(req.getPathInfo())) {
                long tripleCount = new RestoreModelsAction(req, resp).restoreModels();
                req.setAttribute(ATTRIBUTE_TRIPLE_COUNT, (Object)tripleCount);
                super.doGet(req, resp);
            } else {
                resp.sendError(405);
            }
        }
        catch (BadRequestException | RDFServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) throws Exception {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("selectUrl", UrlBuilder.getUrl(vreq.getServletPath() + ACTION_SELECT));
        bodyMap.put("restoreUrl", UrlBuilder.getUrl(vreq.getServletPath() + ACTION_RESTORE));
        Object tripleCount = vreq.getAttribute(ATTRIBUTE_TRIPLE_COUNT);
        if (tripleCount instanceof Long) {
            bodyMap.put(ATTRIBUTE_TRIPLE_COUNT, tripleCount);
        }
        return new TemplateResponseValues(TEMPLATE_NAME, bodyMap);
    }

    static class BadRequestException
    extends Exception {
        public BadRequestException(String message) {
            super(message);
        }
    }
}

