/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.authenticate;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.ExternalAuthHelper;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.RedirectResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FakeExternalAuthController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog(FakeExternalAuthController.class);
    private static final String URL_FAKE_CONTROLLER = "/admin/fakeExternalAuth";
    private static final String URL_EXTERNAL_AUTH_RETURN = "/loginExternalAuthReturn";
    private static final String TEMPLATE_DEFAULT = "fakeExternalAuth.ftl";
    private static final String PARAMETER_USERNAME = "username";
    private static final String PARAMETER_CANCEL = "cancel";

    public void init() throws ServletException {
        log.debug((Object)"storing the bean.");
        ExternalAuthHelper.setBean(this.getServletContext(), new FakeExternalAuthHelper(null));
        new SecurityWarning().warn(this.getServletContext(), "The FakeExternalAuthController is enabled. If that's not what you wanted, go into web.xml and comment it out.");
    }

    @Override
    protected String getTitle(String siteName, VitroRequest vreq) {
        return "Fake external login " + siteName;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        if (this.isCancelRequested(vreq)) {
            log.debug((Object)"cancelling.");
            this.setFakeExternalAuthHelper((HttpServletRequest)vreq, null);
            return this.makeRedirectResponse();
        }
        if (this.isUsernameSupplied(vreq)) {
            log.debug((Object)("faking as '" + this.getUsername(vreq) + "'"));
            this.setFakeExternalAuthHelper((HttpServletRequest)vreq, this.getUsername(vreq));
            return this.makeRedirectResponse();
        }
        log.debug((Object)"show the form.");
        return this.makeShowFormResponse();
    }

    private boolean isCancelRequested(VitroRequest vreq) {
        String cancelString = vreq.getParameter(PARAMETER_CANCEL);
        return cancelString != null && !cancelString.isEmpty();
    }

    private void setFakeExternalAuthHelper(HttpServletRequest req, String username) {
        ExternalAuthHelper.setBean(req.getSession().getServletContext(), new FakeExternalAuthHelper(username));
    }

    private boolean isUsernameSupplied(VitroRequest vreq) {
        String username = this.getUsername(vreq);
        return username != null && !username.isEmpty();
    }

    private String getUsername(VitroRequest vreq) {
        return vreq.getParameter(PARAMETER_USERNAME);
    }

    private TemplateResponseValues makeShowFormResponse() {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("controllerUrl", UrlBuilder.getUrl(URL_FAKE_CONTROLLER));
        return new TemplateResponseValues(TEMPLATE_DEFAULT, body);
    }

    private RedirectResponseValues makeRedirectResponse() {
        return new RedirectResponseValues(URL_EXTERNAL_AUTH_RETURN);
    }

    private static class SecurityWarning
    implements ServletContextListener {
        private SecurityWarning() {
        }

        void warn(ServletContext ctx, String message) {
            StartupStatus.getBean(ctx).warning(this, message);
        }

        public void contextInitialized(ServletContextEvent arg0) {
        }

        public void contextDestroyed(ServletContextEvent arg0) {
        }
    }

    public static class FakeExternalAuthHelper
    extends ExternalAuthHelper {
        private final String username;

        private FakeExternalAuthHelper(String username) {
            super(null, null);
            this.username = username;
        }

        @Override
        public String buildExternalAuthRedirectUrl(String returnUrl) {
            int lastSlash = returnUrl.lastIndexOf("/");
            String homeUrl = returnUrl.substring(0, lastSlash);
            String url = homeUrl + FakeExternalAuthController.URL_FAKE_CONTROLLER;
            log.debug((Object)("externalAuth URL is '" + url + "'"));
            return url;
        }

        @Override
        public String getExternalAuthId(HttpServletRequest request) {
            log.debug((Object)("external username is '" + this.username + "'"));
            return this.username;
        }

        @Override
        public String toString() {
            return "FakeExternalAuthHelper[username='" + this.username + "']";
        }
    }
}

