/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery;

import edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery.ResultSetMediaType;
import edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery.SparqlQueryApiExecutor;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.utils.http.AcceptHeaderParsingException;
import edu.cornell.mannlib.vitro.webapp.utils.http.ContentTypeUtil;
import edu.cornell.mannlib.vitro.webapp.utils.http.NotAcceptableException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.sparql.resultset.ResultsFormat;

abstract class SparqlQueryApiResultSetProducer
extends SparqlQueryApiExecutor {
    protected final ResultSetMediaType mediaType;

    public SparqlQueryApiResultSetProducer(RDFService rdfService, String queryString, String acceptHeader) throws AcceptHeaderParsingException, NotAcceptableException {
        super(rdfService, queryString);
        Collection<String> contentTypes = ResultSetMediaType.contentTypes();
        String bestType = ContentTypeUtil.bestContentType(acceptHeader, contentTypes);
        this.mediaType = ResultSetMediaType.fromContentType(bestType);
    }

    @Override
    public String getMediaType() {
        return this.mediaType.getContentType();
    }

    @Override
    public void executeAndFormat(OutputStream out) throws RDFServiceException, IOException {
        InputStream rawResult = this.getRawResultStream();
        if (this.mediaType.isNativeFormat()) {
            IOUtils.copy((InputStream)rawResult, (OutputStream)out);
        } else if (this.mediaType == ResultSetMediaType.TSV) {
            this.pipeWithReplacement(rawResult, out);
        } else {
            ResultSet rs = ResultSetFactory.fromJSON((InputStream)rawResult);
            ResultsFormat format = ResultsFormat.lookup((String)this.mediaType.getJenaResponseFormat());
            ResultSetFormatter.output((OutputStream)out, (ResultSet)rs, (ResultsFormat)format);
        }
    }

    private void pipeWithReplacement(InputStream in, OutputStream out) throws IOException {
        int size;
        byte[] buffer = new byte[4096];
        while ((size = in.read(buffer)) > -1) {
            for (int i = 0; i < size; ++i) {
                if (buffer[i] != 44) continue;
                buffer[i] = 9;
            }
            out.write(buffer, 0, size);
        }
    }

    protected abstract InputStream getRawResultStream() throws RDFServiceException;
}

