/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.admin;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import java.util.HashMap;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.annotation.WebServlet;

@WebServlet(name="ShowConfiguration", urlPatterns={"/admin/showConfiguration"})
public class ShowConfiguration
extends FreemarkerHttpServlet {
    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.SEE_CONFIGURATION.ACTION;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("configurationProperties", this.getConfigurationProperties(vreq));
        body.put("javaSystemProperties", this.getSystemProperties());
        return new TemplateResponseValues("admin-showConfiguration.ftl", body);
    }

    private SortedMap<String, String> getConfigurationProperties(VitroRequest vreq) {
        ConfigurationProperties props = ConfigurationProperties.getBean((ServletRequest)vreq);
        TreeMap<String, String> map = new TreeMap<String, String>(props.getPropertyMap());
        for (String key : map.keySet()) {
            if (!key.toLowerCase().endsWith("password")) continue;
            map.put(key, "********");
        }
        return map;
    }

    private SortedMap<String, String> getSystemProperties() {
        Properties props = System.getProperties();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String key : props.stringPropertyNames()) {
            map.put(key, props.getProperty(key));
        }
        return map;
    }
}

