/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.user;

import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsPage;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.user.UserAccountsFirstTimeExternalPage;
import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailFactory;
import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailMessage;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Message;

public abstract class UserAccountsFirstTimeExternalPageStrategy
extends UserAccountsPage {
    private UserAccountsFirstTimeExternalPage page;

    public static UserAccountsFirstTimeExternalPageStrategy getInstance(VitroRequest vreq, UserAccountsFirstTimeExternalPage page, boolean emailEnabled) {
        if (emailEnabled) {
            return new EmailStrategy(vreq, page);
        }
        return new NoEmailStrategy(vreq, page);
    }

    public UserAccountsFirstTimeExternalPageStrategy(VitroRequest vreq, UserAccountsFirstTimeExternalPage page) {
        super(vreq);
        this.page = page;
    }

    public abstract void addMoreBodyValues(Map<String, Object> var1);

    public abstract void notifyUser(UserAccount var1);

    public static class NoEmailStrategy
    extends UserAccountsFirstTimeExternalPageStrategy {
        public NoEmailStrategy(VitroRequest vreq, UserAccountsFirstTimeExternalPage page) {
            super(vreq, page);
        }

        @Override
        public void addMoreBodyValues(Map<String, Object> body) {
        }

        @Override
        public void notifyUser(UserAccount ua) {
        }
    }

    public static class EmailStrategy
    extends UserAccountsFirstTimeExternalPageStrategy {
        public EmailStrategy(VitroRequest vreq, UserAccountsFirstTimeExternalPage page) {
            super(vreq, page);
        }

        @Override
        public void addMoreBodyValues(Map<String, Object> body) {
            body.put("emailIsEnabled", Boolean.TRUE);
        }

        @Override
        public void notifyUser(UserAccount ua) {
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("userAccount", ua);
            body.put("siteName", this.getSiteName());
            FreemarkerEmailMessage email = FreemarkerEmailFactory.createNewMessage(this.vreq);
            email.addRecipient(Message.RecipientType.TO, ua.getEmailAddress());
            String subject = this.i18n.text("account_created_subject", this.getSiteName());
            email.setSubject(subject);
            body.put("subject", subject);
            body.put("textMessage", this.i18n.text("first_time_external_email_plain_text", new Object[0]));
            body.put("htmlMessage", this.i18n.text("first_time_external_email_html_text", new Object[0]));
            email.setBodyMap(body);
            email.processTemplate();
            email.send();
        }
    }
}

