/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies;

public class ProxyRelationshipSelectionCriteria {
    public static final int DEFAULT_RELATIONSHIPS_PER_PAGE = 20;
    public static final ProxyRelationshipSelectionCriteria DEFAULT_CRITERIA = new ProxyRelationshipSelectionCriteria(20, 1, ProxyRelationshipView.BY_PROXY, "");
    private final int relationshipsPerPage;
    private final int pageIndex;
    private final ProxyRelationshipView viewBy;
    private final String searchTerm;

    public ProxyRelationshipSelectionCriteria(int relationshipsPerPage, int pageIndex, ProxyRelationshipView viewBy, String searchTerm) {
        if (relationshipsPerPage <= 0) {
            throw new IllegalArgumentException("relationshipsPerPage must be a positive integer, not " + relationshipsPerPage);
        }
        this.relationshipsPerPage = relationshipsPerPage;
        if (pageIndex <= 0) {
            throw new IllegalArgumentException("pageIndex must be a positive integer, not " + pageIndex);
        }
        this.pageIndex = pageIndex;
        this.viewBy = this.nonNull(viewBy, ProxyRelationshipView.DEFAULT_VIEW);
        this.searchTerm = this.nonNull(searchTerm, "");
    }

    public int getRelationshipsPerPage() {
        return this.relationshipsPerPage;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public ProxyRelationshipView getViewBy() {
        return this.viewBy;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    private <T> T nonNull(T t, T nullValue) {
        return t == null ? nullValue : t;
    }

    public String toString() {
        return "ProxyRelationshipSelectionCriteria[relationshipsPerPage=" + this.relationshipsPerPage + ", pageIndex=" + this.pageIndex + ", viewBy=" + (Object)((Object)this.viewBy) + "', searchTerm='" + this.searchTerm + "']";
    }

    public static enum ProxyRelationshipView {
        BY_PROXY,
        BY_PROFILE;

        public static ProxyRelationshipView DEFAULT_VIEW;

        public static ProxyRelationshipView fromKeyword(String keyword) {
            if (keyword == null) {
                return DEFAULT_VIEW;
            }
            for (ProxyRelationshipView v : ProxyRelationshipView.values()) {
                if (!v.toString().equals(keyword)) continue;
                return v;
            }
            return DEFAULT_VIEW;
        }

        static {
            DEFAULT_VIEW = BY_PROXY;
        }
    }
}

