/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.AbstractPageHandler;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManageProxiesEditPage
extends AbstractPageHandler {
    private static final Log log = LogFactory.getLog(ManageProxiesEditPage.class);
    private static final String PARAMETER_DELETE_PROXY = "deleteProxy";
    private static final String PARAMETER_EDIT_PROFILES = "modifyProfileList";
    private static final String PARAMETER_PROXY_URI = "proxyUri";
    private static final String PARAMETER_PROFILE_URI = "profileUri";
    private Function function;
    private List<String> proxyUris;
    private List<UserAccount> proxyAccounts;
    private List<String> profileUris;
    private boolean valid = true;

    protected ManageProxiesEditPage(VitroRequest vreq) {
        super(vreq);
        this.parseParameters();
    }

    private void parseParameters() {
        this.proxyUris = this.getStringParameters(PARAMETER_PROXY_URI);
        this.profileUris = this.getStringParameters(PARAMETER_PROFILE_URI);
        try {
            if (this.isFlagOnRequest(PARAMETER_EDIT_PROFILES)) {
                this.function = Function.EDIT_PROFILES;
                this.proxyAccounts = this.findSingleProxyAccount(PARAMETER_EDIT_PROFILES);
                this.validateProfileUris();
            } else if (this.isFlagOnRequest(PARAMETER_DELETE_PROXY)) {
                this.function = Function.DELETE_PROXY;
                this.proxyAccounts = this.findSingleProxyAccount(PARAMETER_EDIT_PROFILES);
            } else {
                this.function = Function.UNKNOWN;
            }
        }
        catch (AbstractPageHandler.InvalidParametersException e) {
            log.error((Object)e.getMessage());
            this.valid = false;
        }
    }

    private List<UserAccount> findSingleProxyAccount(String functionParameter) throws AbstractPageHandler.InvalidParametersException {
        if (this.proxyUris.isEmpty()) {
            throw new AbstractPageHandler.InvalidParametersException("'" + functionParameter + "' was requested, but no '" + PARAMETER_PROXY_URI + "' parameter was found.");
        }
        if (this.proxyUris.size() > 1) {
            throw new AbstractPageHandler.InvalidParametersException("'" + functionParameter + "' was requested, but there were " + this.proxyUris.size() + "'" + PARAMETER_PROXY_URI + "' parameters.");
        }
        String proxyUri = this.proxyUris.get(0);
        UserAccount proxy = this.userAccountsDao.getUserAccountByUri(proxyUri);
        if (proxy == null) {
            throw new AbstractPageHandler.InvalidParametersException("Found no User Account for proxyUri='" + proxyUri + "'");
        }
        return Collections.singletonList(proxy);
    }

    private void validateProfileUris() throws AbstractPageHandler.InvalidParametersException {
        for (String profileUri : this.profileUris) {
            Individual ind = this.indDao.getIndividualByURI(profileUri);
            if (ind != null) continue;
            throw new AbstractPageHandler.InvalidParametersException("Found no Individual for profileUri='" + profileUri + "'");
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void applyEdits() {
        if (!this.valid) {
            return;
        }
        if (this.function == Function.DELETE_PROXY) {
            this.deleteRelationshipsFromProxy();
        } else if (this.function == Function.EDIT_PROFILES) {
            this.editRelationshipsOnProxy();
        }
    }

    private void deleteRelationshipsFromProxy() {
        UserAccount proxyAccount = this.proxyAccounts.get(0);
        proxyAccount.setProxiedIndividualUris(Collections.emptyList());
        this.userAccountsDao.updateUserAccount(proxyAccount);
    }

    private void editRelationshipsOnProxy() {
        UserAccount proxyAccount = this.proxyAccounts.get(0);
        proxyAccount.setProxiedIndividualUris(this.profileUris);
        this.userAccountsDao.updateUserAccount(proxyAccount);
    }

    private static enum Function {
        DELETE_PROXY,
        EDIT_PROFILES,
        UNKNOWN;

    }
}

