/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.admin.ajax;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.beans.SelfEditingConfiguration;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.ajax.AbstractAjaxResponder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.AutoCompleteWords;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.FieldMap;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.SearchQueryUtils;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.SearchResponseFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;

class ProfileAutoCompleter
extends AbstractAjaxResponder
implements SearchResponseFilter {
    private static final Log log = LogFactory.getLog(ProfileAutoCompleter.class);
    private static final String PARAMETER_SEARCH_TERM = "term";
    private static final String PARAMETER_ETERNAL_AUTH_ID = "externalAuthId";
    private static final Collection<String> profileTypes = Collections.singleton("http://xmlns.com/foaf/0.1/Person");
    private static final String WORD_DELIMITER = "[, ]+";
    private static final FieldMap RESPONSE_FIELDS = SearchQueryUtils.fieldMap().put("URI", "uri").put("nameRaw", "label");
    private static final Syntax SYNTAX = Syntax.syntaxARQ;
    private static final String QUERY_TEMPLATE = "SELECT DISTINCT ?id \nWHERE {\n    <%uri%> <%matchingPropertyUri%> ?id . \n} \nLIMIT 1 \n";
    private final String externalAuthId = this.getStringParameter("externalAuthId", "");
    private final String selfEditingIdMatchingProperty;
    private final String term = this.getStringParameter("term", "");
    private final AutoCompleteWords searchWords = SearchQueryUtils.parseForAutoComplete(this.term, "[, ]+");
    private final OntModel fullModel;

    public ProfileAutoCompleter(HttpServlet parent, VitroRequest vreq, HttpServletResponse resp) {
        super(parent, vreq, resp);
        this.selfEditingIdMatchingProperty = SelfEditingConfiguration.getBean((ServletRequest)vreq).getMatchingPropertyUri();
        this.fullModel = vreq.getJenaOntModel();
    }

    @Override
    public String prepareResponse() throws IOException {
        if (this.term.isEmpty()) {
            return "[]";
        }
        if (this.selfEditingIdMatchingProperty == null) {
            return "[]";
        }
        if (this.selfEditingIdMatchingProperty.isEmpty()) {
            return "[]";
        }
        try {
            SearchQuery query = this.buildSearchQuery();
            SearchResponse queryResponse = this.executeSearchQuery(query);
            List<Map<String, String>> maps = SearchQueryUtils.parseAndFilterResponse(queryResponse, RESPONSE_FIELDS, this, 30);
            this.addProfileUrls(maps);
            String response = this.assembleJsonResponse(maps);
            log.debug((Object)response);
            return response;
        }
        catch (SearchEngineException e) {
            log.error((Object)"Failed to get basic profile info", (Throwable)e);
            return "[]";
        }
    }

    private SearchQuery buildSearchQuery() {
        SearchQuery q = ApplicationUtils.instance().getSearchEngine().createQuery();
        q.addFields("nameRaw", "URI");
        q.addSortField("nameLowercaseSingleValued", SearchQuery.Order.ASC);
        q.addFilterQuery(SearchQueryUtils.assembleConjunctiveQuery("type", profileTypes, SearchQueryUtils.Conjunction.OR));
        q.setStart(0);
        q.setRows(10000);
        q.setQuery(this.searchWords.assembleQuery("nameUnstemmed", "acNameStemmed"));
        return q;
    }

    private SearchResponse executeSearchQuery(SearchQuery query) throws SearchEngineException {
        SearchEngine search = ApplicationUtils.instance().getSearchEngine();
        return search.query(query);
    }

    private void addProfileUrls(List<Map<String, String>> maps) {
        for (Map<String, String> map : maps) {
            String uri = map.get("uri");
            String url = UrlBuilder.getIndividualProfileUrl(uri, this.vreq);
            map.put("url", url);
        }
    }

    @Override
    public boolean accept(Map<String, String> map) {
        String uri = map.get("uri");
        if (uri == null) {
            log.debug((Object)"reject result with no uri");
            return false;
        }
        String id = this.runQueryAndGetId(uri);
        if (id.isEmpty() || id.equals(this.externalAuthId)) {
            log.debug((Object)("accept '" + uri + "' with id='" + id + "'"));
            return true;
        }
        log.debug((Object)("reject '" + uri + "' with id='" + id + "'"));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runQueryAndGetId(String uri) {
        String queryString = QUERY_TEMPLATE.replace("%matchingPropertyUri%", this.selfEditingIdMatchingProperty).replace("%uri%", uri);
        try (QueryExecution qe = null;){
            Query query = QueryFactory.create((String)queryString, (Syntax)SYNTAX);
            qe = QueryExecutionFactory.create((Query)query, (Model)this.fullModel);
            ResultSet resultSet = qe.execSelect();
            if (!resultSet.hasNext()) {
                String string = "";
                return string;
            }
            QuerySolution solution = resultSet.next();
            Literal literal = solution.getLiteral("id");
            if (literal == null) {
                String string = "";
                return string;
            }
            String string = literal.getString();
            return string;
        }
    }
}

