/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.config;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.application.BuildProperties;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationPropertiesImpl;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationPropertiesSetup
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(ConfigurationPropertiesSetup.class);
    private static final String FILE_RUNTIME_PROPERTIES = "runtime.properties";
    private static final String VHD_CONFIGURATION_PROPERTY = "vitro.home";
    static final String RP_MULTIPLE = "rp.multiple";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        StartupStatus ss = StartupStatus.getBean(ctx);
        try {
            InputStream stream = null;
            try {
                File vitroHomeDir = ApplicationUtils.instance().getHomeDirectory().getPath().toFile();
                File vitroHomeDirConfig = new File(vitroHomeDir.getPath().concat(File.separator).concat("config"));
                String rpfLocation = this.findMultipleRuntimePropertiesFiles(vitroHomeDir, vitroHomeDirConfig);
                File runtimePropertiesFile = this.locateRuntimePropertiesFile(vitroHomeDir, vitroHomeDirConfig, ss);
                stream = new FileInputStream(runtimePropertiesFile);
                Map<String, String> preempts = this.createPreemptiveProperties(VHD_CONFIGURATION_PROPERTY, vitroHomeDir, RP_MULTIPLE, rpfLocation);
                ConfigurationPropertiesImpl bean = new ConfigurationPropertiesImpl(stream, preempts, new BuildProperties(ctx).getMap());
                ConfigurationProperties.setBean(ctx, bean);
                ss.info(this, "Loaded " + bean.getPropertyMap().size() + " properties.");
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e, (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            ss.fatal(this, e.getMessage(), e);
        }
    }

    private String findMultipleRuntimePropertiesFiles(File vitroHomeDir, File vitroHomeDirConfig) {
        File rpf = new File(vitroHomeDir, FILE_RUNTIME_PROPERTIES);
        File rpfc = new File(vitroHomeDirConfig, FILE_RUNTIME_PROPERTIES);
        if (rpf.exists() && !rpfc.exists()) {
            return "home";
        }
        if (rpf.exists() && rpfc.exists()) {
            return "both";
        }
        if (rpfc.exists()) {
            return "config";
        }
        throw new IllegalStateException("Did not find 'runtime.properties' in vitro home directory '" + vitroHomeDir + "' or config directory '" + vitroHomeDirConfig + "'");
    }

    private File locateRuntimePropertiesFile(File vitroHomeDir, File vitroHomeDirConfig, StartupStatus ss) {
        File rpf = new File(vitroHomeDir, FILE_RUNTIME_PROPERTIES);
        File rpfc = new File(vitroHomeDirConfig, FILE_RUNTIME_PROPERTIES);
        if (!rpf.exists()) {
            rpf = rpfc;
        }
        if (!rpf.isFile()) {
            throw new IllegalStateException("'" + rpf.getPath() + "' is not a file.");
        }
        if (!rpf.canRead()) {
            throw new IllegalStateException("Cannot read '" + rpf.getPath() + "'.");
        }
        ss.info(this, "Loading runtime properties from '" + rpf.getPath() + "'");
        return rpf;
    }

    private Map<String, String> createPreemptiveProperties(String propertyVitroHome, File vitroHomeDir, String propertyRpfMultiple, String rpfLocation) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(propertyVitroHome, vitroHomeDir.getAbsolutePath());
        map.put(propertyRpfMultiple, rpfLocation);
        return map;
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

