/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.beans;

import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import java.text.Collator;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VClassGroup
extends LinkedList<VClass>
implements Comparable<VClassGroup> {
    private static final Log log = LogFactory.getLog((String)VClassGroup.class.getName());
    private String URI = null;
    private String namespace = null;
    private String localName = null;
    private String publicName = null;
    private int displayRank = -1;
    private int individualCount = -1;

    public boolean isIndividualCountSet() {
        return this.individualCount >= 0;
    }

    public int getIndividualCount() {
        return this.individualCount;
    }

    public void setIndividualCount(int individualCount) {
        this.individualCount = individualCount;
    }

    public int getDisplayRank() {
        return this.displayRank;
    }

    public void setDisplayRank(int displayRank) {
        this.displayRank = displayRank;
    }

    public VClassGroup() {
    }

    public VClassGroup(String uri, String name) {
        this(uri, name, 0);
    }

    public VClassGroup(String uri, String name, int rank) {
        this.URI = uri;
        BaseResourceBean theURI = new BaseResourceBean(uri);
        this.namespace = theURI.getNamespace();
        this.localName = theURI.getLocalName();
        this.displayRank = rank;
        this.publicName = name;
    }

    public VClassGroup(VClassGroup vcg) {
        this.URI = vcg.URI;
        this.namespace = vcg.namespace;
        this.localName = vcg.localName;
        this.publicName = vcg.publicName;
        this.displayRank = vcg.displayRank;
        this.individualCount = vcg.individualCount;
    }

    public String getURI() {
        return this.URI;
    }

    public void setURI(String URI) {
        this.URI = URI;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String ns) {
        this.namespace = ns;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String ln) {
        this.localName = ln;
    }

    public String getPublicName() {
        return this.publicName;
    }

    public void setPublicName(String name) {
        this.publicName = name;
    }

    public void setVitroClassList(List<VClass> list) {
        this.clear();
        this.addAll(list);
    }

    public List<VClass> getVitroClassList() {
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof VClassGroup) {
            VClassGroup other = (VClassGroup)obj;
            return other.getURI().equals(this.getURI());
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.getURI().hashCode();
    }

    @Override
    public String toString() {
        return this.getPublicName() + " URI(" + this.getURI() + ") with " + this.size();
    }

    public static void removeEmptyClassGroups(Map groups) {
        if (groups == null) {
            return;
        }
        LinkedList keysToRemove = new LinkedList();
        for (Object key : groups.keySet()) {
            Object grp = groups.get(key);
            if (grp == null || !(grp instanceof AbstractCollection) || !((AbstractCollection)grp).isEmpty()) continue;
            keysToRemove.add(key);
        }
        Iterator<Object> it = keysToRemove.iterator();
        while (it.hasNext()) {
            groups.remove(it.next());
        }
    }

    @Override
    public int compareTo(VClassGroup o2) {
        Collator collator = Collator.getInstance();
        if (o2 == null) {
            log.error((Object)"object NULL in DisplayComparator()");
            return 0;
        }
        int diff = this.getDisplayRank() - o2.getDisplayRank();
        if (diff == 0) {
            if (this.getPublicName() == null) {
                if (o2.getPublicName() == null) {
                    return 0;
                }
                return 1;
            }
            if (o2.getPublicName() == null) {
                return -1;
            }
            return collator.compare(this.getPublicName(), o2.getPublicName());
        }
        return diff;
    }
}

