/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.policy.BasicPolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ServletPolicyList;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Authorization;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyIface;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AbstractObjectPropertyStatementAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.DropObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.EditObjectPropertyStatement;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class RestrictHomeMenuItemEditingPolicy
implements PolicyIface {
    @Override
    public PolicyDecision isAuthorized(IdentifierBundle whoToAuth, RequestedAction whatToAuth) {
        if (whatToAuth instanceof EditObjectPropertyStatement) {
            return this.isAuthorized((EditObjectPropertyStatement)whatToAuth);
        }
        if (whatToAuth instanceof DropObjectPropertyStatement) {
            return this.isAuthorized((DropObjectPropertyStatement)whatToAuth);
        }
        return this.notHandled();
    }

    private PolicyDecision isAuthorized(AbstractObjectPropertyStatementAction whatToAuth) {
        if (whatToAuth.getPredicateUri().equals("http://vitro.mannlib.cornell.edu/ontologies/display/1.1#hasElement") && whatToAuth.getObjectUri().equals("http://vitro.mannlib.cornell.edu/ontologies/display/1.1#HomeMenuItem")) {
            return this.notAuthorized();
        }
        return this.notHandled();
    }

    private BasicPolicyDecision notHandled() {
        return new BasicPolicyDecision(Authorization.INCONCLUSIVE, "Doesn't handle this type of request");
    }

    private BasicPolicyDecision notAuthorized() {
        return new BasicPolicyDecision(Authorization.UNAUTHORIZED, "Can't edit home menu item.");
    }

    public static class Setup
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
            ServletPolicyList.addPolicyAtFront(sce.getServletContext(), new RestrictHomeMenuItemEditingPolicy());
        }

        public void contextDestroyed(ServletContextEvent ctx) {
        }
    }
}

